/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_common.QAsnAddress;
import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnIPV6Config;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IIfmAssociateFunctionExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnAddressTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnIPAddressTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnIPV6ConfigTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec.QAsnSAPSpecTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QAsnSapTranslator
extends AbstractAsnTranslator<QAsnSAP, Interface> {
    public static final Object[][] z_qasnSAPMasks = new Object[][]{{"add", 1}, {"delete", 2}, {"poLinkProtocol", 4}, {"address", 8}, {"description", 16}, {"poQos", 32}, {"deployStatus", 128}, {"enableStatus", 256}, {"runningStatus", 512}, {"mtu", 1024}, {"poUserLabel", 2048}, {"autopickSapID", 4096}};
    private static final Logger logger = LoggerFactory.getLogger(QAsnSapTranslator.class);
    private static final Object[][] z_iinterfaceMasks = new Object[][]{{"ifLinkProtocol", 4}, {"ipv4Addresss", 8}, {"ipv6Addresss", 64}, {"ifDescr", 16}, {"deployStatus", 128}, {"ifAdminStatus", 256}, {"ifOperStatus", 512}, {"ifMtu", 1024}};
    private IAsnTranslator<QAsnAddress, Interface> qasnAddressTranslator = new QAsnAddressTranslator();
    private IAsnTranslator<QAsnIPV6Config, Interface> qasnIPV6ConfigTranslator = new QAsnIPV6ConfigTranslator();
    private QAsnSAPSpecTranslator qasnSAPSpecTranslator = new QAsnSAPSpecTranslator();

    public void decode(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        this.decodeInterface(asn, mo, context);
        List funSet = ExtendPointServiceMgr.getInstance().getExtendIfmFunction(IIfmAssociateFunctionExtPoint.class);
        if (!CollectionUtils.isEmpty((Collection)funSet)) {
            for (Object obj : funSet) {
                if (!(obj instanceof IIfmAssociateFunctionExtPoint)) continue;
                ((IIfmAssociateFunctionExtPoint)obj).decode((FStruct)asn, mo, context);
            }
        }
        this.setChanged((VmfMO)mo, z_iinterfaceMasks, asn.poOperMask, context);
    }

    public void decodeInterface(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == mo) {
            logger.error("can't decode! asn or mo is null!");
            return;
        }
        this.qasnSAPSpecTranslator.decodeKeyProperties(asn, mo, context);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 1, 2, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            this.decodeIPv4ForDeleteIFM(asn, mo, context);
            return;
        }
        Collection interfaces = DaoFactory.getInstance().getDefaultVmfDao(null).queryByKey(Interface.class, Arrays.asList(mo), false);
        if (!CollectionUtils.isEmpty((Collection)interfaces)) {
            context.getTransactionContext().getChangeRecord(Interface.class).cancelCreate((Object)mo);
        }
        this.qasnSAPSpecTranslator.decodeDescription(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeEnableStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeRunningStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeMtu(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeSubIFNo(asn, mo, context);
        this.qasnSAPSpecTranslator.decodePoSpeed(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeDeployStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.decodePhysicalType(asn, mo, context);
        this.qasnSAPSpecTranslator.decodeAutopickSapID(asn, mo, context);
        context.addProperty(Interface.class.getName(), (Object)mo);
        this.decodeIpv4Address(asn, mo, context);
        this.decodePoIpv6(asn, mo, context);
    }

    private void decodeIPv4ForDeleteIFM(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == asn.address && null == asn.address.addrList) {
            return;
        }
        HashSet<Ipv4Address> ipv4s = mo.getIpv4Addresss();
        if (null == ipv4s) {
            ipv4s = new HashSet<Ipv4Address>();
        }
        QAsnIPAddressTranslator ipAddressTranslator = new QAsnIPAddressTranslator();
        for (QAsnIPAddress addr : asn.address.addrList) {
            Ipv4Address ipv4 = new Ipv4Address();
            ipv4.setDevID(mo.getDevID());
            ipv4.setVrID(mo.getVrID());
            ipv4.setIfName(mo.getIfName());
            try {
                ipAddressTranslator.decode((FStruct)addr, ipv4, context);
                ipv4s.add(ipv4);
            }
            catch (VMFException e) {
                QAsnSapTranslator.getLogger().error("decodeIPv4ForDeleteIFM is fail! " + (Object)((Object)e));
            }
        }
        if (CollectionUtils.isEmpty(ipv4s)) {
            return;
        }
        mo.addIpv4Addresss(ipv4s);
    }

    public void decodeIpv4Address(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.address) {
            return;
        }
        context.addProperty("QAsnSAP_poOperMask", (Object)asn.poOperMask);
        this.qasnAddressTranslator.decode((FStruct)asn.address, (Object)mo, context);
    }

    public void encode(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == mo) {
            logger.error("can't encode! asn or mo is null!");
            return;
        }
        int mask = 0;
        this.qasnSAPSpecTranslator.encodeKeyProperties(asn, mo, context);
        this.encodeInterface(mo, asn, context);
        this.encodeIpv4Address(mo, asn, context);
        this.encodePoIpv6(mo, asn, context);
        List funSet = ExtendPointServiceMgr.getInstance().getExtendIfmFunction(IIfmAssociateFunctionExtPoint.class);
        if (!CollectionUtils.isEmpty((Collection)funSet)) {
            for (Object obj : funSet) {
                if (!(obj instanceof IIfmAssociateFunctionExtPoint)) continue;
                ((IIfmAssociateFunctionExtPoint)obj).encode(mo, (FStruct)asn, context);
            }
        }
        mask |= this.setChangeMask((VmfMO)mo, context, z_iinterfaceMasks);
        mask |= this.setChangeMask(asn.address.poOperMask, z_qasnSAPMasks, "address");
        if (null != asn.poIpv6) {
            mask |= this.setChangeMask(asn.poIpv6.poOperMask, z_qasnSAPMasks, "poIpv6");
        }
        asn.poOperMask = mask;
        asn.poOperResult = this.getQAsnSingleReturn((VmfMO)mo, context);
    }

    public void encodeInterface(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        this.qasnSAPSpecTranslator.encodeDescription(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeEnableStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeRunningStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeMtu(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeSubIFNo(asn, mo, context);
        this.qasnSAPSpecTranslator.encodePoSpeed(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeDeployStatus(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeAutopickSapID(asn, mo, context);
        this.qasnSAPSpecTranslator.encodeMainPortFdn(asn, mo, context);
    }

    public void encodeIpv4Address(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.address) {
            asn.address = new QAsnAddress();
            AsnUtil.setDefaultAsnValue((FStruct)asn.address);
        }
        this.qasnAddressTranslator.encode((Object)mo, (FStruct)asn.address, context);
    }

    public Class<QAsnSAP> getAsnClass() {
        return QAsnSAP.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    private void decodePoIpv6(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poIpv6) {
            return;
        }
        this.qasnIPV6ConfigTranslator.decode((FStruct)asn.poIpv6, (Object)mo, context);
    }

    private void encodePoIpv6(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getIpv6Addresss())) {
            return;
        }
        if (null == asn.poIpv6) {
            asn.poIpv6 = new QAsnIPV6Config();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poIpv6);
        }
        this.qasnIPV6ConfigTranslator.encode((Object)mo, (FStruct)asn.poIpv6, context);
    }
}

