/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_common.QAsnAddress;
import com.huawei.network.qasn.m_q_common.QAsnIVIList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_interface_model.QAsnLgcSerialAttr;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortConfigAttr;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortOAMStatus;
import com.huawei.network.qasn.m_q_interface_model.QAsnPtnVEAttr;
import com.huawei.network.qasn.m_q_interface_model.QAsnRtrVEAttr;
import com.huawei.network.qasn.m_q_interface_model.QAsnVlanAggrIfAttr;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnIPV6Config;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.serial.IQAsnLgcSerialAttrTranslatorExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.IPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.PortTransFactory;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnAddressTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnIPV6ConfigTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortOAMStatusTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec.QAsnPortDetailInfoSpecTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ConvertEnumUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class QAsnPortDetailInfoTranslator
extends AbstractAsnTranslator<QAsnPortDetailInfo, Interface> {
    public static final int INVALID_IF_TYPE = 0;
    public static final int INVALID_INV = -1;
    private static Map<Pattern, Integer> IFNAME_PORTTYPE_MAPPING = null;
    private static final Object[][] interfaceMasks = new Object[][]{{"ifName", 8}, {"ifDescr", 16}, {"ifPhyType", 32}, {"ifLinkProtocol", 1024}, {"ifPhyType", 4096}, {"ifMac", 262144}, {"ifOperSpeed", 0x8000000}, {"isL2SwitchPort", 256}, {"ipv4Addresss", 32768}, {"ipv6Addresss", 0x10000000}};
    private static final Object[][] z_qasnPortDetailInfoMasks = new Object[][]{{"userLabel", 2}, {"owner", 4}, {"name", 8}, {"description", 16}, {"type", 32}, {"level", 64}, {"direction", 128}, {"workMode", 256}, {"channelizedType", 512}, {"encapType", 1024}, {"configAttr", 2048}, {"portTypeName", 4096}, {"boardName", 8192}, {"subCardName", 16384}, {"poIpAddress", 32768}, {"poIpv6", 0x10000000}, {"poOamStatus", 65536}, {"poUserTermMode", 131072}, {"poMacAddress", 262144}, {"poSpendBytes", 524288}, {"poSpecialAttr", 0x100000}, {"poSpecialExtAttr", 0x800000}, {"poFrameID", 0x1000000}, {"poSlotID", 0x2000000}, {"poSubSlotID", 0x4000000}, {"poSpeed", 0x8000000}};
    private IAsnTranslator<QAsnAddress, Interface> qasnAddressTranslator = new QAsnAddressTranslator();
    private IAsnTranslator<QAsnIPV6Config, Interface> qasnIPV6ConfigTranslator = new QAsnIPV6ConfigTranslator();
    private QAsnPortDetailInfoSpecTranslator qasnPortDetailInfoSpecTranslator = new QAsnPortDetailInfoSpecTranslator();
    private IAsnTranslator<QAsnPortOAMStatus, Interface> qasnPortOAMStatusTranslator = new QAsnPortOAMStatusTranslator();
    private String VC4 = "VC4";

    public static int getPortLevelFromIfName(String ifName) {
        if (ifName == null) {
            return 0;
        }
        int ret = 0;
        for (Map.Entry<Pattern, Integer> entry : IFNAME_PORTTYPE_MAPPING.entrySet()) {
            if (!entry.getKey().matcher(ifName).find()) continue;
            ret = entry.getValue();
            break;
        }
        return ret;
    }

    public void decode(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        this.qasnPortDetailInfoSpecTranslator.decodePortIndex(asn, mo, context);
        String strIfName = StringUtil.globalString((byte[])asn.name);
        if (null != strIfName && !strIfName.equals("")) {
            mo.setIfName(strIfName);
        } else {
            InterfaceFdnParser InterfaceFdnParser2 = new InterfaceFdnParser();
            Interface inf = (Interface)InterfaceFdnParser2.getIndexMo(asn.portIndex);
            mo.setDevID(inf.getDevID());
            mo.setVrID(inf.getVrID());
            mo.setIfName(inf.getIfName());
            if (null == inf.getIfName() || inf.getIfName().isEmpty()) {
                mo.setFdn(inf.getFdn());
            }
        }
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            context.addProperty(Interface.class.getName(), (Object)mo);
            return;
        }
        this.decodeInterface(asn, mo, context);
        int iOper = asn.operBit;
        if (0 < (iOper & 0x8000)) {
            this.decodeIpv4Address(asn, mo, context);
        }
        if (0 < (iOper & 0x100000) || 0 < (iOper & 0x800000)) {
            this.decodePoSpecialAttr(asn, mo, context);
        }
    }

    public void decodeInterface(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        String strMac;
        ArrayList<String> lstChg = new ArrayList<String>();
        int iOper = asn.operBit;
        if (0 < (iOper & 0x10)) {
            String strDesc = StringUtil.globalString((byte[])asn.description);
            if (null != strDesc && !strDesc.equals("")) {
                mo.setIfDescr(strDesc);
            }
            lstChg.add("ifDescr");
        }
        if (null != (strMac = StringUtil.globalString((byte[])asn.poMacAddress)) && !strMac.equals("")) {
            mo.setIfMac(strMac);
        }
        if (0 < (iOper & 0x40000)) {
            lstChg.add("ifMac");
        }
        IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(Interface.class);
        context.addProperty(Interface.class.getName(), (Object)mo);
        moChangeRecord.addModify((Object)mo, lstChg);
        this.qasnPortDetailInfoSpecTranslator.decodeWorkMode(asn, mo, context);
        this.decodePoIpv6(asn, mo, context);
    }

    public void decodeIpv4Address(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poIpAddress) {
            return;
        }
        this.qasnAddressTranslator.decode((FStruct)asn.poIpAddress, (Object)mo, context);
    }

    public void encode(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.qasnPortDetailInfoSpecTranslator.encodePortIndex(asn, mo, context);
        this.encodeInterface(mo, asn, context);
        this.encodeIpAddress(mo, asn, context);
        this.encodePoSpendBytes(mo, asn, context);
        this.encodePoSpecialAttr(mo, asn, context);
        this.encodeVeGroup(mo, asn, context);
        Object portTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (null != portTranslatorExtPoint) {
            this.encodeBoardName(mo, asn, context);
            this.encodeQAsnPtnVEAttr(mo, asn, context);
            this.encodeVlanID(mo, asn, context);
        }
        this.encodeLgcSerialAttr(mo, asn, context);
    }

    private void encodeQAsnPtnVEAttr(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        List lstIfm = mo.getKeyRefMos(Interface.class);
        if (!CollectionUtils.isEmpty((Collection)lstIfm)) {
            Interface pareIf = (Interface)lstIfm.iterator().next();
            if (StringUtil.isEmpty((String)mo.getIfParentIfName()) || !mo.getIfParentIfName().equals(pareIf.getIfName())) {
                return;
            }
            if (null == asn.configAttr) {
                asn.configAttr = new QAsnPortConfigAttr();
            }
            if (null == asn.configAttr.poPtnVEAttr) {
                asn.configAttr.poPtnVEAttr = new QAsnPtnVEAttr();
            }
            if (null == asn.configAttr.poPtnVEAttr.poRelativePort) {
                asn.configAttr.poPtnVEAttr.poRelativePort = new QAsnUniResID();
            }
            InterfaceFdnParser InterfaceFdnParser2 = new InterfaceFdnParser();
            asn.configAttr.poPtnVEAttr.poRelativePort = InterfaceFdnParser2.getUniResID((VmfMO)pareIf);
        }
    }

    private void encodeVlanID(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        List lstSub = mo.getKeyRefMos(EthSubIf.class);
        if (!CollectionUtils.isEmpty((Collection)lstSub)) {
            String dot1qBitmapToDb;
            EthSubIf subIf = (EthSubIf)lstSub.iterator().next();
            if (null == asn.configAttr) {
                asn.configAttr = new QAsnPortConfigAttr();
            }
            if (null == asn.configAttr.poVlanAggrIfAttr) {
                asn.configAttr.poVlanAggrIfAttr = new QAsnVlanAggrIfAttr();
            }
            if (null == asn.configAttr.poVlanAggrIfAttr.lstVlanID) {
                asn.configAttr.poVlanAggrIfAttr.lstVlanID = new QAsnTinyIntList();
            }
            if (!StringUtils.hasText((String)(dot1qBitmapToDb = subIf.getDot1qBitmapToDb()))) {
                Integer vlanId = subIf.getVlanTypeVid();
                if (null != vlanId && vlanId > 0) {
                    asn.configAttr.poVlanAggrIfAttr.lstVlanID.add((Object)vlanId);
                }
            } else {
                ArrayList dot1qBitmapToDbListList = InterfaceUtil.parseSlot(dot1qBitmapToDb);
                asn.configAttr.poVlanAggrIfAttr.lstVlanID.addAll((Collection)dot1qBitmapToDbListList);
            }
        }
    }

    private void encodeLgcSerialAttr(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        Object lgcSerialAttrTranslatorExtPoint;
        String ifName = mo.getIfNameBackUp();
        if (StringUtil.isEmpty((String)ifName)) {
            InterfaceFdnParser InterfaceFdnParser2 = new InterfaceFdnParser();
            Interface inf = (Interface)InterfaceFdnParser2.getIndexMo(asn.portIndex);
            ifName = inf.getIfName();
        }
        mo.setIfName(ifName);
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ifName);
        if (65543 != ifType) {
            return;
        }
        if (null == asn.configAttr) {
            asn.configAttr = new QAsnPortConfigAttr();
        }
        if (null == asn.configAttr.poLgcSerialAttr) {
            asn.configAttr.poLgcSerialAttr = new QAsnLgcSerialAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.configAttr.poLgcSerialAttr);
        }
        if (null != (lgcSerialAttrTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnLgcSerialAttrTranslatorExtPoint.class))) {
            ((IQAsnLgcSerialAttrTranslatorExtPoint)lgcSerialAttrTranslatorExtPoint).encode(mo, asn.configAttr.poLgcSerialAttr, context);
        }
    }

    public void encodeInterface(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.name = this.getBytes(mo.getIfName());
        asn.description = this.getBytes(mo.getIfDescr());
        this.qasnPortDetailInfoSpecTranslator.encodeWorkMode(asn, mo, context);
        int ifLinkProtocol = this.intValue(mo.getIfLinkProtocol(), -1);
        asn.encapType = Interface.IF_LINK_PROTOCOL_ENUM.INVALID != ifLinkProtocol ? ifLinkProtocol : -1;
        int typeId = mo.getiQIfType();
        asn.type = new Integer(typeId);
        asn.portTypeName = this.getBytes(U2KInterfaceTypeMapping.getPortTypeName((int)typeId));
        asn.poMacAddress = this.getBytes(mo.getIfMac());
        asn.isSupFiber = new Integer(0);
        asn.supportFBList = new QAsnTinyIntList();
        asn.poSpeed = this.getBytes(mo.getIfOperSpeed());
        Object portTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (null != portTranslatorExtPoint) {
            asn.level = this.getPTNPortLevel(mo);
        }
        mask |= this.setChangeMask((VmfMO)mo, context, interfaceMasks);
        this.encodePoOamStatus(mo, asn, context);
        asn.operBit = mask |= this.setChangeMask(InterfaceUtil.isPropertyChanged((VmfMO)mo, Arrays.asList("ifAdminStatus", "ifOperStatus"), context), z_qasnPortDetailInfoMasks, "poOamStatus");
    }

    public Class<QAsnPortDetailInfo> getAsnClass() {
        return QAsnPortDetailInfo.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    private void decodePoIpv6(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poIpv6) {
            return;
        }
        this.qasnIPV6ConfigTranslator.decode((FStruct)asn.poIpv6, (Object)mo, context);
    }

    private void decodePoOamStatus(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poOamStatus) {
            return;
        }
        this.qasnPortOAMStatusTranslator.decode((FStruct)asn.poOamStatus, (Object)mo, context);
    }

    private void decodePoSpecialAttr(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poSpecialAttr) {
            return;
        }
        IPortTranslator trans = PortTransFactory.getInstance().getTranslator(mo);
        if (null != trans) {
            trans.decode(mo, asn, context);
        }
    }

    private void encodeBoardName(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        Board board;
        List lstBoard = inf.getKeyRefMos(Board.class);
        if (!CollectionUtils.isEmpty((Collection)lstBoard) && null != (board = (Board)lstBoard.iterator().next()).getVendorType()) {
            asn.boardName = this.getBytes(board.getVendorType());
        }
    }

    private void encodeIpAddress(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        Collection v6s;
        Collection addresses = inf.getIpv4Addresss();
        if (!CollectionUtils.isEmpty((Collection)addresses)) {
            if (asn.poIpAddress == null) {
                asn.poIpAddress = new QAsnAddress();
            }
            this.qasnAddressTranslator.encode((Object)inf, (FStruct)asn.poIpAddress, context);
            asn.operBit |= this.setChangeMask(InterfaceUtil.isPropertyChanged((VmfMO)inf, Arrays.asList("ipv4Addresss"), context), interfaceMasks, "ipv4Addresss");
        }
        if (!CollectionUtils.isEmpty((Collection)(v6s = inf.getIpv6Addresss()))) {
            if (asn.poIpv6 == null) {
                asn.poIpv6 = new QAsnIPV6Config();
            }
            this.qasnIPV6ConfigTranslator.encode((Object)inf, (FStruct)asn.poIpv6, context);
            asn.operBit |= this.setChangeMask(InterfaceUtil.isPropertyChanged((VmfMO)inf, Arrays.asList("ipv6Addresss"), context), interfaceMasks, "ipv6Addresss");
        }
    }

    private void encodePoOamStatus(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poOamStatus) {
            asn.poOamStatus = new QAsnPortOAMStatus();
        }
        this.qasnPortOAMStatusTranslator.encode((Object)mo, (FStruct)asn.poOamStatus, context);
    }

    private void encodePortLevel(Interface inf, QAsnPortDetailInfo asn) {
        if (null == inf || null == inf.getIfPhyType() || inf.getIfPhyType().isEmpty()) {
            return;
        }
        int portLevel = -1;
        if (this.VC4.equals(inf.getIfPhyType())) {
            portLevel = 11;
        }
        if (null == asn.poSpecialAttr) {
            asn.poSpecialAttr = new QAsnIVIList();
        }
        TranslatorUtil.encodePoSpecialAttr(1220, portLevel, asn.poSpecialAttr);
    }

    private void encodePortMediumType(Interface inf, QAsnPortDetailInfo asn) {
        if (null == inf || inf.getKeyRefMos(Port.class) == null || CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(Port.class))) {
            return;
        }
        Port port = (Port)inf.getKeyRefMos(Port.class).iterator().next();
        if (null == asn.poSpecialAttr) {
            asn.poSpecialAttr = new QAsnIVIList();
        }
        if (null != port) {
            TranslatorUtil.encodePoSpecialAttr(2901, ConvertEnumUtil.getMediumType(port.getMediumType()), asn.poSpecialAttr);
        }
    }

    private void encodePoSpecialAttr(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        IPortTranslator trans = PortTransFactory.getInstance().getTranslator(mo);
        Object portTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (trans != null) {
            trans.encode(mo, asn, context);
            if (null == portTranslatorExtPoint) {
                if (!CollectionUtils.isEmpty((Collection)asn.poSpecialAttr)) {
                    asn.operBit |= this.setChangeMask(1, z_qasnPortDetailInfoMasks, "poSpecialAttr");
                }
                if (!CollectionUtils.isEmpty((Collection)asn.poSpecialExtAttr)) {
                    asn.operBit |= this.setChangeMask(1, z_qasnPortDetailInfoMasks, "poSpecialExtAttr");
                }
            } else {
                this.encodePortMediumType(mo, asn);
                if (!(CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(Port.class)) && CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(EthernetIf.class)) && CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(EthernetPort.class)) && CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(TeLink.class)))) {
                    asn.operBit |= this.setChangeMask(1, z_qasnPortDetailInfoMasks, "poSpecialAttr");
                }
            }
        }
        if (null != portTranslatorExtPoint) {
            this.encodePortLevel(mo, asn);
        }
    }

    private void encodePoSpendBytes(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
    }

    private void encodeVeGroup(Interface mo, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        IMOChangeRecord record;
        Context transactionContext = context.getTransactionContext();
        if (null != transactionContext && (record = transactionContext.getChangeRecord(Interface.class)).containsPropertyChanged((Object)mo, Arrays.asList("veGroupId", "veType"))) {
            QAsnPortConfigAttr configAttr = new QAsnPortConfigAttr();
            QAsnRtrVEAttr poRtrVEAttr = new QAsnRtrVEAttr();
            poRtrVEAttr.veGroupID = this.intValue(mo.getVeGroupId());
            Integer veType = mo.getVeType();
            int intVeType = this.intValue(veType);
            poRtrVEAttr.veWorkMode = -1 != intVeType ? intVeType : intVeType + 1;
            configAttr.poRtrVEAttr = poRtrVEAttr;
            asn.configAttr = configAttr;
            asn.operBit |= this.setChangeMask(1, z_qasnPortDetailInfoMasks, "configAttr");
        }
    }

    private int getPTNPortLevel(Interface ifm) {
        if (null == ifm) {
            return 0;
        }
        String ifName = ifm.getIfNameBackUp();
        if (StringUtil.isEmpty((String)ifName)) {
            InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
            if (StringUtil.isEmpty((String)ifm.getFdn())) {
                return 0;
            }
            Interface inf = interfaceFdnParser.getIndexMo(ifm.getFdn());
            ifName = inf.getIfName();
            if (StringUtil.isEmpty((String)ifName)) {
                return 0;
            }
        }
        int level = 0;
        if (null == IFNAME_PORTTYPE_MAPPING) {
            IFNAME_PORTTYPE_MAPPING = new HashMap<Pattern, Integer>();
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Cpos+|^Pos+"), 6401);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC4+"), 4865);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC12+"), 4097);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(100GE)([0-9/]+)$"), 16392);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(40GE)([0-9/]+)$"), 16391);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(10GE)([0-9/]+)$"), 16389);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(GE|GigabitEthernet)([0-9/]+)$"), 16388);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Ethernet)([0-9/]+)$"), 16387);
        }
        level = QAsnPortDetailInfoTranslator.getPortLevelFromIfName(ifName);
        return level;
    }
}

