/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_interface_model.QAsnPortAndIPAddr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.IInterfaceFdnParserExtPoit;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import net.commustru.fstru.FStruct;

public class QAsnPortAndIPAddrTranslator
extends AbstractAsnTranslator<QAsnPortAndIPAddr, Ipv4Address> {
    private static final Object[][] interfaceMasks = new Object[0][];
    private static final Object[][] Ipv4AddressMasks = new Object[0][];
    private static final Object[][] qasnPortAndIPAddrMasks = new Object[0][];

    public void decode(QAsnPortAndIPAddr asn, Ipv4Address mo, IAsnTranslationContext context) throws VMFException {
        this.decodeObjectID(asn, mo, context);
        this.decodeIpv4Address(asn, mo, context);
    }

    public void decodeIpv4Address(QAsnPortAndIPAddr asn, Ipv4Address mo, IAsnTranslationContext context) throws VMFException {
        Interface inf = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(inf.getDevID());
        mo.setVrID(inf.getVrID());
        mo.setIfName(inf.getIfName());
        mo.setIpAddr(this.strValue(asn.ipAddress));
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
    }

    public void encode(Ipv4Address mo, QAsnPortAndIPAddr asn, IAsnTranslationContext context) throws VMFException {
        this.setDefaultAsnValue((FStruct)asn);
        this.encodeObjectID(asn, mo, context);
        asn.portType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        asn.ipAddress = this.getBytes(mo.getIpAddr());
    }

    public void encodeIpv4Address(Ipv4Address mo, QAsnPortAndIPAddr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.ipAddress = this.getBytes(mo.getIpAddr());
        mask |= this.setChangeMask((VmfMO)mo, context, Ipv4AddressMasks);
    }

    public void encodeObjectID(QAsnPortAndIPAddr asn, Ipv4Address mo, IAsnTranslationContext context) throws VMFException {
        asn.objectID.neID = mo.getDevID();
        Object interfaceFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceFdnParserExtPoit.class);
        if (null != interfaceFdnParserExtPoit) {
            Interface ifm = new Interface();
            ifm.setDevID(mo.getDevID());
            ifm.setVrID(mo.getVrID());
            ifm.setIfName(mo.getIfName());
            String fdn = ((IInterfaceFdnParserExtPoit)interfaceFdnParserExtPoit).getFdn(ifm);
            asn.objectID.strFDN = this.getBytes(fdn);
            asn.objectID.strMOC = this.getBytes(InterfaceUtil.getFdnTypeByFdn(fdn));
        } else {
            asn.objectID.strFDN = this.getBytes(InterfaceUtil.getInterfaceFdn(mo.getDevID(), mo.getVrID(), mo.getIfName()));
            asn.objectID.strMOC = this.getBytes(InterfaceUtil.getInterfaceFdnType(mo.getIfName()));
        }
    }

    public Class<QAsnPortAndIPAddr> getAsnClass() {
        return QAsnPortAndIPAddr.class;
    }

    public Class<Ipv4Address> getMoClass() {
        return Ipv4Address.class;
    }

    private void decodeObjectID(QAsnPortAndIPAddr asn, Ipv4Address mo, IAsnTranslationContext context) {
    }

    private void decodePortType(QAsnPortAndIPAddr asn, Ipv4Address mo, IAsnTranslationContext context) {
    }
}

