/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_common.QAsnIPV6Address;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnIPV6Config;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv6Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnIPV6ConfigTranslator
extends AbstractAsnTranslator<QAsnIPV6Config, Interface> {
    private static final Object[][] Ipv6AddressMasks = new Object[0][];
    private static final Object[][] z_interfaceMasks = new Object[][]{{"ipv6Enable", 1}, {"ifV6State", 4}, {"ipv6Addresss", 2}};

    public void decode(QAsnIPV6Config asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        this.decodeInterface(asn, mo, context);
    }

    public void decodeInterface(QAsnIPV6Config asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setIpv6Enable(AsnUtil.parseBoolean((Integer)asn.ipv6Enable));
        mo.setIfV6State(Integer.valueOf(this.intValue(asn.ipv6RunningStatus)));
        ArrayList<Ipv6Address> ipv6Addresss = new ArrayList<Ipv6Address>();
        if (!asn.ipv6AddrestList.isEmpty()) {
            for (QAsnIPV6Address qIp : asn.ipv6AddrestList) {
                if (1 == qIp.scopeType) {
                    mo.setAutoLinkLocal(Boolean.valueOf(true));
                    continue;
                }
                Ipv6Address ipv6 = new Ipv6Address();
                this.decodeIpv6Address(qIp, ipv6, context);
                ipv6Addresss.add(ipv6);
            }
        }
        mo.setIpv6Addresss(ipv6Addresss);
        if (null != asn.poOperMask && (2 & asn.poOperMask) > 0) {
            ItemChangedUtil.setItemChangedInList(ipv6Addresss, Ipv6Address.class, Interface.class, mo, context);
        }
        this.setChanged((VmfMO)mo, z_interfaceMasks, asn.poOperMask, context);
    }

    public void decodeIpv6Address(QAsnIPV6Address qIp, Ipv6Address mo, IAsnTranslationContext context) throws VMFException {
        Interface inf = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(inf.getDevID());
        mo.setVrID(inf.getVrID());
        mo.setIfName(inf.getIfName());
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, qIp.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        context.addProperty(Ipv6Address.class.getName(), (Object)mo);
        mo.setAddrPrefixLen(Integer.valueOf(qIp.prefixLength));
        mo.setAddrType6(this.getV6AddrType(qIp.scopeType, qIp.anycastFlag));
        mo.setIpAddr(this.strValue(qIp.address));
        this.setChanged((VmfMO)mo, Ipv6AddressMasks, qIp.poOperMask, context);
    }

    public void encode(Interface mo, QAsnIPV6Config asn, IAsnTranslationContext context) throws VMFException {
        this.encodeIpv6Addresslist(mo, asn, context);
    }

    public void encodeIpv6Address(Ipv6Address mo, QAsnIPV6Address ipv6asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        if (Ipv6Address.ADDR_TYPE6_ENUM.ANYCAST.intValue() == this.intValue(mo.getAddrType6())) {
            ipv6asn.anycastFlag = 1;
        } else {
            ipv6asn.scopeType = this.getV6AddrType(mo.getAddrType6());
        }
        ipv6asn.address = mo.getIpAddr().getBytes();
        ipv6asn.prefixLength = this.intValue(mo.getAddrPrefixLen());
        ipv6asn.poOperMask = mask;
    }

    public void encodeIpv6Addresslist(Interface mo, QAsnIPV6Config asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.ipv6Enable = mo.getIpv6Enable() == null ? -1 : this.intValue(mo.getIpv6Enable());
        asn.ipv6RunningStatus = this.intValue(mo.getIfV6State());
        if (!CollectionUtils.isEmpty((Collection)mo.getIpv6Addresss())) {
            for (Ipv6Address ipv6 : mo.getIpv6Addresss()) {
                QAsnIPV6Address ipv6asn = new QAsnIPV6Address();
                AsnUtil.setDefaultAsnValue((FStruct)ipv6asn);
                this.encodeIpv6Address(ipv6, ipv6asn, context);
                asn.ipv6AddrestList.add((Object)ipv6asn);
            }
        } else if (mo.getAutoLinkLocal().booleanValue()) {
            QAsnIPV6Address ipv6asn = new QAsnIPV6Address();
            AsnUtil.setDefaultAsnValue((FStruct)ipv6asn);
            ipv6asn.scopeType = 1;
            asn.ipv6AddrestList.add((Object)ipv6asn);
        }
        asn.poOperMask = mask |= this.setChangeMask((VmfMO)mo, context, z_interfaceMasks);
    }

    public Class<QAsnIPV6Config> getAsnClass() {
        return QAsnIPV6Config.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    private Integer getV6AddrType(int addressType, int anycastFlag) {
        if (0 != anycastFlag && -1 != anycastFlag) {
            return (int)Ipv6Address.ADDR_TYPE6_ENUM.ANYCAST;
        }
        if (3 == addressType) {
            return (int)Ipv6Address.ADDR_TYPE6_ENUM.GLOBAL;
        }
        if (4 == addressType) {
            return (int)Ipv6Address.ADDR_TYPE6_ENUM.EUI64;
        }
        if (2 == addressType) {
            return (int)Ipv6Address.ADDR_TYPE6_ENUM.LINK_LOCAL;
        }
        QAsnIPV6ConfigTranslator.getLogger().error("getV6AddrType failed! addressType:" + String.valueOf(addressType) + "; anycastFlag:" + String.valueOf(anycastFlag));
        return -1;
    }

    private int getV6AddrType(Integer addrType6) {
        if (Ipv6Address.ADDR_TYPE6_ENUM.GLOBAL == addrType6) {
            return 3;
        }
        if (Ipv6Address.ADDR_TYPE6_ENUM.EUI64 == addrType6) {
            return 4;
        }
        if (Ipv6Address.ADDR_TYPE6_ENUM.LINK_LOCAL == addrType6) {
            return 2;
        }
        if (Ipv6Address.ADDR_TYPE6_ENUM.ND_PREFIX == addrType6) {
            return 6;
        }
        QAsnIPV6ConfigTranslator.getLogger().error("getV6AddrType failed! addrType6:" + String.valueOf(addrType6));
        return -1;
    }
}

