/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;

public class QAsnIPAddressTranslator
extends AbstractAsnTranslator<QAsnIPAddress, Ipv4Address> {
    private static final Object[][] qasnIPAddressMasks = new Object[][]{{"ipAddr", 1}, {"subnetMask", 2}, {"addrType", 4}};
    private static final Object[][] am4CfgAddrMasks = new Object[0][];

    public void decode(QAsnIPAddress asn, Ipv4Address mo, IAsnTranslationContext context) throws VMFException {
        this.decodeAm4CfgAddr(asn, mo, context);
    }

    public void decodeAm4CfgAddr(QAsnIPAddress asn, Ipv4Address mo, IAsnTranslationContext context) throws VMFException {
        Interface inf = (Interface)context.getProperty(Interface.class.getName());
        mo.setIpAddr(this.strValue(asn.address));
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setSubnetMask(this.strValue(asn.mask));
        Integer iAddrType = Ipv4Address.ADDR_TYPE_ENUM.MAIN;
        iAddrType = null != inf && null != inf.getUnNumIfName() ? Ipv4Address.ADDR_TYPE_ENUM.UNNUMBER : (Ipv4Address.ADDR_TYPE_ENUM.MAIN == Integer.valueOf(asn.isMaster) ? Ipv4Address.ADDR_TYPE_ENUM.MAIN : Ipv4Address.ADDR_TYPE_ENUM.SUB);
        mo.setAddrType(iAddrType);
    }

    public void encode(Ipv4Address mo, QAsnIPAddress asn, IAsnTranslationContext context) throws VMFException {
        this.encodeAm4CfgAddr(mo, asn, context);
    }

    public void encodeAm4CfgAddr(Ipv4Address mo, QAsnIPAddress asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.address = this.getBytes(mo.getIpAddr());
        asn.mask = this.getBytes(mo.getSubnetMask());
        asn.isMaster = 5 == mo.getAddrType() ? 1 : this.intValue(mo.getAddrType() == 1 ? 1 : 0);
        mask |= this.setChangeMask((VmfMO)mo, context, am4CfgAddrMasks);
    }

    public Class<QAsnIPAddress> getAsnClass() {
        return QAsnIPAddress.class;
    }

    public Class<Ipv4Address> getMoClass() {
        return Ipv4Address.class;
    }
}

