/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm;

import com.huawei.network.qasn.m_q_common.QAsnAddress;
import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import com.huawei.network.qasn.m_q_common.QAsnIPAddressList;
import com.huawei.network.qasn.m_q_common.QAsnIPUnnumbered;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.extendpoint.l3vpn.task.ITaskSpecialAction;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnIPAddressTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnIPUnnumberedTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Collection;
import java.util.HashSet;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnAddressTranslator
extends AbstractAsnTranslator<QAsnAddress, Interface> {
    private static final Collection<String> IpItems = new HashSet<String>();
    private static final Object[][] Ipv4AddressMasks = new Object[][]{{"unNumIfName", 2}, {"ipv4Addresss", 1}};
    private static final Object[][] qasnAddressMasks = new Object[0][];
    private IAsnTranslator<QAsnIPAddress, Ipv4Address> qasnIPAddressTranslator = new QAsnIPAddressTranslator();
    private IAsnTranslator<QAsnIPUnnumbered, Ipv4Address> qasnIPUnnumberedTranslator = new QAsnIPUnnumberedTranslator();
    private int OPERMASK_CREAT = 1;
    private int OPERMASK_DELETE = 2;

    public void decode(QAsnAddress asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == mo || null == mo.getIfName()) {
            return;
        }
        this.decodeAddrList(asn, mo, context);
        this.decodePoUnnumbered(asn, mo, context);
        this.setChanged((VmfMO)mo, Ipv4AddressMasks, asn.poOperMask, context);
    }

    public void encode(Interface mo, QAsnAddress asn, IAsnTranslationContext context) throws VMFException {
        context.addProperty(Interface.class.getName(), (Object)mo);
        this.encodeIpv4Address(mo, asn, context);
    }

    public void encodeIpv4Address(Interface mo, QAsnAddress asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        Collection addrs = mo.getIpv4Addresss();
        if (null != addrs) {
            this.encodeAddrList(addrs, asn, context);
            this.encodePoUnnumbered(addrs, asn, context);
        }
        asn.poOperMask = mask |= this.setChangeMask((VmfMO)mo, context, Ipv4AddressMasks);
    }

    public Class<QAsnAddress> getAsnClass() {
        return QAsnAddress.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    private void decodeAddrList(QAsnAddress asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        Object sapPoOperMask;
        if (null == asn.addrList) {
            return;
        }
        HashSet<Ipv4Address> ipv4s = mo.getIpv4Addresss();
        if (null == ipv4s) {
            ipv4s = new HashSet<Ipv4Address>();
        }
        for (QAsnIPAddress addr : asn.addrList) {
            Ipv4Address ipv4 = new Ipv4Address();
            ipv4.setDevID(mo.getDevID());
            ipv4.setVrID(mo.getVrID());
            ipv4.setIfName(mo.getIfName());
            this.qasnIPAddressTranslator.decode((FStruct)addr, (Object)ipv4, context);
            ipv4s.add(ipv4);
        }
        if (CollectionUtils.isEmpty(ipv4s)) {
            return;
        }
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        Object itaskSpecialAction = ExtendPointServiceMgr.getInstance().getExtendPoitService(ITaskSpecialAction.class);
        if (null != interfaceUtilExtPoint) {
            IMOChangeRecord dbRecode;
            sapPoOperMask = context.getProperty("QAsnSAP_poOperMask");
            int intSapPoOperMask = -1;
            if (null != sapPoOperMask) {
                intSapPoOperMask = Integer.valueOf(sapPoOperMask.toString());
            }
            Object setPortDetailOperBit = context.getProperty("QAsnSetPortDetailInfoTask");
            if (null != mo.getIfName() && (null != setPortDetailOperBit || null != asn.poOperMask && ((1 & asn.poOperMask) > 0 || intSapPoOperMask == this.OPERMASK_CREAT || intSapPoOperMask == this.OPERMASK_DELETE))) {
                ItemChangedUtil.setItemChangedInList(ipv4s, Ipv4Address.class, Interface.class, mo, context);
            }
            if (null != (dbRecode = context.getTransactionContext().getChangeRecord(Ipv4Address.class)) && !CollectionUtils.isEmpty((Collection)dbRecode.getAllChanges())) {
                IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(mo.getClass());
                recorder.addModify((Object)mo, new PropertyChangeItem("ipv4Addresss"));
            }
        } else if (null != itaskSpecialAction) {
            if (null != asn.poOperMask && (1 & asn.poOperMask) > 0) {
                ItemChangedUtil.setItemChangedInList(ipv4s, Ipv4Address.class, Interface.class, mo, context);
            } else {
                sapPoOperMask = context.getProperty("QAsnSAP_poOperMask");
                int intSapPoOperMask = -1;
                if (null != sapPoOperMask) {
                    intSapPoOperMask = Integer.valueOf(sapPoOperMask.toString());
                }
                if (intSapPoOperMask == 0 && null != asn.poOperMask && (1 & asn.poOperMask) == 0) {
                    ItemChangedUtil.setItemChangedInList(ipv4s, Ipv4Address.class, Interface.class, mo, context);
                    IMOChangeRecord dbRecode = context.getTransactionContext().getChangeRecord(Ipv4Address.class);
                    if (null != dbRecode && !CollectionUtils.isEmpty((Collection)dbRecode.getAllChanges())) {
                        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(mo.getClass());
                        recorder.addModify((Object)mo, new PropertyChangeItem("ipv4Addresss"));
                    }
                }
            }
        } else if (null != asn.poOperMask && (1 & asn.poOperMask) > 0) {
            ItemChangedUtil.setItemChangedInList(ipv4s, Ipv4Address.class, Interface.class, mo, context);
        }
        mo.addIpv4Addresss(ipv4s);
    }

    private void decodePoUnnumbered(QAsnAddress asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poUnnumbered || null == asn.poUnnumbered.unnumberedIf || null == asn.poUnnumbered.unnumberedIf.strFDN) {
            return;
        }
        Ipv4Address ipv4 = new Ipv4Address();
        ipv4.setDevID(mo.getDevID());
        ipv4.setVrID(mo.getVrID());
        ipv4.setIfName(mo.getIfName());
        this.qasnIPUnnumberedTranslator.decode((FStruct)asn.poUnnumbered, (Object)ipv4, context);
        HashSet<Ipv4Address> ipv4s = new HashSet<Ipv4Address>();
        ipv4s.add(ipv4);
        if (EOperationType.DEPLOY != context.getOperType() && EOperationType.MODIFY != context.getOperType() && EOperationType.CREATE != context.getOperType()) {
            mo.setIpv4Addresss(ipv4s);
        }
    }

    private void encodeAddrList(Collection<Ipv4Address> addrs, QAsnAddress asn, IAsnTranslationContext context) throws VMFException {
        if (addrs.isEmpty()) {
            return;
        }
        Integer ipType = addrs.iterator().next().getAddrType();
        if (null != ipType && Ipv4Address.ADDR_TYPE_ENUM.UNNUMBER.equals(ipType)) {
            return;
        }
        if (null == asn.addrList) {
            asn.addrList = new QAsnIPAddressList();
        }
        HashSet<Ipv4Address> checkList = new HashSet<Ipv4Address>();
        for (Ipv4Address ipv4 : addrs) {
            QAsnIPAddress qasnip = new QAsnIPAddress();
            if (checkList.contains(ipv4)) continue;
            this.qasnIPAddressTranslator.encode((Object)ipv4, (FStruct)qasnip, context);
            asn.addrList.add((Object)qasnip);
            checkList.add(ipv4);
        }
    }

    private void encodePoUnnumbered(Collection<Ipv4Address> addrs, QAsnAddress asn, IAsnTranslationContext context) throws VMFException {
        if (addrs.isEmpty()) {
            return;
        }
        if (!Ipv4Address.ADDR_TYPE_ENUM.UNNUMBER.equals(addrs.iterator().next().getAddrType())) {
            return;
        }
        if (null == asn.poUnnumbered) {
            asn.poUnnumbered = new QAsnIPUnnumbered();
        }
        AsnUtil.setDefaultAsnValue((FStruct)asn.poUnnumbered);
        this.qasnIPUnnumberedTranslator.encode((Object)addrs.iterator().next(), (FStruct)asn.poUnnumbered, context);
    }

    static {
        IpItems.add("subnetMask");
        IpItems.add("addrType");
    }
}

