/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAPInfo;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAPInfoList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.vcluster.model.RemoteApIf;
import com.huawei.vmf.adapter.fservice.vcluster.model.VBridgeMemberIf;
import com.huawei.vmf.adapter.fservice.vcluster.model.VbridgeIf;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VBridgeSAPTranslator
implements ISAPTranslator {
    private Logger logger = LoggerFactory.getLogger(VBridgeSAPTranslator.class);
    private IAsnTranslator<QAsnSAP, Interface> interfaceTranslator = new QAsnSapTranslator();

    @Override
    public Interface decode(IAsnTranslationContext context, QAsnSAP sap) throws VMFException {
        return (Interface)this.interfaceTranslator.decode((FStruct)sap, context);
    }

    @Override
    public QAsnSAP encode(IAsnTranslationContext context, Interface mo) throws VMFException {
        QAsnSAP sap = new QAsnSAP();
        AsnUtil.setDefaultAsnValue((FStruct)sap);
        this.interfaceTranslator.encode((Object)mo, (FStruct)sap, context);
        this.encodeVbridgeIf(mo, sap);
        return sap;
    }

    private void encodeVbridgeIf(Interface mo, QAsnSAP sapAsn) {
        Collection<VbridgeIf> moBridgeInfoList = this.queryVBridgeInfos(mo);
        if (null == moBridgeInfoList) {
            this.logger.error("VBridgeSAPTranslator encode failed, queryVBridgeInfos is null.", (Object)mo);
            return;
        }
        for (VbridgeIf oVbridgeIf : moBridgeInfoList) {
            Collection<RemoteApIf> remoteApInfoList = this.queryRemoteApInfos(oVbridgeIf);
            if (null == remoteApInfoList) {
                this.logger.error("VBridgeSAPTranslator encode failed, queryRemoteApInfos is null.", (Object)oVbridgeIf);
                continue;
            }
            if (remoteApInfoList.size() == 0) {
                this.logger.error("VBridgeSAPTranslator encode failed, queryRemoteApInfos none.", (Object)oVbridgeIf);
                continue;
            }
            this.encodeRemoteApIf(remoteApInfoList.iterator().next(), sapAsn);
        }
    }

    private void encodeRemoteApIf(RemoteApIf oRemoteApIf, QAsnSAP sapAsn) {
        if (null == sapAsn.poLinkProtocol) {
            sapAsn.poLinkProtocol = new QAsnLinkProtocol();
        }
        if (null == sapAsn.poLinkProtocol.poAPList) {
            sapAsn.poLinkProtocol.poAPList = new QAsnAPInfoList();
        }
        sapAsn.poLinkProtocol.type = 6;
        QAsnAPInfo asnApInfo = new QAsnAPInfo();
        asnApInfo.poMasterInfName = oRemoteApIf.getIfName().getBytes();
        asnApInfo.remoteAPInfName = oRemoteApIf.getApIfName().getBytes();
        asnApInfo.remoteAPName = oRemoteApIf.getApIpAddr().getBytes();
        sapAsn.poLinkProtocol.poAPList.add((Object)asnApInfo);
    }

    private Collection<VbridgeIf> queryVBridgeInfos(Interface mo) {
        Collection oVbridgeIfs = null;
        ArrayList<VbridgeIf> bridgeIndexes = new ArrayList<VbridgeIf>();
        VbridgeIf oVbridgeIf = new VbridgeIf();
        oVbridgeIf.setDevID(mo.getDevID());
        oVbridgeIf.setVbridgeIfName(mo.getIfName());
        bridgeIndexes.add(oVbridgeIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vbridgeIfName"};
        try {
            oVbridgeIfs = dao.queryByFields(VbridgeIf.class, fieldNames, bridgeIndexes, false);
            if (oVbridgeIfs.size() > 0) {
                oVbridgeIf = (VbridgeIf)oVbridgeIfs.iterator().next();
                Collection<VBridgeMemberIf> oVBridgeMemberIfs = this.queryVBridgeMemberInfos(oVbridgeIf);
                oVbridgeIf.addVBridgeMemberIfs(oVBridgeMemberIfs);
            }
        }
        catch (VMFException e) {
            this.logger.error("queryVBridgeInfos failed, queryByFields error.", (Throwable)e);
        }
        return oVbridgeIfs;
    }

    private Collection<VBridgeMemberIf> queryVBridgeMemberInfos(VbridgeIf mo) {
        ArrayList<VBridgeMemberIf> bridgeMemberIndexes = new ArrayList<VBridgeMemberIf>();
        VBridgeMemberIf oBridgeMemberIf = new VBridgeMemberIf();
        oBridgeMemberIf.setDevID(mo.getDevID());
        oBridgeMemberIf.setVbridgeIfName(mo.getVbridgeIfName());
        bridgeMemberIndexes.add(oBridgeMemberIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vbridgeIfName"};
        try {
            return dao.queryByFields(VBridgeMemberIf.class, fieldNames, bridgeMemberIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryVBridgeInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    private Collection<RemoteApIf> queryRemoteApInfos(VbridgeIf oVbridgeIf) {
        ArrayList<RemoteApIf> remoteApIndexes = new ArrayList<RemoteApIf>();
        for (VBridgeMemberIf oVBridgeMemberIf : oVbridgeIf.getVBridgeMemberIfs()) {
            RemoteApIf oRemoteApIf = new RemoteApIf();
            oRemoteApIf.setDevID(oVbridgeIf.getDevID());
            oRemoteApIf.setIfName(oVBridgeMemberIf.getMemberIfName());
            remoteApIndexes.add(oRemoteApIf);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "apIfName"};
        try {
            return dao.queryByFields(RemoteApIf.class, fieldNames, remoteApIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryRemoteApInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> vec = new Vector<Integer>();
        vec.add(65580);
        return vec;
    }

    @Override
    public void decode(IAsnTranslationContext context, QAsnSAP sap, Interface mo) throws VMFException {
        this.interfaceTranslator.decode((FStruct)sap, (Object)mo, context);
    }

    @Override
    public void encode(IAsnTranslationContext context, Interface mo, QAsnSAP asn) throws VMFException {
        this.interfaceTranslator.encode((Object)mo, (FStruct)asn, context);
        this.encodeVbridgeIf(mo, asn);
    }
}

