/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_common.QAsnIDAndValueInt;
import com.huawei.network.qasn.m_q_common.QAsnIVIList;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.IPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ConvertEnumUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TrunkPortTranslator
implements IPortTranslator {
    private static final Logger logger = LoggerFactory.getLogger(TrunkPortTranslator.class);

    @Override
    public void decode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        Object extPointService;
        TrunkIf trunk;
        if (null == asn.poSpecialAttr) {
            return;
        }
        List lstTrunk = inf.getKeyRefMos(TrunkIf.class);
        if (lstTrunk.isEmpty()) {
            trunk = new TrunkIf();
            trunk.setDevID(inf.getDevID());
            trunk.setVrID(inf.getVrID());
            trunk.setIfName(inf.getIfName());
            trunk.setTrunkType(inf.getiQIfType());
        } else {
            trunk = (TrunkIf)lstTrunk.iterator().next();
        }
        ArrayList<String> lstChg = new ArrayList<String>();
        for (Object obj : asn.poSpecialAttr) {
            QAsnIDAndValueInt ivi = (QAsnIDAndValueInt)obj;
            switch (ivi.id) {
                case 2113: 
                case 2203: {
                    inf.setIfMtu(Integer.valueOf(ivi.value));
                    IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(Interface.class);
                    moChangeRecord.addModify((Object)inf, new PropertyChangeItem("ifMtu", null, null));
                    break;
                }
                case 2103: 
                case 2201: {
                    trunk.setHashType(ConvertEnumUtil.getHashType(ivi.value));
                    lstChg.add("hashType");
                    break;
                }
                case 2111: 
                case 2202: {
                    trunk.setMaxActiveNum(Integer.valueOf(ivi.value));
                    lstChg.add("maxActiveNum");
                    break;
                }
                case 2101: {
                    trunk.setWorkMode(ConvertEnumUtil.getTrunkWorkMode(ivi.value));
                    lstChg.add("workMode");
                    break;
                }
                case 2104: {
                    trunk.setMinUpNum(Integer.valueOf(ivi.value));
                    lstChg.add("minUpNum");
                    break;
                }
                case 2105: {
                    trunk.setMaxUpNum(Integer.valueOf(ivi.value));
                    lstChg.add("maxUpNum");
                    break;
                }
                case 2108: {
                    trunk.setSupportPrmpt(ConvertEnumUtil.getFSupportPrmpt(ivi.value));
                    lstChg.add("supportPrmpt");
                    break;
                }
                case 2109: {
                    trunk.setPromptDelay(Long.valueOf(ivi.value));
                    lstChg.add("promptDelay");
                    break;
                }
                case 2110: {
                    trunk.setRcvTimeoutType(ConvertEnumUtil.getRcvTimeoutType(ivi.value));
                    lstChg.add("rcvTimeoutType");
                    break;
                }
            }
        }
        if (!lstChg.isEmpty()) {
            inf.addKeyRefMo((VmfMO)trunk);
            context.addProperty(TrunkIf.class.getName(), (Object)trunk);
            IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(TrunkIf.class);
            moChangeRecord.addModify((Object)trunk, lstChg);
            if (EOperationType.CREATE == context.getOperType()) {
                IMOChangeRecord moDbChange = context.getTransactionContext().addDBChangeRecord(TrunkIf.class);
                moDbChange.addCreate((Object)trunk);
                String ifname = inf.getIfName();
                if (65539 == inf.getiQIfType()) {
                    inf.setIfPhyType(ifname.substring(0, 9));
                    inf.setIfNumber(ifname.substring(9));
                } else {
                    inf.setIfPhyType(ifname.substring(0, 8));
                    inf.setIfNumber(ifname.substring(8));
                }
            }
        }
        if (null != (extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.decodeForTrunk(inf, asn, context);
        }
    }

    @Override
    public void encode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        if (inf.getKeyRefMos(TrunkIf.class) == null || CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(TrunkIf.class))) {
            return;
        }
        TrunkIf trunk = (TrunkIf)inf.getKeyRefMos(TrunkIf.class).iterator().next();
        asn.poSpecialAttr = new QAsnIVIList();
        Integer ifTypeId = inf.getiQIfType();
        switch (ifTypeId) {
            case 65539: {
                if (null != trunk) {
                    TranslatorUtil.encodePoSpecialAttr(2101, ConvertEnumUtil.getAutoLAGType(trunk.getWorkMode()), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2103, ConvertEnumUtil.getLoadBalanceMode(trunk.getHashType()), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2104, trunk.getMinUpNum(), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2105, trunk.getMaxUpNum(), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2108, ConvertEnumUtil.getQSupportPrmpt(trunk.getSupportPrmpt()), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2109, trunk.getPromptDelay(), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2110, ConvertEnumUtil.getLacpTimeout(trunk.getRcvTimeoutType()), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2111, trunk.getMaxActiveNum(), asn.poSpecialAttr);
                }
                TranslatorUtil.encodePoSpecialAttr(2113, inf.getIfMtu(), asn.poSpecialAttr);
                break;
            }
            case 65540: {
                if (null != trunk) {
                    TranslatorUtil.encodePoSpecialAttr(2201, ConvertEnumUtil.getLoadBalanceMode(trunk.getHashType()), asn.poSpecialAttr);
                    TranslatorUtil.encodePoSpecialAttr(2202, trunk.getMaxUpNum(), asn.poSpecialAttr);
                }
                TranslatorUtil.encodePoSpecialAttr(2203, inf.getIfMtu(), asn.poSpecialAttr);
                break;
            }
            default: {
                logger.info("interface type is invalidate, ifTypeId=" + ifTypeId);
            }
        }
        Object extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (null != extPointService) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.encodeForTrunk(inf, asn, context);
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        types.add(65539);
        types.add(65540);
        return types;
    }
}

