/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SAPTransFactory {
    private static final Logger logger = LoggerFactory.getLogger(SAPTransFactory.class);
    private List<ISAPTranslator> allTranslators = new ArrayList<ISAPTranslator>();
    private InterfaceFdnParser interfaceFdnFarser = new InterfaceFdnParser();

    private SAPTransFactory() {
        if (CollectionUtils.isEmpty(this.allTranslators)) {
            this.allTranslators.addAll(TranslatorUtil.getAllTranslator());
        }
    }

    public static final SAPTransFactory getInstance() {
        return SapTranslatorFactorySingleton.INSTANCE;
    }

    public ISAPTranslator getTranslator(QAsnSAP sap) {
        if (null != sap.ctpKey.poSerialNum) {
            if (null == sap.mainPortFdn) {
                return null;
            }
            Interface tmpMo = this.interfaceFdnFarser.getIndexMo(StringUtil.globalString((byte[])sap.mainPortFdn));
            String parentIfName = tmpMo.getIfName();
            String ifName = null == sap.subIFNo ? parentIfName : parentIfName + "." + String.valueOf(sap.subIFNo);
            Integer key = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ifName);
            return this.getTranslator(key);
        }
        Interface mo = this.interfaceFdnFarser.getIndexMo(StringUtil.globalString((byte[])sap.ctpKey.strFDN));
        Integer key = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        return this.getTranslator(key);
    }

    public ISAPTranslator getTranslator(VmfMO mo) {
        Integer key = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)((Interface)mo).getIfName());
        return this.getTranslator(key);
    }

    private synchronized ISAPTranslator getTranslator(Integer type) {
        for (ISAPTranslator sapTranslator : this.allTranslators) {
            Vector<Integer> types = sapTranslator.getType();
            if (CollectionUtils.isEmpty(types) || !types.contains(type)) continue;
            return sapTranslator;
        }
        logger.error("getTranslator is null. type : " + type);
        return null;
    }

    private static class SapTranslatorFactorySingleton {
        public static final SAPTransFactory INSTANCE = new SAPTransFactory();

        private SapTranslatorFactorySingleton() {
        }
    }
}

