/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAPInfo;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAPInfoList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.vcluster.model.RemoteApIf;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.VBridgeSAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteApSAPTranslator
implements ISAPTranslator {
    private Logger logger = LoggerFactory.getLogger(VBridgeSAPTranslator.class);
    private IAsnTranslator<QAsnSAP, Interface> interfaceTranslator = new QAsnSapTranslator();

    @Override
    public Interface decode(IAsnTranslationContext context, QAsnSAP sap) throws VMFException {
        return (Interface)this.interfaceTranslator.decode((FStruct)sap, context);
    }

    @Override
    public QAsnSAP encode(IAsnTranslationContext context, Interface mo) throws VMFException {
        QAsnSAP sap = new QAsnSAP();
        AsnUtil.setDefaultAsnValue((FStruct)sap);
        this.interfaceTranslator.encode((Object)mo, (FStruct)sap, context);
        this.encodeRemoteApIf(mo, sap);
        return sap;
    }

    private void encodeRemoteApIf(Interface mo, QAsnSAP sapAsn) {
        if (null == sapAsn.poLinkProtocol) {
            sapAsn.poLinkProtocol = new QAsnLinkProtocol();
        }
        if (null == sapAsn.poLinkProtocol.poAPList) {
            sapAsn.poLinkProtocol.poAPList = new QAsnAPInfoList();
        }
        sapAsn.poLinkProtocol.type = 6;
        Collection<RemoteApIf> remoteApInfoList = this.queryRemoteApInfos(mo);
        if (null == remoteApInfoList) {
            this.logger.error("RemoteApSAPTranslator encode failed, queryRemoteApInfos null.", (Object)mo);
            return;
        }
        if (remoteApInfoList.size() == 0) {
            this.logger.error("RemoteApSAPTranslator encode failed, queryRemoteApInfos none.", (Object)mo);
            return;
        }
        RemoteApIf oRemoteApIf = remoteApInfoList.iterator().next();
        QAsnAPInfo asnApInfo = new QAsnAPInfo();
        asnApInfo.remoteAPInfName = oRemoteApIf.getApIfName().getBytes();
        asnApInfo.remoteAPName = oRemoteApIf.getApIpAddr().getBytes();
        sapAsn.poLinkProtocol.poAPList.add((Object)asnApInfo);
    }

    private Collection<RemoteApIf> queryRemoteApInfos(Interface mo) {
        ArrayList<RemoteApIf> remoteApIndexes = new ArrayList<RemoteApIf>();
        RemoteApIf oRemoteApIf = new RemoteApIf();
        oRemoteApIf.setDevID(mo.getDevID());
        oRemoteApIf.setIfName(mo.getIfName());
        remoteApIndexes.add(oRemoteApIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "ifName"};
        try {
            return dao.queryByFields(RemoteApIf.class, fieldNames, remoteApIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryRemoteApInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> vec = new Vector<Integer>();
        vec.add(65581);
        return vec;
    }

    @Override
    public void decode(IAsnTranslationContext context, QAsnSAP sap, Interface mo) throws VMFException {
        this.interfaceTranslator.decode((FStruct)sap, (Object)mo, context);
    }

    @Override
    public void encode(IAsnTranslationContext context, Interface mo, QAsnSAP asn) throws VMFException {
        this.interfaceTranslator.encode((Object)mo, (FStruct)asn, context);
        this.encodeRemoteApIf(mo, asn);
    }
}

