/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_common.QAsnIDAndValueInt;
import com.huawei.network.qasn.m_q_common.QAsnIVIList;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.PosPort;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.IPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ConvertEnumUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.springframework.util.CollectionUtils;

public class PosPortTranslator
implements IPortTranslator {
    @Override
    public void decode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        Object extPointService;
        PosPort posPort;
        if (null == asn.poSpecialAttr) {
            return;
        }
        List lstPosPort = inf.getKeyRefMos(PosPort.class);
        if (lstPosPort.isEmpty()) {
            posPort = new PosPort();
            posPort.setDevID(inf.getDevID());
            posPort.setVrID(inf.getVrID());
            posPort.setPosition(inf.getIfPosition());
        } else {
            posPort = (PosPort)lstPosPort.iterator().next();
        }
        ArrayList<String> lstChg = new ArrayList<String>();
        for (Object obj : asn.poSpecialAttr) {
            QAsnIDAndValueInt ivi = (QAsnIDAndValueInt)obj;
            switch (ivi.id) {
                case 1201: {
                    posPort.setScramble(ConvertEnumUtil.getPosFScramble(ivi.value));
                    lstChg.add("scramble");
                    break;
                }
                case 1202: {
                    posPort.setFrameFormat(ConvertEnumUtil.getPosFFrameFormat(ivi.value));
                    lstChg.add("frameFormat");
                    break;
                }
                case 1203: {
                    posPort.setClock(ConvertEnumUtil.getPosFClock(ivi.value));
                    lstChg.add("clock");
                    break;
                }
                case 1204: {
                    posPort.setCrc(ConvertEnumUtil.getPosFCrc(ivi.value));
                    lstChg.add("crc");
                    break;
                }
            }
        }
        if (!lstChg.isEmpty()) {
            inf.addKeyRefMo((VmfMO)posPort);
            context.addProperty(PosPort.class.getName(), (Object)posPort);
            IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(PosPort.class);
            moChangeRecord.addModify((Object)posPort, lstChg);
        }
        if (null != (extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.decodeForPos(inf, asn, context);
        }
    }

    @Override
    public void encode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        Object extPointService;
        if (CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(Port.class))) {
            return;
        }
        asn.poSpecialAttr = new QAsnIVIList();
        TranslatorUtil.encodePoSpecialAttr(1210, inf.getIfMtu(), asn.poSpecialAttr);
        Port port = (Port)inf.getKeyRefMos(Port.class).iterator().next();
        TranslatorUtil.encodePoSpecialAttr(1211, ConvertEnumUtil.getQLoopbackMode(port.getLoopbackMode()), asn.poSpecialAttr);
        if (!CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(PosPort.class))) {
            PosPort posPort = (PosPort)inf.getKeyRefMos(PosPort.class).iterator().next();
            TranslatorUtil.encodePoSpecialAttr(1201, ConvertEnumUtil.getPosQScramble(posPort.getScramble()), asn.poSpecialAttr);
            TranslatorUtil.encodePoSpecialAttr(1202, ConvertEnumUtil.getPosQFrameFormat(posPort.getFrameFormat()), asn.poSpecialAttr);
            TranslatorUtil.encodePoSpecialAttr(1203, ConvertEnumUtil.getPosQClock(posPort.getClock()), asn.poSpecialAttr);
            TranslatorUtil.encodePoSpecialAttr(1204, ConvertEnumUtil.getPosQCrc(posPort.getCrc()), asn.poSpecialAttr);
        }
        if (null != (extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.encodeForPos(inf, asn, context);
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        types.add(2049);
        return types;
    }
}

