/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.EthPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.IPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.PosPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.SerialPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.TrunkPortTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PortTransFactory {
    public Map<Vector<Integer>, IPortTranslator> mapTranslator = new HashMap<Vector<Integer>, IPortTranslator>();

    private PortTransFactory() {
        this.addTranslator(new EthPortTranslator());
        this.addTranslator(new PosPortTranslator());
        Object extPoitService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (null != extPoitService) {
            this.addTranslator(new SerialPortTranslator());
        } else {
            this.addTranslator(new TrunkPortTranslator());
        }
    }

    public static final PortTransFactory getInstance() {
        return SapTranslatorFactorySingleton.INSTANCE;
    }

    public synchronized void addTranslator(IPortTranslator translator) {
        if (this.mapTranslator.containsKey(translator.getType())) {
            return;
        }
        this.mapTranslator.put(translator.getType(), translator);
    }

    public IPortTranslator getTranslator(Interface mo) {
        return this.getTranslator(mo.getiQIfType());
    }

    private synchronized IPortTranslator getTranslator(Integer type) {
        for (Map.Entry<Vector<Integer>, IPortTranslator> entry : this.mapTranslator.entrySet()) {
            Vector<Integer> first = entry.getKey();
            if (!first.contains(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static class SapTranslatorFactorySingleton {
        public static final PortTransFactory INSTANCE = new PortTransFactory();

        private SapTranslatorFactorySingleton() {
        }
    }
}

