/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.factory;

import com.huawei.network.qasn.m_q_common.QAsnIDAndValueInt;
import com.huawei.network.qasn.m_q_common.QAsnIVIList;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.IPortTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ConvertEnumUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.springframework.util.CollectionUtils;

public class EthPortTranslator
implements IPortTranslator {
    @Override
    public void decode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        IMOChangeRecord moChangeRecord;
        EthernetPort ethPort;
        Port port;
        if (null == asn.poSpecialAttr) {
            return;
        }
        List lstPort = inf.getKeyRefMos(Port.class);
        if (lstPort.isEmpty()) {
            port = new Port();
            port.setDevID(inf.getDevID());
            port.setVrID(inf.getVrID());
            port.setName(inf.getIfName());
        } else {
            port = (Port)lstPort.iterator().next();
        }
        List lstEthPort = inf.getKeyRefMos(EthernetPort.class);
        if (lstEthPort.isEmpty()) {
            ethPort = new EthernetPort();
            ethPort.setDevID(inf.getDevID());
            ethPort.setVrID(inf.getVrID());
            ethPort.setPosition(inf.getIfPosition());
        } else {
            ethPort = (EthernetPort)lstEthPort.iterator().next();
        }
        ArrayList<String> lstPortChg = new ArrayList<String>();
        ArrayList<String> lstEthPortChg = new ArrayList<String>();
        for (Object obj : asn.poSpecialAttr) {
            QAsnIDAndValueInt ivi = (QAsnIDAndValueInt)obj;
            switch (ivi.id) {
                case 1316: {
                    inf.setIfMtu(Integer.valueOf(ivi.value));
                    IMOChangeRecord moChangeRecord2 = context.getTransactionContext().addChangeRecord(Interface.class);
                    moChangeRecord2.addModify((Object)inf, new PropertyChangeItem("ifMtu", null, null));
                    break;
                }
                case 1310: {
                    port.setLoopbackMode(ConvertEnumUtil.getFLoopbackMode(ivi.value));
                    lstPortChg.add("loopbackMode");
                    break;
                }
                case 1321: {
                    inf.setIfOperSpeed(Long.valueOf((long)ivi.value * 1000000L));
                    break;
                }
                case 1320: {
                    ConvertEnumUtil.setPortMode(ethPort, ivi.value, lstEthPortChg);
                    break;
                }
                case 1301: {
                    ConvertEnumUtil.setEthWorkMode(ethPort, ivi.value, lstEthPortChg);
                    break;
                }
            }
        }
        Object extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
        if (null == extPointService && !lstPortChg.isEmpty()) {
            inf.addKeyRefMo((VmfMO)port);
            context.addProperty(Port.class.getName(), (Object)port);
            moChangeRecord = context.getTransactionContext().addChangeRecord(Port.class);
            moChangeRecord.addModify((Object)port, lstPortChg);
        }
        if (!lstEthPortChg.isEmpty()) {
            inf.addKeyRefMo((VmfMO)ethPort);
            context.addProperty(EthernetPort.class.getName(), (Object)ethPort);
            moChangeRecord = context.getTransactionContext().addChangeRecord(EthernetPort.class);
            moChangeRecord.addModify((Object)ethPort, lstEthPortChg);
        }
        if (null != extPointService) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.decodeForEth(inf, asn, context);
        }
    }

    @Override
    public void encode(Interface inf, QAsnPortDetailInfo asn, IAsnTranslationContext context) {
        Object extPointService;
        if (CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(Port.class))) {
            return;
        }
        asn.poSpecialAttr = new QAsnIVIList();
        TranslatorUtil.encodePoSpecialAttr(1316, inf.getIfMtu(), asn.poSpecialAttr);
        long portSpeed = null == inf.getIfOperSpeed() ? -1L : inf.getIfOperSpeed() / 1000000L;
        TranslatorUtil.encodePoSpecialAttr(1321, portSpeed, asn.poSpecialAttr);
        Port port = (Port)inf.getKeyRefMos(Port.class).iterator().next();
        TranslatorUtil.encodePoSpecialAttr(1310, ConvertEnumUtil.getQLoopbackMode(port.getLoopbackMode()), asn.poSpecialAttr);
        if (!CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(EthernetPort.class))) {
            EthernetPort ethPort = (EthernetPort)inf.getKeyRefMos(EthernetPort.class).iterator().next();
            Object extPointService2 = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class);
            if (null != extPointService2) {
                TranslatorUtil.encodePoSpecialAttr(1301, ethPort.getWorkMode(), asn.poSpecialAttr);
            } else {
                TranslatorUtil.encodePoSpecialAttr(1301, ConvertEnumUtil.getEthWorkMode(ethPort), asn.poSpecialAttr);
            }
            TranslatorUtil.encodePoSpecialAttr(1320, ConvertEnumUtil.getPortMode(ethPort), asn.poSpecialAttr);
        }
        if (null != (extPointService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            IPortTranslatorFunctionExtPoint extPoint = (IPortTranslatorFunctionExtPoint)extPointService;
            extPoint.encodeForEth(inf, asn, context);
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        types.add(1025);
        return types;
    }
}

