/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnDot1qTermination;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnMappingTerministation;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnQinQTermination;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnStacking;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnTermBlockStation;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnTermination;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnDot1qTerminationTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnMappingTerministationTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnQinQTerminationTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnStackingTranslator;
import net.commustru.fstru.FStruct;

public class QAsnTerminationTranslator
extends AbstractAsnTranslator<QAsnTermination, EthSubIf> {
    private static final Object[][] ethSubIfMasks = new Object[][]{{"controlVid", 1}, {"flowType", 2}, {"arpBroadcastEnable", 256}, {"flowDot1qs", 4}, {"qinqTerminates", 8}};
    private static final Object[][] qasnTerminationMasks = new Object[][]{{"poDot1qTermination", 4}, {"poQinQTermination", 8}, {"poQinQStacking", 16}, {"poMappingTermination", 32}, {"poTermBlock", 64}};
    private IAsnTranslator<QAsnStacking, EthSubIf> qansStackingTranslator = new QAsnStackingTranslator();
    private IAsnTranslator<QAsnMappingTerministation, EthSubIf> qAsnMappingTerministationTranslator = new QAsnMappingTerministationTranslator();
    private IAsnTranslator<QAsnDot1qTermination, EthSubIf> qasnDot1qTerminationTranslator = new QAsnDot1qTerminationTranslator();
    private IAsnTranslator<QAsnQinQTermination, EthSubIf> qasnQinQTerminationTranslator = new QAsnQinQTerminationTranslator();
    private static final int ARPBROADCASTSTATE_ENABLE = 1;
    private static final int ARPBROADCASTSTATE_DISABLE = 2;
    private static final int ARPBROADCASTSTATE_UNKOWN = -1;

    public void decode(QAsnTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        this.decodeEthSubIf(asn, mo, context);
    }

    public void decodeEthSubIf(QAsnTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        mo.setFlowType(Integer.valueOf(asn.type));
        QAsnTerminationTranslator.getLogger().info("asn.poArpBroadcastState : " + asn.poArpBroadcastState);
        if (null != asn.poArpBroadcastState && -1 != asn.poArpBroadcastState) {
            if (1 == asn.poArpBroadcastState) {
                mo.setArpBroadcastEnable(Boolean.valueOf(true));
            } else if (2 == asn.poArpBroadcastState) {
                mo.setArpBroadcastEnable(Boolean.valueOf(false));
            }
        }
        QAsnTerminationTranslator.getLogger().info("ArpBroadcastEnable : " + mo.getArpBroadcastEnable());
        context.addProperty(EthSubIf.class.getName(), (Object)mo);
        if (1 == asn.type) {
            mo.setFlowType(EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM);
            this.decodeDot1qTermination(asn.poDot1qTermination, mo, context);
        } else if (2 == asn.type) {
            mo.setFlowType(EthSubIf.FLOW_TYPE_ENUM.QIN_QTERM);
            this.decodeQinqTermination(asn.poQinQTermination, mo, context);
        } else if (3 == asn.type) {
            mo.setFlowType(EthSubIf.FLOW_TYPE_ENUM.STACKING);
            this.decodeStackingTermination(asn.poQinQStacking, mo, context);
        } else if (4 == asn.type) {
            mo.setFlowType(EthSubIf.FLOW_TYPE_ENUM.MAPPING1TO1);
            this.docodeMappingTerm(asn.poMappingTermination, mo, context);
        } else {
            this.decodeBlockTerm(asn.poTermBlock, mo, context);
        }
        this.setChanged((VmfMO)mo, ethSubIfMasks, asn.poOperMask, context);
    }

    public void encode(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.encodeEthSubIf(mo, asn, context);
    }

    public void encodeEthSubIf(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.type = this.intValue(mo.getFlowType());
        asn.poArpBroadcastState = this.intValue(mo.getArpBroadcastEnable());
        mask |= this.setChangeMask((VmfMO)mo, context, ethSubIfMasks);
        this.encodePoDot1qTermination(mo, asn, context);
        this.encodePoQinQTermination(mo, asn, context);
        this.encodePoQinQStacking(mo, asn, context);
        this.encodePoMappingTermination(mo, asn, context);
        this.encodePoTermBlock(mo, asn, context);
        asn.poOperMask = mask |= this.getSubIfMask(mo);
    }

    public Class<QAsnTermination> getAsnClass() {
        return QAsnTermination.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }

    private void decodeBlockTerm(QAsnTermBlockStation poTermBlock, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
    }

    private void decodeDot1qTermination(QAsnDot1qTermination poDot1qTermination, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (null == poDot1qTermination) {
            return;
        }
        this.qasnDot1qTerminationTranslator.decode((FStruct)poDot1qTermination, (Object)mo, context);
    }

    private void decodeQinqTermination(QAsnQinQTermination poQinQTermination, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (null == poQinQTermination) {
            return;
        }
        this.qasnQinQTerminationTranslator.decode((FStruct)poQinQTermination, (Object)mo, context);
    }

    private void decodeStackingTermination(QAsnStacking poQinQStacking, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (null == poQinQStacking) {
            return;
        }
        this.qansStackingTranslator.decode((FStruct)poQinQStacking, (Object)mo, context);
    }

    private void docodeMappingTerm(QAsnMappingTerministation poMappingTermination, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (null == poMappingTermination) {
            return;
        }
        this.qAsnMappingTerministationTranslator.decode((FStruct)poMappingTermination, (Object)mo, context);
    }

    private void encodePoDot1qTermination(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getFlowType() || !EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM.equals(mo.getFlowType())) {
            return;
        }
        if (null == asn.poDot1qTermination) {
            asn.poDot1qTermination = new QAsnDot1qTermination();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poDot1qTermination);
        }
        this.qasnDot1qTerminationTranslator.encode((Object)mo, (FStruct)asn.poDot1qTermination, context);
    }

    private void encodePoMappingTermination(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getFlowType() || !EthSubIf.FLOW_TYPE_ENUM.MAPPING1TO1.equals(mo.getFlowType())) {
            return;
        }
        if (null == asn.poMappingTermination) {
            asn.poMappingTermination = new QAsnMappingTerministation();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poMappingTermination);
        }
        this.qAsnMappingTerministationTranslator.encode((Object)mo, (FStruct)asn.poMappingTermination, context);
    }

    private void encodePoQinQStacking(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getFlowType() || !EthSubIf.FLOW_TYPE_ENUM.STACKING.equals(mo.getFlowType())) {
            return;
        }
        if (null == asn.poQinQStacking) {
            asn.poQinQStacking = new QAsnStacking();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poQinQStacking);
        }
        this.qansStackingTranslator.encode((Object)mo, (FStruct)asn.poQinQStacking, context);
    }

    private void encodePoQinQTermination(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getFlowType() || !EthSubIf.FLOW_TYPE_ENUM.QIN_QTERM.equals(mo.getFlowType())) {
            return;
        }
        if (null == asn.poQinQTermination) {
            asn.poQinQTermination = new QAsnQinQTermination();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poQinQTermination);
        }
        this.qasnQinQTerminationTranslator.encode((Object)mo, (FStruct)asn.poQinQTermination, context);
    }

    private void encodePoTermBlock(EthSubIf mo, QAsnTermination asn, IAsnTranslationContext context) {
    }

    private int getSubIfMask(EthSubIf mo) {
        int mask = 0;
        Integer subIfType = mo.getFlowType();
        if (null != subIfType) {
            if (subIfType.equals(EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM)) {
                mask |= this.setChangeMask(1, qasnTerminationMasks, "poDot1qTermination");
            } else if (subIfType.equals(EthSubIf.FLOW_TYPE_ENUM.QIN_QTERM)) {
                mask |= this.setChangeMask(1, qasnTerminationMasks, "poQinQTermination");
            } else if (subIfType.equals(EthSubIf.FLOW_TYPE_ENUM.STACKING)) {
                mask |= this.setChangeMask(1, qasnTerminationMasks, "poQinQStacking");
            } else if (subIfType.equals(EthSubIf.FLOW_TYPE_ENUM.MAPPING1TO1)) {
                mask |= this.setChangeMask(1, qasnTerminationMasks, "poMappingTermination");
            }
        }
        return mask;
    }
}

