/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnStacking;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanGroup;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanIDSection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanIDSectionList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.FlowDot1q;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class QAsnStackingTranslator
extends AbstractAsnTranslator<QAsnStacking, EthSubIf> {
    private static final Object[][] qasnVlanGroupMask = new Object[][]{{"vlanGrpID", 1}, {"statistic", 2}};
    private static final Object[][] qasnVlanIDSectionMasks = new Object[][]{{"vlanBound", 1}, {"vlanGroup", 2}};

    public void decode(QAsnStacking asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (asn.vlanIDList.isEmpty()) {
            return;
        }
        ArrayList<FlowDot1q> flows = new ArrayList<FlowDot1q>();
        QAsnVlanIDSectionList vlanlst = asn.vlanIDList;
        for (QAsnVlanIDSection vlan : vlanlst) {
            FlowDot1q flow = new FlowDot1q();
            flow.setDevID(mo.getDevID());
            flow.setVrID(mo.getVrID());
            flow.setIfName(mo.getIfName());
            flow.setEthType(Integer.valueOf(3));
            if (!vlan.vlanBound.isEmpty()) {
                flow.setVlanIdBgn(Long.valueOf(vlan.vlanBound.firstElement().toString()));
                flow.setVlanIdEnd(Integer.valueOf(vlan.vlanBound.lastElement().toString()));
            }
            flows.add(flow);
        }
        if (EOperationType.MODIFY == context.getOperType()) {
            ItemChangedUtil.setItemChangedInList(flows, FlowDot1q.class, EthSubIf.class, mo, context);
        }
        IMOChangeRecord record = context.getTransactionContext().getChangeRecord(FlowDot1q.class);
        Set modifys = record.getModifies();
        Iterator iter = modifys.iterator();
        while (iter.hasNext()) {
            record.cancelModify(iter.next());
        }
        mo.addFlowDot1qs(flows);
    }

    public void encode(EthSubIf mo, QAsnStacking asn, IAsnTranslationContext context) throws VMFException {
        if (mo.getFlowDot1qs().isEmpty() || 3 != this.intValue(mo.getFlowType())) {
            return;
        }
        Collection flows = mo.getFlowDot1qs();
        for (FlowDot1q flow : flows) {
            this.encodeStackingVlan(flow, asn, context);
        }
    }

    public Class<QAsnStacking> getAsnClass() {
        return QAsnStacking.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }

    private void encodeStackingVlan(FlowDot1q flow, QAsnStacking asn, IAsnTranslationContext context) {
        if (null == flow) {
            return;
        }
        QAsnVlanIDSection vlanSection = new QAsnVlanIDSection();
        if (null == vlanSection.vlanGroup) {
            vlanSection.vlanGroup = new QAsnVlanGroup();
        }
        QAsnStackingTranslator.getLogger().info("flow : " + flow);
        QAsnStackingTranslator.getLogger().info("flow.getGroupId() : " + flow.getGroupId());
        vlanSection.vlanGroup.vlanGrpID = this.intValue(flow.getGroupId());
        vlanSection.vlanGroup.poOperMask = new Integer(0);
        QAsnVlanGroup qAsnVlanGroup = vlanSection.vlanGroup;
        qAsnVlanGroup.poOperMask = qAsnVlanGroup.poOperMask | this.setChangeMask((VmfMO)flow, context, qasnVlanGroupMask);
        Integer iVlanBegin = this.intValue(flow.getVlanIdBgn());
        Integer iVlanEnd = this.intValue(flow.getVlanIdEnd());
        for (int i = iVlanBegin.intValue(); i <= iVlanEnd; ++i) {
            vlanSection.vlanBound.add((Object)new Integer(i));
        }
        asn.vlanIDList.add((Object)vlanSection);
    }
}

