/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnQinQSection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnQinQSectionList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnQinQTermination;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanGroup;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqTerminate;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.spec.QAsnQinQTerminationSpecTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import java.util.ArrayList;
import java.util.Collection;

public class QAsnQinQTerminationTranslator
extends AbstractAsnTranslator<QAsnQinQTermination, EthSubIf> {
    private static final Object[][] qasnQinQSectionMasks = new Object[][]{{"sVlanID", 1}, {"cVlanBound", 2}, {"vlanGroup", 2}};
    private static final Object[][] qasnQinQTerminationMasks = new Object[][]{{"qinqSectionList", 32}};
    private QAsnQinQTerminationSpecTranslator qasnQinQTerminationSpecTranslator = new QAsnQinQTerminationSpecTranslator();

    public void decode(QAsnQinQTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        context.addProperty(EthSubIf.class.getName(), (Object)mo);
        this.decodeQinqVlan(asn, mo, context);
        this.decodeQinqExtInfo(asn, mo, context);
    }

    public void decodeQinqExtInfo(QAsnQinQTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        EthSubIf ethSubIf = (EthSubIf)context.getProperty(EthSubIf.class.getName());
        mo.setDevID(ethSubIf.getDevID());
        mo.setVrID(ethSubIf.getVrID());
        mo.setIfName(ethSubIf.getIfName());
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setRemarkType(Integer.valueOf(this.intValue(asn.map8021pMode)));
        if (-1 != this.intValue(asn.symmetry)) {
            mo.setIsSymmetry(Integer.valueOf(this.intValue(asn.symmetry)));
        }
    }

    public void encode(EthSubIf mo, QAsnQinQTermination asn, IAsnTranslationContext context) throws VMFException {
        this.encodeQinqExtInfo(mo, asn, context);
        this.encodeCePeVlanInfo(mo.getQinqTerminates(), asn, context);
    }

    public void encodeQinqExtInfo(EthSubIf mo, QAsnQinQTermination asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo) {
            return;
        }
        int mask = 0;
        asn.symmetry = this.intValue(mo.getIsSymmetry());
        this.qasnQinQTerminationSpecTranslator.encodeMap8021pMode(asn, mo, context);
        asn.map8021pMode = this.intValue(mo.getRemarkType());
        asn.manual8021pPre = this.intValue(mo.getPrecedenceVal());
        asn.poUserModeState = this.intValue(mo.getUserMode());
        asn.poOperMask = mask;
    }

    public Class<QAsnQinQTermination> getAsnClass() {
        return QAsnQinQTermination.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }

    private void decodeCePeVIDInfo(QAsnQinQSection vlan, QinqTerminate flow, IAsnTranslationContext context) {
        if (null == vlan) {
            return;
        }
        if (!vlan.cVlanBound.isEmpty()) {
            flow.setCeVlanIdBgn(Long.valueOf(vlan.cVlanBound.firstElement().toString()));
            flow.setCeVlanIdEnd(Integer.valueOf(vlan.cVlanBound.lastElement().toString()));
        }
        if (!vlan.sVlanID.isEmpty()) {
            flow.setPeVlanIdBgn(Integer.valueOf(vlan.sVlanID.firstElement().toString()));
            flow.setPeVlanIdEnd(Long.valueOf(vlan.sVlanID.firstElement().toString()));
        }
        flow.setGroupId(Integer.valueOf(vlan.vlanGroup.vlanGrpID));
    }

    private void decodeQinqVlan(QAsnQinQTermination asn, EthSubIf mo, IAsnTranslationContext context) {
        QAsnQinQSectionList qinqSectionList = asn.qinqSectionList;
        if (null == qinqSectionList || qinqSectionList.isEmpty()) {
            return;
        }
        ArrayList<QinqTerminate> flows = new ArrayList<QinqTerminate>();
        QAsnQinQSectionList vlans = qinqSectionList;
        for (QAsnQinQSection vlan : vlans) {
            QinqTerminate flow = new QinqTerminate();
            flow.setDevID(mo.getDevID());
            flow.setVrID(mo.getVrID());
            flow.setIfName(mo.getIfName());
            this.decodeCePeVIDInfo(vlan, flow, context);
            flows.add(flow);
        }
        if (null != asn.poOperMask && asn.poOperMask > 0) {
            ItemChangedUtil.setItemChangedInList(flows, QinqTerminate.class, EthSubIf.class, mo, context);
        }
        mo.addQinqTerminates(flows);
    }

    private void encodeCePeVlanInfo(Collection<QinqTerminate> flowIdentifys, QAsnQinQTermination asn, IAsnTranslationContext context) {
        if (null == flowIdentifys || flowIdentifys.isEmpty()) {
            return;
        }
        if (null == asn.qinqSectionList) {
            asn.qinqSectionList = new QAsnQinQSectionList();
        }
        for (QinqTerminate flow : flowIdentifys) {
            QAsnQinQSection qinq = new QAsnQinQSection();
            this.encodeVlanInfo(flow, qinq, context);
            asn.qinqSectionList.add((Object)qinq);
        }
        QAsnQinQTermination qAsnQinQTermination = asn;
        qAsnQinQTermination.poOperMask = qAsnQinQTermination.poOperMask | this.setChangeMask(1, qasnQinQTerminationMasks, "qinqSectionList");
    }

    private void encodeVlanInfo(QinqTerminate flow, QAsnQinQSection qinq, IAsnTranslationContext context) {
        if (null == flow) {
            return;
        }
        if (null == qinq.vlanGroup) {
            qinq.vlanGroup = new QAsnVlanGroup();
        }
        qinq.vlanGroup.vlanGrpID = this.intValue(flow.getGroupId());
        if (null == qinq.sVlanID) {
            qinq.sVlanID = new QAsnTinyIntList();
        }
        qinq.sVlanID.add((Object)this.intValue(flow.getPeVlanIdBgn()));
        if (null == qinq.cVlanBound) {
            qinq.cVlanBound = new QAsnTinyIntList();
        }
        int ceVlanIdBgn = this.intValue(flow.getCeVlanIdBgn());
        int ceVlanIdEnd = this.intValue(flow.getCeVlanIdEnd());
        for (int i = ceVlanIdBgn; i <= ceVlanIdEnd && i < Integer.MAX_VALUE; ++i) {
            qinq.cVlanBound.add((Object)i);
        }
        int mask = 0;
        mask |= this.setChangeMask(1, qasnQinQSectionMasks, "sVlanID");
        mask |= this.setChangeMask(1, qasnQinQSectionMasks, "cVlanBound");
        qinq.poOperMask = mask |= this.setChangeMask(1, qasnQinQSectionMasks, "vlanGroup");
    }
}

