/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnMappingSection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnMappingSectionList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnMappingTerministation;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanGroup;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqMapping;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import java.util.ArrayList;
import java.util.Collection;

public class QAsnMappingTerministationTranslator
extends AbstractAsnTranslator<QAsnMappingTerministation, EthSubIf> {
    private static final Object[][] qasnQinQMappingSeciontMasks = new Object[][]{{"poicVlanID", 8}, {"poiMapCVlanID", 16}, {"poVlanGroup", 64}};

    public void decode(QAsnMappingTerministation asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        QAsnMappingSectionList mappingList = asn.mappingList;
        ArrayList<QinqMapping> mappings = new ArrayList<QinqMapping>();
        QAsnMappingSectionList mappingLists = mappingList;
        for (QAsnMappingSection section : mappingLists) {
            QinqMapping mapping = new QinqMapping();
            mapping.setDevID(mo.getDevID());
            mapping.setVrID(mo.getVrID());
            mapping.setIfName(mo.getIfName());
            mapping.setVlanId(Integer.valueOf(this.intValue(section.poicVlanID)));
            mapping.setMappingVid(Integer.valueOf(this.intValue(section.poiMapCVlanID)));
            if (null != section.poVlanGroup) {
                mapping.setGroupId(Integer.valueOf(this.intValue(section.poVlanGroup.vlanGrpID)));
            }
            mappings.add(mapping);
        }
        ItemChangedUtil.setItemChangedInList(mappings, QinqMapping.class, EthSubIf.class, mo, context);
        mo.addQinqMappings(mappings);
    }

    public void encode(EthSubIf mo, QAsnMappingTerministation asn, IAsnTranslationContext context) throws VMFException {
        Collection mappings = mo.getQinqMappings();
        if (null == mappings || mappings.isEmpty()) {
            return;
        }
        if (null == asn.mappingList) {
            asn.mappingList = new QAsnMappingSectionList();
        }
        for (QinqMapping mapping : mappings) {
            int mask = 0;
            QAsnMappingSection qsection = new QAsnMappingSection();
            if (null != mapping.getGroupId()) {
                if (null == qsection.poVlanGroup) {
                    qsection.poVlanGroup = new QAsnVlanGroup();
                }
                qsection.poVlanGroup.vlanGrpID = this.intValue(mapping.getGroupId());
                mask |= this.setChangeMask(1, qasnQinQMappingSeciontMasks, "poVlanGroup");
            }
            qsection.poicVlanID = this.intValue(mapping.getVlanId());
            qsection.poiMapCVlanID = this.intValue(mapping.getMappingVid());
            mask |= this.setChangeMask(1, qasnQinQMappingSeciontMasks, "poicVlanID");
            qsection.poOperMask = mask |= this.setChangeMask(1, qasnQinQMappingSeciontMasks, "poiMapCVlanID");
            asn.mappingList.add((Object)qsection);
        }
    }

    public Class<QAsnMappingTerministation> getAsnClass() {
        return QAsnMappingTerministation.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }
}

