/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnEthCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.ethernet.IQAsnEthCtpTranslatorExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnEthCtpTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnEthSapTranslator
implements ISAPTranslator {
    private IAsnTranslator<QAsnEthCtp, EthSubIf> ethCtpTranslator = new QAsnEthCtpTranslator();
    private IAsnTranslator<QAsnSAP, Interface> interfaceTranslator = new QAsnSapTranslator();

    @Override
    public Interface decode(IAsnTranslationContext context, QAsnSAP sap) throws VMFException {
        Interface mo = new Interface();
        this.decode(context, sap, mo);
        return mo;
    }

    @Override
    public void decode(IAsnTranslationContext context, QAsnSAP sap, Interface mo) throws VMFException {
        if (null == sap || null == mo) {
            return;
        }
        this.interfaceTranslator.decode((FStruct)sap, (Object)mo, context);
        context.addProperty("sapAsn", (Object)sap);
        if (EOperationType.UNDEPLOY == context.getOperType()) {
            return;
        }
        if (null == sap.poLinkProtocol || null == sap.poLinkProtocol.poEthCtp) {
            if (EOperationType.DELETE == context.getOperType() || null != sap.poOperMask && (2 & sap.poOperMask) > 0) {
                if (null == sap.poLinkProtocol) {
                    sap.poLinkProtocol = new QAsnLinkProtocol();
                }
                if (null == sap.poLinkProtocol.poEthCtp) {
                    sap.poLinkProtocol.poEthCtp = new QAsnEthCtp();
                }
            } else {
                return;
            }
        }
        EthSubIf subIfmo = new EthSubIf();
        Object obj = context.getProperty(Interface.class.getName());
        if (null == obj) {
            return;
        }
        Interface ifmo = (Interface)obj;
        int type = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ifmo.getIfName());
        if (65559 != type && 65570 != type) {
            return;
        }
        this.ethCtpTranslator.decode((FStruct)sap.poLinkProtocol.poEthCtp, (Object)subIfmo, context);
        mo.addKeyRefMo((VmfMO)subIfmo);
    }

    @Override
    public QAsnSAP encode(IAsnTranslationContext context, Interface mo) throws VMFException {
        QAsnSAP asn = new QAsnSAP();
        AsnUtil.setDefaultAsnValue((FStruct)asn);
        this.encode(context, mo, asn);
        return asn;
    }

    @Override
    public void encode(IAsnTranslationContext context, Interface mo, QAsnSAP asn) throws VMFException {
        this.interfaceTranslator.encode((Object)mo, (FStruct)asn, context);
        Map mapRefMo = mo.getKeyRefMos();
        if (mapRefMo.containsKey(EthSubIf.class)) {
            List subifs = (List)mapRefMo.get(EthSubIf.class);
            if (CollectionUtils.isEmpty((Collection)subifs)) {
                return;
            }
            EthSubIf subif = (EthSubIf)subifs.iterator().next();
            if (null == subif.getFlowType() || -1 == subif.getFlowType()) {
                return;
            }
            if (null == asn.poLinkProtocol) {
                asn.poLinkProtocol = new QAsnLinkProtocol();
            }
            asn.poLinkProtocol.type = 1;
            if (null == asn.poLinkProtocol.poEthCtp) {
                asn.poLinkProtocol.poEthCtp = new QAsnEthCtp();
            }
            this.ethCtpTranslator.encode((Object)subif, (FStruct)asn.poLinkProtocol.poEthCtp, context);
            this.setLinkProtocolChange(asn.poLinkProtocol.poEthCtp.poOperMask, asn);
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        Object qAsnEthCtpTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnEthCtpTranslatorExtPoint.class);
        if (null != qAsnEthCtpTranslatorExtPoint) {
            types.add(1025);
            types.add(65549);
        }
        types.add(65559);
        types.add(65570);
        return types;
    }

    private void setLinkProtocolChange(Integer poOperMask, QAsnSAP asn) {
        if (null != poOperMask && poOperMask > 0) {
            if (null == asn.poOperMask) {
                asn.poOperMask = new Integer(0);
            }
            asn.poOperMask = asn.poOperMask | 4;
        }
    }
}

