/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnEthCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnEthVlan;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnTermination;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.ethernet.IQAsnEthCtpTranslatorExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnTerminationTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Arrays;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnEthCtpTranslator
extends AbstractAsnTranslator<QAsnEthCtp, EthSubIf> {
    private static final Object[][] ethSubIfMasks = new Object[][]{{"vlanTypeVid", 2}, {"flowDot1qs", 4}, {"qinqTerminates", 4}, {"flowGroups", 4}, {"controlVid", 4}};
    private static final Object[][] qasnEthCtpMasks = new Object[][]{{"poTerm", 4}, {"poEthVlan", 2}};
    private static final Object[][] vlanIDMasks = new Object[][]{{"vlanTypeVid", 1}, {"dot1qBitmap", 1}};
    private IAsnTranslator<QAsnTermination, EthSubIf> qasnTerminationTranslator = new QAsnTerminationTranslator();

    public void decode(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        this.decodeEthSubIf(asn, mo, context);
        context.addProperty(EthSubIf.class.getName(), (Object)mo);
        this.setChanged((VmfMO)mo, qasnEthCtpMasks, asn.poOperMask, context);
    }

    public void decodeEthSubIf(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        Object qAsnEthCtpTranslatorExtPoint;
        Interface ifmo = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(ifmo.getDevID());
        mo.setVrID(ifmo.getVrID());
        mo.setIfName(ifmo.getIfName());
        mo.setFdn(ifmo.getFdn());
        mo.setDeployStatus(ifmo.getDeployStatus());
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        QAsnSAP sap = (QAsnSAP)context.getProperty("sapAsn");
        if (null != sap && null != sap.poOperMask) {
            if ((1 & sap.poOperMask) > 0) {
                context.getTransactionContext().getChangeRecord(EthSubIf.class).addCreate((Object)mo);
                operType = EOperationType.CREATE;
            } else if ((2 & sap.poOperMask) > 0) {
                context.getTransactionContext().getChangeRecord(EthSubIf.class).addDelete((Object)mo);
                operType = EOperationType.DELETE;
            }
        }
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        Collection ethSubIfs = DaoFactory.getInstance().getDefaultVmfDao(null).queryByKey(EthSubIf.class, Arrays.asList(mo), false);
        if (!CollectionUtils.isEmpty((Collection)ethSubIfs)) {
            context.getTransactionContext().getChangeRecord(EthSubIf.class).cancelCreate((Object)mo);
        }
        if (null != (qAsnEthCtpTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnEthCtpTranslatorExtPoint.class))) {
            ((IQAsnEthCtpTranslatorExtPoint)qAsnEthCtpTranslatorExtPoint).decodePoEthVlan(asn, mo, context, vlanIDMasks);
        } else if (1 == asn.ethCtpType) {
            this.decodePoEthVlan(asn, mo, context);
        } else if (2 == asn.ethCtpType) {
            this.decodePoTerm(asn, mo, context);
        } else {
            this.decodePoOperPri(asn, mo, context);
        }
    }

    public void encode(EthSubIf mo, QAsnEthCtp asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.encodeEthSubIf(mo, asn, context);
    }

    public void encodeEthSubIf(EthSubIf mo, QAsnEthCtp asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, ethSubIfMasks);
        Object qAsnEthCtpTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnEthCtpTranslatorExtPoint.class);
        if (null != qAsnEthCtpTranslatorExtPoint) {
            ((IQAsnEthCtpTranslatorExtPoint)qAsnEthCtpTranslatorExtPoint).encodePoEthVlan(asn, mo, context);
            if (null != asn.poEthVlan) {
                mask |= this.setChangeMask(asn.poEthVlan.poOperMask, qasnEthCtpMasks, "poEthVlan");
            }
        } else if (EthSubIf.FLOW_TYPE_ENUM.VLAN_TYPE.equals(mo.getFlowType())) {
            this.encodePoEthVlan(asn, mo, context);
            if (null != asn.poEthVlan) {
                mask |= this.setChangeMask(asn.poEthVlan.poOperMask, qasnEthCtpMasks, "poEthVlan");
            }
        } else {
            this.encodePoTerm(mo, asn, context);
            if (null != asn.poTerm) {
                mask |= this.setChangeMask(asn.poTerm.poOperMask, qasnEthCtpMasks, "poTerm");
            }
        }
        asn.poOperMask = mask;
    }

    public Class<QAsnEthCtp> getAsnClass() {
        return QAsnEthCtp.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }

    private void decodePoEthVlan(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) {
        if (null == asn.poEthVlan) {
            return;
        }
        if (asn.poEthVlan.vlanIDList.isEmpty()) {
            return;
        }
        mo.setFlowType(EthSubIf.FLOW_TYPE_ENUM.VLAN_TYPE);
        mo.setVlanTypeVid(Integer.valueOf(asn.poEthVlan.vlanIDList.iterator().next().toString()));
        this.setChanged((VmfMO)mo, vlanIDMasks, asn.poEthVlan.poOperMask, context);
    }

    private void decodePoOperPri(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) {
    }

    private void decodePoTerm(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poTerm) {
            return;
        }
        this.qasnTerminationTranslator.decode((FStruct)asn.poTerm, (Object)mo, context);
    }

    private void encodePoEthVlan(QAsnEthCtp asn, EthSubIf mo, IAsnTranslationContext context) {
        if (null == mo.getVlanTypeVid()) {
            return;
        }
        asn.ethCtpType = 1;
        Integer vlan = mo.getVlanTypeVid();
        if (null == vlan || -1 == vlan) {
            return;
        }
        if (null == asn.poEthVlan) {
            asn.poEthVlan = new QAsnEthVlan();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poEthVlan);
        }
        asn.poEthVlan.vlanIDList.addAll((Collection)CommonUtil.genList((Object[])new Integer[]{vlan}));
    }

    private void encodePoOperPri(EthSubIf mo, QAsnEthCtp asn, IAsnTranslationContext context) {
    }

    private void encodePoTerm(EthSubIf mo, QAsnEthCtp asn, IAsnTranslationContext context) throws VMFException {
        asn.ethCtpType = 2;
        if (null == asn.poTerm) {
            asn.poTerm = new QAsnTermination();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poTerm);
        }
        this.qasnTerminationTranslator.encode((Object)mo, (FStruct)asn.poTerm, context);
    }
}

