/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ethernet;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnDot1qTermination;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanGroup;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanIDSection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnVlanIDSectionList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.FlowDot1q;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.util.ItemChangedUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnDot1qTerminationTranslator
extends AbstractAsnTranslator<QAsnDot1qTermination, EthSubIf> {
    private static final Object[][] qasnDot1qTerminationMasks = new Object[][]{{"vlanIDList", 1}, {"poOperPri", 2}};
    private static final Object[][] qasnVlanIDSectionMasks = new Object[][]{{"vlanBound", 1}, {"vlanGroup", 2}};

    public void decode(QAsnDot1qTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        this.decodeFlowIdentify(asn, mo, context);
    }

    public void decodeFlowIdentify(QAsnDot1qTermination asn, EthSubIf mo, IAsnTranslationContext context) throws VMFException {
        if (asn.vlanIDList.isEmpty()) {
            return;
        }
        ArrayList<FlowDot1q> flows = new ArrayList<FlowDot1q>();
        QAsnVlanIDSectionList vlanlst = asn.vlanIDList;
        for (QAsnVlanIDSection vlan : vlanlst) {
            FlowDot1q flow = new FlowDot1q();
            flow.setDevID(mo.getDevID());
            flow.setVrID(mo.getVrID());
            flow.setIfName(mo.getIfName());
            this.decodeVlanInfo(vlan, flow, context);
            flows.add(flow);
        }
        asn.poOperMask = null == asn.poOperMask ? new Integer(0) : asn.poOperMask;
        asn.poOperMask = asn.poOperMask | this.setChangeMask(1, qasnDot1qTerminationMasks, "vlanIDList");
        QAsnDot1qTerminationTranslator.getLogger().info("decodeFlowIdentify asn.poOperMask : " + asn.poOperMask);
        if (null != asn.poOperMask && asn.poOperMask > 0) {
            QAsnDot1qTerminationTranslator.getLogger().info("setItemChangedInList.");
            ItemChangedUtil.setItemChangedInList(flows, FlowDot1q.class, EthSubIf.class, mo, context);
        }
        mo.addFlowDot1qs(flows);
    }

    public void encode(EthSubIf mo, QAsnDot1qTermination asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        if (CollectionUtils.isEmpty((Collection)mo.getFlowDot1qs()) || 1 != this.intValue(mo.getFlowType())) {
            return;
        }
        Collection flows = mo.getFlowDot1qs();
        for (FlowDot1q flow : flows) {
            this.encodeVlan(flow, asn, context);
        }
        asn.poOperMask = mask |= this.setChangeMask(1, qasnDot1qTerminationMasks, "vlanIDList");
    }

    public void encodeFlowIdentify(FlowDot1q mo, QAsnDot1qTermination asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        this.encodePoOperPri(mo, asn, context);
        asn.poOperMask = mask |= this.setChangeMask(asn.poOperPri.poOperMask, qasnDot1qTerminationMasks, "poOperPri");
    }

    public Class<QAsnDot1qTermination> getAsnClass() {
        return QAsnDot1qTermination.class;
    }

    public Class<EthSubIf> getMoClass() {
        return EthSubIf.class;
    }

    private void decodePoOperPri(QAsnVlanIDSection asn, FlowDot1q mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poOperPri) {
            return;
        }
    }

    private void decodeVlanInfo(QAsnVlanIDSection asn, FlowDot1q mo, IAsnTranslationContext context) {
        if (null == asn) {
            return;
        }
        mo.setEthType(Integer.valueOf(1));
        if (!asn.vlanBound.isEmpty()) {
            mo.setVlanIdBgn(Long.valueOf(asn.vlanBound.firstElement().toString()));
            mo.setVlanIdEnd(Integer.valueOf(asn.vlanBound.lastElement().toString()));
        }
        mo.setGroupId(Integer.valueOf(asn.vlanGroup.vlanGrpID));
        this.setChanged((VmfMO)mo, qasnDot1qTerminationMasks, asn.poOperMask, context);
    }

    private void encodePoOperPri(FlowDot1q mo, QAsnDot1qTermination asn, IAsnTranslationContext context) throws VMFException {
    }

    private void encodeVlan(FlowDot1q flow, QAsnDot1qTermination asn, IAsnTranslationContext context) {
        QAsnVlanIDSection vlanSection = new QAsnVlanIDSection();
        if (null == vlanSection.vlanGroup) {
            vlanSection.vlanGroup = new QAsnVlanGroup();
        }
        vlanSection.vlanGroup.vlanGrpID = this.intValue(flow.getGroupId());
        Integer iVlanBegin = flow.getVlanIdBgn().intValue();
        Integer iVlanEnd = flow.getVlanIdEnd();
        for (int i = iVlanBegin.intValue(); i <= iVlanEnd; ++i) {
            vlanSection.vlanBound.add((Object)new Integer(i));
        }
        asn.vlanIDList.add((Object)vlanSection);
    }
}

