/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.atm;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAtmCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAtmPVC;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAtmPVP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvc;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvp;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.atm.QAsnAtmPVCTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.atm.QAsnAtmPVPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnAtmSapTranslator
implements ISAPTranslator {
    private IAsnTranslator<QAsnSAP, Interface> interfaceTranslator = new QAsnSapTranslator();
    private IAsnTranslator<QAsnAtmPVC, AtmPvc> PVCTranslator = new QAsnAtmPVCTranslator();
    private IAsnTranslator<QAsnAtmPVP, AtmPvp> PVPTranslator = new QAsnAtmPVPTranslator();

    @Override
    public Interface decode(IAsnTranslationContext context, QAsnSAP sap) throws VMFException {
        Interface mo = new Interface();
        this.decode(context, sap, mo);
        return mo;
    }

    @Override
    public void decode(IAsnTranslationContext context, QAsnSAP sap, Interface mo) throws VMFException {
        if (null == sap || null == mo) {
            return;
        }
        this.interfaceTranslator.decode((FStruct)sap, (Object)mo, context);
        if (EOperationType.UNDEPLOY == context.getOperType()) {
            return;
        }
        if ((null == sap.poLinkProtocol || null == sap.poLinkProtocol.poAtmCtp) && EOperationType.DELETE != context.getOperType()) {
            return;
        }
        if (null == sap.poLinkProtocol) {
            sap.poLinkProtocol = new QAsnLinkProtocol();
        }
        if (null == sap.poLinkProtocol.poAtmCtp) {
            sap.poLinkProtocol.poAtmCtp = new QAsnAtmCtp();
        }
        AtmInterface subIfmo = new AtmInterface();
        this.PVCTranslator.decode((Collection)sap.poLinkProtocol.poAtmCtp.poPVCList, context);
        this.PVPTranslator.decode((Collection)sap.poLinkProtocol.poAtmCtp.poPVPList, context);
        mo.addKeyRefMo((VmfMO)subIfmo);
    }

    @Override
    public QAsnSAP encode(IAsnTranslationContext context, Interface mo) throws VMFException {
        QAsnSAP asn = new QAsnSAP();
        AsnUtil.setDefaultAsnValue((FStruct)asn);
        this.encode(context, mo, asn);
        return asn;
    }

    @Override
    public void encode(IAsnTranslationContext context, Interface mo, QAsnSAP asn) throws VMFException {
        this.interfaceTranslator.encode((Object)mo, (FStruct)asn, context);
        Map mapRefMo = mo.getKeyRefMos();
        if (mapRefMo.containsKey(AtmInterface.class)) {
            List subifs = (List)mapRefMo.get(AtmInterface.class);
            if (CollectionUtils.isEmpty((Collection)subifs)) {
                return;
            }
            AtmInterface subif = (AtmInterface)subifs.iterator().next();
            if (null == asn.poLinkProtocol) {
                asn.poLinkProtocol = new QAsnLinkProtocol();
            }
            asn.poLinkProtocol.type = 2;
            if (null == asn.poLinkProtocol.poAtmCtp) {
                asn.poLinkProtocol.poAtmCtp = new QAsnAtmCtp();
            }
            this.PVCTranslator.encode(subif.getAtmPvcs(), context);
            this.PVPTranslator.encode(subif.getAtmPvps(), context);
            this.setLinkProtocolChange(asn.poLinkProtocol.poAtmCtp.poOperMask, asn);
        }
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        types.add(65560);
        types.add(65537);
        return types;
    }

    private void setLinkProtocolChange(Integer poOperMask, QAsnSAP asn) {
        if (null != poOperMask && poOperMask > 0) {
            if (null == asn.poOperMask) {
                asn.poOperMask = new Integer(0);
            }
            asn.poOperMask = asn.poOperMask | 4;
        }
    }
}

