/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.atm;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAtmPVC;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvc;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.atm.spec.QAsnAtmPVCSpecTranslator;

public class QAsnAtmPVCTranslator
extends AbstractAsnTranslator<QAsnAtmPVC, AtmPvc> {
    public static final int ATM_PVC_ENCAPSULATION_CHG = 8;
    public static final int ATM_PVC_IPOA_CHG = 64;
    public static final int ATM_PVC_NAME_CHG = 1;
    public static final int ATM_PVC_VCI_CHG = 4;
    public static final int ATM_PVC_VPI_CHG = 2;
    public static final Object[][] z_atmPVCMasks = new Object[][]{{"atmPvcName", 1}, {"vci", 2}, {"vci", 4}};
    public static final Object[][] z_qasnAtmPVCMasks = new Object[][]{{"name", 1}, {"vpi", 2}, {"vci", 4}, {"encapsulation", 8}, {"poIpoA", 64}};
    private QAsnAtmPVCSpecTranslator qasnAtmPVCSpecTranslator = new QAsnAtmPVCSpecTranslator();

    public void decode(QAsnAtmPVC asn, AtmPvc mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeAtmPVC(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnAtmPVCSpecTranslator.decodeEncapsulation(asn, mo, context);
        this.qasnAtmPVCSpecTranslator.decodePoIpoA(asn, mo, context);
    }

    public void decodeAtmPVC(QAsnAtmPVC asn, AtmPvc mo, IAsnTranslationContext context) throws VMFException {
        Interface ifmatmInterface = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(ifmatmInterface.getDevID());
        mo.setVrID(ifmatmInterface.getVrID());
        mo.setIfName(ifmatmInterface.getIfName());
        context.addProperty(AtmPvc.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.qasnAtmPVCSpecTranslator.decodeName(asn, mo, context);
        this.qasnAtmPVCSpecTranslator.decodeVpi(asn, mo, context);
        this.qasnAtmPVCSpecTranslator.decodeVci(asn, mo, context);
        int operMask = asn.poOperMask == 0 ? 7 : asn.poOperMask;
        this.setChanged((VmfMO)mo, z_atmPVCMasks, operMask, context);
    }

    public void encode(AtmPvc mo, QAsnAtmPVC asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeAtmPVC(mo, asn, context);
        this.qasnAtmPVCSpecTranslator.encodeEncapsulation(mo, asn, context);
        this.qasnAtmPVCSpecTranslator.encodePoIpoA(mo, asn, context);
    }

    public void encodeAtmPVC(AtmPvc mo, QAsnAtmPVC asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        this.qasnAtmPVCSpecTranslator.encodeName(mo, asn, context);
        this.qasnAtmPVCSpecTranslator.encodeVpi(mo, asn, context);
        this.qasnAtmPVCSpecTranslator.encodeVci(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_atmPVCMasks));
    }

    public Class<QAsnAtmPVC> getAsnClass() {
        return QAsnAtmPVC.class;
    }

    public Class<AtmPvc> getMoClass() {
        return AtmPvc.class;
    }
}

