/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.SAPTransFactory;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QAsnTranslator
implements IAsnTranslator<QAsnSAP, Interface> {
    private static final Logger logger = LoggerFactory.getLogger(QAsnTranslator.class);

    public Collection<Interface> decode(Collection<QAsnSAP> asns, IAsnTranslationContext context) throws VMFException {
        HashSet<Interface> mos = new HashSet<Interface>();
        for (QAsnSAP sap : asns) {
            ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator(sap);
            if (null == trans) {
                logger.info("can't find translator for:", (Object)sap);
                throw new NullPointerException();
            }
            mos.add(trans.decode(context, sap));
        }
        return mos;
    }

    public Interface decode(QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator(asn);
        if (null == trans) {
            logger.info("can't find translator for asn:", (Object)asn.toString());
            throw new NullPointerException();
        }
        return trans.decode(context, asn);
    }

    public void decode(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator(asn);
        if (null == trans) {
            logger.info("can't find translator for asn:", (Object)asn.toString());
            throw new NullPointerException();
        }
        trans.decode(context, asn, mo);
    }

    public Collection<QAsnSAP> encode(Collection<Interface> mos, IAsnTranslationContext context) throws VMFException {
        HashSet<QAsnSAP> saps = new HashSet<QAsnSAP>();
        for (Interface mo : mos) {
            ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator((VmfMO)mo);
            if (null == trans) {
                logger.info("can't find translator for:", (Object)mo);
                throw new NullPointerException();
            }
            QAsnSAP sap = trans.encode(context, mo);
            saps.add(sap);
        }
        return saps;
    }

    public QAsnSAP encode(Interface mo, IAsnTranslationContext context) throws VMFException {
        ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator((VmfMO)mo);
        if (null == trans) {
            logger.info("can't find translator for : " + mo);
            return null;
        }
        return trans.encode(context, mo);
    }

    public void encode(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        ISAPTranslator trans = SAPTransFactory.getInstance().getTranslator((VmfMO)mo);
        if (null == trans) {
            logger.info("can't find translator for:", (Object)mo);
            throw new NullPointerException();
        }
        trans.encode(context, mo, asn);
    }

    public Class<QAsnSAP> getAsnClass() {
        return QAsnSAP.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }
}

