/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesBoardMap;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesBoardMapList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesHighChannel;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesLowChannel;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesPortMap;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnGetCesFreeBoardMapReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnGetCesFreeBoardMapRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQQueryCesFreeBoardMapTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQQueryTask;
import com.huawei.vmf.adapter.fservice.ifm.model.ChannelSet;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QQueryCesFreeBoardMapTask
extends AbstractQQueryTask<QAsnGetCesFreeBoardMapReq, QAsnGetCesFreeBoardMapRsp> {
    private int CHANNEL_SLOT_SUM = 496;
    private int HAS_USED = 1;
    private HashMap<String, String> interfaceFdnMap = new HashMap();
    private Logger logger = LoggerFactory.getLogger(QQueryCesFreeBoardMapTask.class);
    private int NOT_USED = 0;
    private int PORT_LEVEL_VC3 = 12;
    private int PROT_LEVEL_E1 = 1;
    private int PROT_LEVEL_T1 = 3;
    private int PROT_LEVEL_VC4 = 11;

    QQueryCesFreeBoardMapTask() {
    }

    public QAsnUniResID getUniResID(Integer iDevID, QAsnCesPortMap asnCesPort) {
        String fdn = "";
        if (this.interfaceFdnMap.containsKey(StringUtil.globalString((byte[])asnCesPort.portName))) {
            fdn = this.interfaceFdnMap.get(StringUtil.globalString((byte[])asnCesPort.portName));
        }
        QAsnUniResID asn = new QAsnUniResID();
        asn.strFDN = StringUtil.globalByte((String)fdn);
        asn.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)fdn));
        asn.neID = iDevID;
        return asn;
    }

    protected void handleErrorResult(VMFException e, QAsnGetCesFreeBoardMapRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnGetCesFreeBoardMapRsp rsp) {
        this.initRspResult(rsp.result);
    }

    protected Collection<ChannelSet> queryChannelSetMoInfos(List<ChannelSet> moIndexes) throws VMFException {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = moIndexes.iterator().next().getClass();
        return dao.queryByKey(clazz, moIndexes, false);
    }

    protected Collection<?> queryMoInfo(QAsnGetCesFreeBoardMapReq req, QAsnGetCesFreeBoardMapRsp rsp, Task task) throws VMFException {
        int neID = req.neID;
        this.interfaceFdnMap.clear();
        HashMap<Integer, HashMap<String, Integer>> mapSlotPort = new HashMap<Integer, HashMap<String, Integer>>();
        this.queryCesPort(neID, mapSlotPort);
        QAsnCesBoardMapList cesBoardLst = new QAsnCesBoardMapList();
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            Object stmPortTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQQueryCesFreeBoardMapTaskExtPoint.class);
            if (null != stmPortTranslatorExtPoint) {
                ((IQQueryCesFreeBoardMapTaskExtPoint)stmPortTranslatorExtPoint).makeBoardMapList(neID, mapSlotPort, cesBoardLst);
            }
        } else {
            HashMap<String, HashMap<Integer, String>> mapPortChannel = new HashMap<String, HashMap<Integer, String>>();
            this.queryPortChannel(neID, mapPortChannel);
            this.assembleCesPort(neID, mapSlotPort, mapPortChannel, cesBoardLst);
        }
        return cesBoardLst;
    }

    protected Collection<Port> queryMoInfos(List<Port> moIndexes) throws VMFException {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = moIndexes.iterator().next().getClass();
        return dao.queryByKey(clazz, moIndexes, false);
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnGetCesFreeBoardMapRsp rsp) {
        rsp.isBoard = 0;
        rsp.freeBoardList.addAll(queryAsns);
        QAsnErrInfoReturn singleReturn = new QAsnErrInfoReturn();
        singleReturn.result = 0;
        singleReturn.errList = new QAsnErrInfoList();
        rsp.result = singleReturn;
    }

    private void assembleCesPort(int iDevID, HashMap<Integer, HashMap<String, Integer>> mapPortID, HashMap<String, HashMap<Integer, String>> mapPortChannel, QAsnCesBoardMapList cesBoardLst) {
        if (null == mapPortID || mapPortID.isEmpty()) {
            return;
        }
        HashMap<String, Integer> mapCpos2Vc4 = new HashMap<String, Integer>();
        Integer itMapPort = null;
        HashMap<String, Integer> itPortNum = null;
        for (Map.Entry<Integer, HashMap<String, Integer>> entry : mapPortID.entrySet()) {
            itMapPort = entry.getKey();
            itPortNum = entry.getValue();
            QAsnCesBoardMap asnCesBoardMap = new QAsnCesBoardMap();
            cesBoardLst.add((Object)asnCesBoardMap);
            asnCesBoardMap.neID = iDevID;
            asnCesBoardMap.slotID = itMapPort;
            asnCesBoardMap.boardTypeName = "".getBytes();
            for (Map.Entry<String, Integer> entryPort : itPortNum.entrySet()) {
                String portName = entryPort.getKey();
                Integer portNum = entryPort.getValue();
                QAsnCesPortMap asnCesPort = new QAsnCesPortMap();
                asnCesBoardMap.portList.add((Object)asnCesPort);
                asnCesPort.portID = portNum;
                asnCesPort.portName = StringUtil.globalByte((String)portName);
                asnCesPort.portIndex = this.getUniResID(iDevID, asnCesPort);
                asnCesPort.portLevel = this.getPortLevel(portName, mapCpos2Vc4);
                if (this.PORT_LEVEL_VC3 == asnCesPort.portLevel) {
                    asnCesPort.isUsed = this.NOT_USED;
                    asnCesPort.isChannelized = 1;
                    asnCesPort.tuOrLU = this.NOT_USED;
                    this.dealCposData(portName, mapPortChannel, asnCesPort);
                    continue;
                }
                if (this.PROT_LEVEL_VC4 == asnCesPort.portLevel) {
                    asnCesPort.isUsed = this.NOT_USED;
                    asnCesPort.tuOrLU = 0;
                    if (mapCpos2Vc4.containsKey(portName) && 1 == mapCpos2Vc4.get(portName)) {
                        asnCesPort.isUsed = this.HAS_USED;
                        continue;
                    }
                    QAsnCesHighChannel asnHigChannel = new QAsnCesHighChannel();
                    asnCesPort.channelList.add((Object)asnHigChannel);
                    asnHigChannel.highChannelID = 1;
                    asnHigChannel.isUsed = this.NOT_USED;
                    continue;
                }
                asnCesPort.isChannelized = 0;
                asnCesPort.tuOrLU = 1;
                this.dealDs1Data(portName, mapPortChannel, asnCesPort);
            }
        }
    }

    private int calculateSloLst(int iSumSlotLst, int iFisrtValue, int iEndValue) {
        if (iFisrtValue > iEndValue) {
            return iSumSlotLst;
        }
        for (int iValue = iFisrtValue; iValue < iEndValue && iValue < Integer.MAX_VALUE; ++iValue) {
            iSumSlotLst += iValue;
        }
        return iSumSlotLst;
    }

    private Boolean completeUsedSlotLst(String strSlotLst) {
        String strTmpLst = strSlotLst;
        if (null == strSlotLst || strSlotLst.isEmpty()) {
            return false;
        }
        int iSumSlotLst = 0;
        while (true) {
            int iLinePos = 0;
            int iDotPos = 0;
            int iFisrtValue = 0;
            int iEndValue = 0;
            if (strTmpLst.indexOf("-") < 0 && strTmpLst.indexOf(",") < 0) break;
            iLinePos = strTmpLst.indexOf("-");
            if (iLinePos >= 0) {
                iFisrtValue += StringUtil.getInteger((String)strTmpLst.substring(0, iLinePos)).intValue();
                strTmpLst = strTmpLst.substring(iLinePos + 1);
            }
            if ((iDotPos = strTmpLst.indexOf(",")) >= 0) {
                iEndValue = StringUtil.getInteger((String)strTmpLst.substring(0, iDotPos));
                strTmpLst = strTmpLst.substring(iDotPos + 1);
            } else {
                iEndValue = StringUtil.getInteger((String)strTmpLst);
            }
            if (iLinePos >= 0) {
                iSumSlotLst = this.calculateSloLst(iSumSlotLst, iFisrtValue, iEndValue);
                continue;
            }
            iSumSlotLst += iEndValue;
        }
        if (this.CHANNEL_SLOT_SUM == (iSumSlotLst += StringUtil.getInteger((String)strTmpLst).intValue())) {
            return true;
        }
        return false;
    }

    private void dealCposData(String strIfName, HashMap<String, HashMap<Integer, String>> mapPortChannel, QAsnCesPortMap asnCesPortMap) {
        QAsnCesHighChannel asnHigChannel = new QAsnCesHighChannel();
        asnCesPortMap.channelList.add((Object)asnHigChannel);
        asnHigChannel.highChannelID = 1;
        asnHigChannel.isUsed = 1;
        if (null == mapPortChannel) {
            return;
        }
        HashMap<Integer, String> itChannel = null;
        if (mapPortChannel.containsKey(strIfName)) {
            itChannel = mapPortChannel.get(strIfName);
            for (int iChannel = 1; iChannel <= 63; ++iChannel) {
                QAsnCesLowChannel asnLowChannel = new QAsnCesLowChannel();
                asnHigChannel.lowChannelList.add((Object)asnLowChannel);
                asnLowChannel.lowChannelID = iChannel;
                if (itChannel.containsKey(iChannel)) {
                    if (this.completeUsedSlotLst(itChannel.get(iChannel)).booleanValue()) {
                        asnLowChannel.isUsed = this.HAS_USED;
                        continue;
                    }
                    asnLowChannel.isUsed = this.NOT_USED;
                    continue;
                }
                asnLowChannel.isUsed = this.NOT_USED;
            }
        } else {
            int iChannel = 1;
            while (iChannel <= 63) {
                QAsnCesLowChannel asnLowChannel = new QAsnCesLowChannel();
                asnHigChannel.lowChannelList.add((Object)asnLowChannel);
                asnLowChannel.lowChannelID = iChannel++;
                asnLowChannel.isUsed = this.NOT_USED;
            }
        }
    }

    private void dealDs1Data(String strIfName, HashMap<String, HashMap<Integer, String>> mapPortChannel, QAsnCesPortMap asnCesPortMap) {
        HashMap<Integer, String> itChannel = null;
        if (mapPortChannel.containsKey(strIfName)) {
            itChannel = mapPortChannel.get(strIfName);
            if (itChannel.size() > 0) {
                asnCesPortMap.isUsed = this.completeUsedSlotLst(itChannel.entrySet().iterator().next().getValue()).booleanValue() ? this.HAS_USED : this.NOT_USED;
            }
        } else {
            asnCesPortMap.isUsed = this.NOT_USED;
        }
    }

    private int getPortLevel(String strIfName, HashMap<String, Integer> mapCpos2Vc4) {
        if (null != strIfName && strIfName.indexOf("Cpos") >= 0) {
            if (mapCpos2Vc4.containsKey(strIfName)) {
                return this.PROT_LEVEL_VC4;
            }
            return this.PORT_LEVEL_VC3;
        }
        if (null != strIfName && strIfName.indexOf("T1") >= 0) {
            return this.PROT_LEVEL_T1;
        }
        this.logger.debug("getPortLevel do noting.");
        return this.PROT_LEVEL_E1;
    }

    private void makeData(String ifName, int setNum, String strTimeslotList, HashMap<String, HashMap<Integer, String>> mapPortChannel) {
        if (mapPortChannel.containsKey(ifName)) {
            HashMap<Integer, String> data = mapPortChannel.get(ifName);
            if (data.containsKey(setNum)) {
                String timeslot = data.get(setNum);
                timeslot = timeslot + "," + strTimeslotList;
                data.remove(setNum);
                data.put(setNum, timeslot);
            } else {
                data.put(setNum, strTimeslotList);
            }
            mapPortChannel.put(ifName, data);
        } else if (-1 != setNum) {
            HashMap<Integer, String> data = new HashMap<Integer, String>();
            data.put(setNum, strTimeslotList);
            mapPortChannel.put(ifName, data);
        }
    }

    private void queryCesPort(int iDevID, HashMap<Integer, HashMap<String, Integer>> mapSlotPort) throws VMFException {
        ArrayList<Port> moIndexs = new ArrayList<Port>();
        this.queryCesPortTypeIndex(iDevID, moIndexs);
        Collection<Port> mos = this.queryInterfaceInfoByPortType(moIndexs);
        if (null != mos) {
            for (Port mo : mos) {
                if (mapSlotPort.containsKey(mo.getSlotID())) {
                    mapSlotPort.get(mo.getSlotID()).put(mo.getName(), mo.getParentRelPosition());
                    continue;
                }
                HashMap<String, Integer> portData = new HashMap<String, Integer>();
                portData.put(mo.getName(), mo.getParentRelPosition());
                mapSlotPort.put(mo.getSlotID(), portData);
            }
        }
    }

    private void queryCesPortTypeIndex(int iDevID, List<Port> moIndexs) throws VMFException {
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            Port portCpos = new Port();
            portCpos.setDevID(Integer.valueOf(iDevID));
            portCpos.setPortType(Integer.valueOf(2049));
            moIndexs.add(portCpos);
        } else {
            Port portE1T1 = new Port();
            portE1T1.setDevID(Integer.valueOf(iDevID));
            portE1T1.setPortType(Integer.valueOf(128));
            moIndexs.add(portE1T1);
            Port portCpos = new Port();
            portCpos.setDevID(Integer.valueOf(iDevID));
            portCpos.setPortType(Integer.valueOf(2049));
            moIndexs.add(portCpos);
        }
    }

    private Collection<Port> queryInterfaceInfoByPortType(List<Port> indexMO) {
        Collection resIfms = null;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = indexMO.iterator().next().getClass();
        String[] fieldNames = new String[]{"devID", "portType"};
        try {
            resIfms = dao.queryByFields(clazz, fieldNames, indexMO, true);
            return resIfms;
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoByPortType In QQueryCesFreeBoardMapTask is fail: " + (Object)((Object)e));
            return resIfms;
        }
    }

    private void queryPortChannel(int iDevID, HashMap<String, HashMap<Integer, String>> mapPortChannel) throws VMFException {
        ArrayList<Integer> neIDs = new ArrayList<Integer>();
        neIDs.add(iDevID);
        HashSet<Integer> includePhyType = new HashSet<Integer>();
        includePhyType.add(128);
        includePhyType.add(2049);
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Collection<Interface> interfaces = dao.queryPortDetailByNeID(neIDs, includePhyType, null, 0);
        ArrayList<ChannelSet> moIndexs = new ArrayList<ChannelSet>();
        ChannelSet queryChannelSet = new ChannelSet();
        queryChannelSet.setDevID(Integer.valueOf(iDevID));
        moIndexs.add(queryChannelSet);
        Collection<ChannelSet> mos = this.queryChannelSetMoInfos(moIndexs);
        if (null != interfaces) {
            for (Interface inf : interfaces) {
                this.interfaceFdnMap.put(inf.getIfName(), inf.getFdn());
                if (null == mos) continue;
                for (ChannelSet mo : mos) {
                    if (inf.getDevID() != mo.getDevID() || inf.getVrID() != mo.getVrID() || null == inf.getIfPosition() || !inf.getIfPosition().equals(mo.getPosition())) continue;
                    String ifName = inf.getIfName();
                    int setNum = mo.getSetNumber().intValue();
                    String strTimeslotList = mo.getTimeslotList();
                    this.makeData(ifName, setNum, strTimeslotList, mapPortChannel);
                }
            }
        }
    }
}

