/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnGetIfPrimaryIPLstByDevIDReq;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnGetIfPrimaryIPLstByDevIDRsp;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnResIfIP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QGetIfPrimaryIPLstByDevIDTask
extends AbstractQTask<QAsnGetIfPrimaryIPLstByDevIDReq, QAsnGetIfPrimaryIPLstByDevIDRsp> {
    public QGetIfPrimaryIPLstByDevIDTask(QAsnGetIfPrimaryIPLstByDevIDReq req, QAsnGetIfPrimaryIPLstByDevIDRsp resp) {
    }

    protected void encodeRsp(Interface inf, int ret, QAsnGetIfPrimaryIPLstByDevIDRsp rsp) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)inf.getIpv4Addresss())) {
            return;
        }
        QAsnResIfIP ifIPAsn = new QAsnResIfIP();
        ifIPAsn.iDevID = inf.getDevID();
        ifIPAsn.iResID = BigInteger.valueOf(inf.getIfIndex());
        for (Ipv4Address ipv4 : inf.getIpv4Addresss()) {
            ifIPAsn.iIPAddrType = BigInteger.valueOf(ipv4.getAddrType().intValue());
            ifIPAsn.iIsPrimary = ipv4.getAddrType() == 1 ? BigInteger.ONE : BigInteger.ZERO;
            ifIPAsn.strIPAddr = AsnUtil.getBytes((String)ipv4.getIpAddr());
            ifIPAsn.strNetAddr = AsnUtil.getBytes((String)ipv4.getNetAddr());
            ifIPAsn.strSubnetMask = AsnUtil.getBytes((String)ipv4.getSubnetMask());
        }
        rsp.lstIfIP.add((Object)ifIPAsn);
    }

    protected void executeTask(QAsnGetIfPrimaryIPLstByDevIDReq req, QAsnGetIfPrimaryIPLstByDevIDRsp rsp, Task task) {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection interfaces = dao.queryByNeID(Interface.class, Arrays.asList(req.iDevID), true);
            for (Interface ipAddress : interfaces) {
                this.encodeRsp(ipAddress, 0, rsp);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnGetIfPrimaryIPLstByDevIDReq exception.", (Throwable)e);
        }
    }
}

