/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnGetIfLstByDevIDAndAbstractTypeReq;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnGetIfLstByDevIDAndAbstractTypeRsp;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnQueryResIf;
import com.huawei.network.qasn.m_q_ip_resquery.QAsnResIfIP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.lrvr.model.VirtualRouter;
import com.huawei.vmf.adapter.fservice.lrvr.service.IVirtualRouterService;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.osgi.framework.ServiceReference;

public class QGetIfLstByDevIDAndAbstractTypeTask
extends AbstractQTask<QAsnGetIfLstByDevIDAndAbstractTypeReq, QAsnGetIfLstByDevIDAndAbstractTypeRsp> {
    private static final int TUNNEL_IF_QASN_TYPE = 14;

    public QGetIfLstByDevIDAndAbstractTypeTask(QAsnGetIfLstByDevIDAndAbstractTypeReq req, QAsnGetIfLstByDevIDAndAbstractTypeRsp rsp) {
    }

    protected void encode(Interface mo, int ret, QAsnGetIfLstByDevIDAndAbstractTypeRsp rsp, Map<Interface, VirtualRouter> vrMap) throws VMFException {
        VirtualRouter vr;
        QAsnQueryResIf resIfAsn = new QAsnQueryResIf();
        resIfAsn.iAbstractTypeID = null == mo.getiQIfType() ? BigInteger.ZERO : BigInteger.valueOf(mo.getiQIfType().intValue());
        resIfAsn.iIfAdminStatus = BigInteger.valueOf(AsnUtil.intValue((Integer)mo.getIfAdminStatus()));
        resIfAsn.iResID = BigInteger.valueOf(AsnUtil.intValue((Long)mo.getIfIndex()));
        resIfAsn.iDevID = mo.getDevID();
        resIfAsn.iTunnelID = BigInteger.ZERO;
        resIfAsn.iIfIndex = BigInteger.valueOf(AsnUtil.intValue((Long)mo.getIfIndex()));
        resIfAsn.iIfLayer = BigInteger.ZERO;
        resIfAsn.iIfMtu = BigInteger.valueOf(mo.getIfMtu().intValue());
        resIfAsn.iIfOperStatus = null == mo.getIfOperStatus() ? BigInteger.ZERO : BigInteger.valueOf(mo.getIfOperStatus().intValue());
        resIfAsn.iIfType = BigInteger.valueOf(mo.getiQIfType().intValue());
        resIfAsn.strIfPhysAddress = "".getBytes();
        resIfAsn.iMainType = null == mo.getIfParentIfName() ? BigInteger.ONE : BigInteger.ZERO;
        resIfAsn.strIfAlias = "".getBytes();
        resIfAsn.strIfDescr = mo.getIfDescr() == null ? "".getBytes() : mo.getIfName().getBytes();
        resIfAsn.strIfName = mo.getIfName().getBytes();
        resIfAsn.strIfSpeed = mo.getIfOperSpeed() == null ? "".getBytes() : String.valueOf(mo.getIfOperSpeed()).getBytes();
        Collection ipAddresss = mo.getIpv4Addresss();
        if (null != ipAddresss) {
            for (Ipv4Address ipAddress : ipAddresss) {
                QAsnResIfIP ifIPAsn = new QAsnResIfIP();
                ifIPAsn.iDevID = ipAddress.getDevID();
                ifIPAsn.iIPAddrType = BigInteger.valueOf(ipAddress.getAddrType().intValue());
                ifIPAsn.iIsPrimary = ipAddress.getAddrType() == 1 ? BigInteger.ONE : BigInteger.ZERO;
                ifIPAsn.iResID = BigInteger.valueOf(mo.getIfIndex());
                ifIPAsn.strIPAddr = ipAddress.getIpAddr().getBytes();
                ifIPAsn.strNetAddr = ipAddress.getNetAddr().getBytes();
                ifIPAsn.strSubnetMask = ipAddress.getSubnetMask().getBytes();
                resIfAsn.lstIfIP.add((Object)ifIPAsn);
            }
        }
        VirtualRouter virtualRouter = vr = null == vrMap ? null : vrMap.get(mo);
        if (vr != null) {
            resIfAsn.poiVrID = BigInteger.valueOf(vr.getVrID().intValue());
            resIfAsn.postrVrName = vr.getVrName() == null ? null : vr.getVrName().getBytes();
        }
        resIfAsn.iTunnelID = BigInteger.ZERO;
        rsp.lstResIf.add((Object)resIfAsn);
    }

    protected void executeTask(QAsnGetIfLstByDevIDAndAbstractTypeReq req, QAsnGetIfLstByDevIDAndAbstractTypeRsp rsp, Task task) {
        String ifName;
        this.getLogger().info("QGetIfLstByDevIDAndAbstractTypeTask.query begin.");
        ArrayList<Integer> neIDs = null;
        if (null != req.strIfName && req.strIfName.length > 0) {
            ifName = new String(req.strIfName);
            if (ifName.startsWith("*")) {
                ifName = ifName.substring(1, ifName.length() - 1);
            }
        } else {
            ifName = null;
        }
        neIDs = new ArrayList<Integer>();
        neIDs.add(req.iDevID);
        HashSet<Integer> includePhyType = new HashSet<Integer>();
        if (null != req.lstIfType && !req.lstIfType.isEmpty()) {
            for (Object ifTypeAsn : req.lstIfType) {
                BigInteger ifType = (BigInteger)ifTypeAsn;
                Integer iQIfType = this.changeToAbstract(ifType.intValue());
                includePhyType.add(iQIfType);
                if (1025 != iQIfType && 65539 != iQIfType || includePhyType.contains(65559)) continue;
                includePhyType.add(65559);
            }
        }
        try {
            Collection<Interface> interfaces = null;
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            interfaces = dao.queryPortDetailByNeID(neIDs, includePhyType, null, 0);
            ServiceReference vrServiceRef = Activator.getContext().getServiceReference(IVirtualRouterService.class.getName());
            IVirtualRouterService virtualRouterService = (IVirtualRouterService)Activator.getContext().getService(vrServiceRef);
            Map vrMap = virtualRouterService.getVrNameByVrID(interfaces);
            if (ifName != null) {
                for (Interface inf : interfaces) {
                    if (!inf.getIfName().contains(ifName)) continue;
                    this.encode(inf, 0, rsp, vrMap);
                }
            } else {
                for (Interface inf : interfaces) {
                    this.encode(inf, 0, rsp, vrMap);
                }
            }
            this.getLogger().info("QGetIfLstByDevIDAndAbstractTypeTask.query end:{}", (Object)rsp);
        }
        catch (VMFException e) {
            this.getLogger().error("QGetIfLstByDevIDAndAbstractTypeTask.query error.", (Throwable)e);
        }
    }

    private Integer changeToAbstract(Integer includePhyType) {
        Integer AbstractPhyType = 1;
        switch (includePhyType) {
            case 1: {
                AbstractPhyType = 1;
                break;
            }
            case 2: {
                AbstractPhyType = 1025;
                break;
            }
            case 3: {
                AbstractPhyType = 1025;
                break;
            }
            case 4: {
                AbstractPhyType = 65539;
                break;
            }
            case 5: {
                AbstractPhyType = 65549;
                break;
            }
            case 7: {
                AbstractPhyType = 1281;
                break;
            }
            case 8: {
                AbstractPhyType = 2049;
                break;
            }
            case 9: {
                AbstractPhyType = 65543;
                break;
            }
            case 10: {
                AbstractPhyType = 65544;
                break;
            }
            case 11: {
                AbstractPhyType = 128;
                break;
            }
            case 12: {
                AbstractPhyType = 128;
                break;
            }
            case 13: {
                AbstractPhyType = 2049;
                break;
            }
            case 14: {
                AbstractPhyType = 65547;
                break;
            }
            case 15: {
                AbstractPhyType = 65562;
                break;
            }
            case 16: {
                AbstractPhyType = 65540;
                break;
            }
            case 18: {
                AbstractPhyType = 65546;
                break;
            }
            case 20: {
                AbstractPhyType = 65541;
                break;
            }
            case 21: {
                AbstractPhyType = 65537;
                break;
            }
            case 30: {
                AbstractPhyType = 65546;
                break;
            }
            case 32: {
                AbstractPhyType = 65563;
                break;
            }
            case 33: {
                AbstractPhyType = 65569;
                break;
            }
            case 34: {
                AbstractPhyType = 65564;
                break;
            }
            case 37: {
                AbstractPhyType = 65543;
                break;
            }
            case 38: {
                AbstractPhyType = 65565;
                break;
            }
            case 39: {
                AbstractPhyType = 65568;
                break;
            }
            case 41: {
                AbstractPhyType = 41;
                break;
            }
        }
        return AbstractPhyType;
    }
}

