/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAPList;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnCreateCTPInfoReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnCreateCTPInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.ifm.translation.asn.QAsnTranslator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class QAsnSetIfStatusTask
extends AbstractConfigQTask<QAsnCreateCTPInfoReq, QAsnCreateCTPInfoRsp> {
    private final boolean bOperFlag;
    private final InterfaceFdnParser parser = new InterfaceFdnParser();
    private final QAsnTranslator trans = new QAsnTranslator();

    public QAsnSetIfStatusTask(boolean enable) {
        super(EOperationType.MODIFY);
        super.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
        this.bOperFlag = enable;
    }

    protected void decode(QAsnCreateCTPInfoReq req, Task task, IAsnTranslationContext context) {
        QAsnUniResIDList resids = new QAsnUniResIDList();
        Iterator iter = req.olstCtpInfo.iterator();
        while (iter.hasNext()) {
            resids.add((Object)((QAsnSAP)iter.next()).ctpKey);
        }
        List mos = this.parser.getIndexMos((Collection)resids);
        if (CollectionUtils.isEmpty((Collection)mos)) {
            return;
        }
        Integer ifAdminStatus = -1;
        ifAdminStatus = this.bOperFlag ? Integer.valueOf(1) : Integer.valueOf(0);
        for (Interface mo : mos) {
            mo.setIfAdminStatus(ifAdminStatus);
            this.setOperMask(mo, "ifAdminStatus", context);
        }
    }

    protected void encode(QAsnCreateCTPInfoRsp rsp, IAsnTranslationContext context) {
        rsp.polstSucCtp = new QAsnSAPList();
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Interface.class);
        Set mos = recorder.getAllChanges();
        for (Interface mo : mos) {
            QAsnSAP asn = new QAsnSAP();
            try {
                this.trans.encode(mo, asn, context);
            }
            catch (VMFException e) {
                this.getLogger().error("encode rsp error!", (Object)e.toString());
            }
            if (null == asn) continue;
            rsp.polstSucCtp.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateCTPInfoReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateCTPInfoReq req) {
        return null;
    }

    private void setOperMask(Interface mo, String ifAdminStatus, IAsnTranslationContext context) {
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Interface.class);
        recorder.addModify((Object)mo, new PropertyChangeItem(ifAdminStatus, null, null));
    }
}

