/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_interface_op.QAsnSetIfStatisticReq;
import com.huawei.network.qasn.m_q_interface_op.QAsnSetIfStatisticRsp;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class QAsnSetIfStatisticTask
extends AbstractConfigQTask<QAsnSetIfStatisticReq, QAsnSetIfStatisticRsp> {
    private final InterfaceFdnParser parser = new InterfaceFdnParser();

    public QAsnSetIfStatisticTask() {
        super(EOperationType.MODIFY);
        super.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnSetIfStatisticReq req, Task task, IAsnTranslationContext context) {
        List mos = this.parser.getIndexMos((Collection)req.ifIndexList);
        if (CollectionUtils.isEmpty((Collection)mos)) {
            return;
        }
        for (Interface mo : mos) {
            mo.setIfStatiEnable(Integer.valueOf(req.iStatisticEnable));
            mo.setIfStatItvl(Integer.valueOf(req.iIntervalTime));
            this.setOperMask(mo, "ifStatiEnable", context);
            this.setOperMask(mo, "ifStatItvl", context);
        }
    }

    protected void encode(QAsnSetIfStatisticRsp rsp, IAsnTranslationContext context) {
        rsp.iErrorCode = !context.getTransactionContext().getOperResult().hasFailed() ? 0 : 1107499878;
        rsp.ifIndexList = new QAsnUniResIDList();
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Interface.class);
        Set mos = recorder.getAllChanges();
        String strMoc = "";
        for (Interface mo : mos) {
            String strFdnIfName;
            QAsnUniResID asn = new QAsnUniResID();
            asn.neID = mo.getDevID();
            strMoc = "";
            String string = strFdnIfName = mo.getIfName().indexOf(".") > 0 ? mo.getIfName().substring(0, mo.getIfName().indexOf(".")) : mo.getIfName();
            if (null != mo.getFdn() && mo.getFdn().indexOf(",") > 0) {
                strMoc = this.getFdn(mo, strFdnIfName);
            }
            asn.strMOC = AsnUtil.getBytes((String)strMoc);
            asn.strFDN = AsnUtil.getBytes((String)mo.getFdn());
            rsp.ifIndexList.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnSetIfStatisticReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnSetIfStatisticReq req) {
        return null;
    }

    private String getFdn(Interface mo, String strFdnIfName) {
        String strMoc = "";
        String[] strFdns = mo.getFdn().split(",");
        if (null != strFdns && strFdns.length > 0) {
            for (String fdn : strFdns) {
                if (null == fdn || fdn.indexOf(strFdnIfName) <= 0) continue;
                strMoc = fdn.substring(0, fdn.indexOf("="));
                break;
            }
        }
        return strMoc;
    }

    private void setOperMask(Interface mo, String ifAdminStatus, IAsnTranslationContext context) {
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Interface.class);
        recorder.addModify((Object)mo, new PropertyChangeItem(ifAdminStatus, null, null));
    }
}

