/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.network.qasn.m_q_interface_op.QAsnQueryVlanAggIfReq;
import com.huawei.network.qasn.m_q_interface_op.QAsnQueryVlanAggIfRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortDetailInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnQueryVlanAggIfTask
extends DefaultQueryByFDNTask<QAsnQueryVlanAggIfReq, QAsnQueryVlanAggIfRsp, Interface> {
    private QAsnQueryVlanAggIfReq req = null;

    public QAsnQueryVlanAggIfTask(QAsnQueryVlanAggIfReq req, QAsnQueryVlanAggIfRsp rsp) {
        super((Collection)req.lstPort, (IFdnParser)new InterfaceFdnParser(), null, (IAsnTranslator)new QAsnPortDetailInfoTranslator(), (Collection)rsp.lstPort, (FStruct)rsp.result, true, true);
        this.setDao(DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class));
        this.req = req;
    }

    protected Collection<Interface> queryFromDB() throws VMFException {
        return this.queryPortInfoFromDB(this.getFilterMos());
    }

    private Collection<Interface> queryPortInfoFromDB(Collection<Interface> indexes) {
        Collection<Object> interfaces = new ArrayList<Interface>();
        if (null == this.req.lstPort || CollectionUtils.isEmpty(indexes)) {
            return interfaces;
        }
        ArrayList<Interface> subIfIndexs = new ArrayList<Interface>();
        HashMap<String, Interface> ifmLst = new HashMap<String, Interface>();
        for (Interface ifm : indexes) {
            Interface subIf = new Interface();
            subIf.setDevID(ifm.getDevID());
            subIf.setVrID(ifm.getVrID());
            subIf.setIfParentIfName(ifm.getIfName());
            subIf.setiQIfType(Integer.valueOf(65570));
            subIfIndexs.add(subIf);
            ifmLst.put(ifm.getDevID() + "_" + ifm.getIfName(), ifm);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "ifParentIfName", "iQIfType"};
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            interfaces = dao.queryByFields(Interface.class, fieldNames, subIfIndexs, true);
            if (!CollectionUtils.isEmpty(interfaces)) {
                ArrayList<EthSubIf> ethSubIndexs = new ArrayList<EthSubIf>();
                for (Interface interface_ : interfaces) {
                    Interface pareIfm = (Interface)ifmLst.get(interface_.getDevID() + "_" + interface_.getIfParentIfName());
                    if (null != pareIfm) {
                        interface_.addKeyRefMo((VmfMO)pareIfm);
                    }
                    EthSubIf sub = new EthSubIf();
                    sub.setDevID(interface_.getDevID());
                    sub.setVrID(interface_.getVrID());
                    sub.setIfName(interface_.getIfName());
                    ethSubIndexs.add(sub);
                }
                Collection ethSubRes = dao.queryByKey(EthSubIf.class, ethSubIndexs, false);
                if (!CollectionUtils.isEmpty((Collection)ethSubRes)) {
                    for (EthSubIf subMo : ethSubRes) {
                        for (Interface interface_ : interfaces) {
                            if (!interface_.getDevID().equals(subMo.getDevID()) || !interface_.getIfName().equals(subMo.getIfName())) continue;
                            interface_.addKeyRefMo((VmfMO)subMo);
                        }
                    }
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnQueryVlanAggIfTask queryPortInfoFromDB error.", (Throwable)e);
        }
        return interfaces;
    }
}

