/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnModifyCTPInfoReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnModifyCTPInfoRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.translation.asn.QAsnTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnModifyCTPInfoTask
extends AbstractConfigQTask<QAsnModifyCTPInfoReq, QAsnModifyCTPInfoRsp> {
    private IAsnTranslator<QAsnSAP, Interface> tanslator = new QAsnTranslator();

    public QAsnModifyCTPInfoTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnModifyCTPInfoReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        try {
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            for (Object object : req.olstCtpInfo) {
                QAsnSAP sap = (QAsnSAP)object;
                Interface ifn = (Interface)this.tanslator.decode((FStruct)sap, asnTranslatorContext);
                if (null == ifn) continue;
                interfaces.add(ifn);
            }
            if (CollectionUtils.isEmpty(interfaces)) {
                return;
            }
            IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
            interfaceService.processSAP(interfaces, (Object)asnTranslatorContext);
            Context context = asnTranslatorContext.getTransactionContext();
            Map allChanges = context.getAllChanges();
            for (Map.Entry entry : allChanges.entrySet()) {
                IMOChangeRecord changeRecord = (IMOChangeRecord)entry.getValue();
                Set creates = changeRecord.getCreates();
                Set modifies = changeRecord.getModifies();
                if (CollectionUtils.isEmpty((Collection)modifies)) continue;
                for (Object modifMo : modifies) {
                    if (!creates.contains(modifMo)) continue;
                    changeRecord.cancelModify(modifMo);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq decode failed.", (Throwable)e);
        }
    }

    protected void encode(QAsnModifyCTPInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        try {
            Context context = asnTranslatorContext.getTransactionContext();
            OperResult operResult = context.getOperResult();
            Set interfaces = context.getChangeRecord(Interface.class).getAllChanges();
            QAsnUniResIDList failedCtps = new QAsnUniResIDList();
            for (Interface inf : interfaces) {
                QAsnErrInfoReturn oResult;
                QAsnSAP sap = (QAsnSAP)this.tanslator.encode((Object)inf, asnTranslatorContext);
                ErrorInfo errorInfo = AsnTranslatorUtil.getMoWithRefOperResult((VmfMO)inf, (OperResult)operResult);
                if (!AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    failedCtps.add((Object)sap.ctpKey);
                }
                rsp.polstFailedCtp = failedCtps;
                rsp.result = oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)operResult);
                if (0 != oResult.result) continue;
                IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
                interfaceService.reloadTerminationData((Object)asnTranslatorContext);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq encode failed.", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnModifyCTPInfoReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyCTPInfoReq req) {
        return req.poTaskFlg;
    }
}

