/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnGetTPNameReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnGetTPNameRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnTPNameTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QAsnGetTPNameTask
extends DefaultQueryByFDNTask<QAsnGetTPNameReq, QAsnGetTPNameRsp, Interface> {
    private Logger logger = LoggerFactory.getLogger(QAsnGetTPNameTask.class);
    private Set<Integer> devIDLst = new HashSet<Integer>();

    public QAsnGetTPNameTask(QAsnGetTPNameReq req, QAsnGetTPNameRsp rsp) {
        super((Collection)req.lstTPKey, (IFdnParser)new InterfaceFdnParser(), null, (IAsnTranslator)new QAsnTPNameTranslator(), (Collection)rsp.lstTPNameParir, (FStruct)rsp.result, true, true);
        this.setDao(DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class));
    }

    protected List<Interface> decodeFdns(Collection<QAsnUniResID> fdns) {
        HashSet<Integer> devIDs = new HashSet<Integer>();
        for (QAsnUniResID uniResID : fdns) {
            devIDs.add(uniResID.neID);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Map<String, Interface> fdnToInfMap = dao.queryFdnToInfMap(new ArrayList<Integer>(devIDs));
        InterfaceFdnParser fdnPaser = new InterfaceFdnParser();
        ArrayList<Interface> filterMos = new ArrayList<Interface>();
        for (QAsnUniResID asn : fdns) {
            Interface mo = (Interface)this.convertFilterMoFromFdnMo((VmfMO)fdnPaser.getIndexMo(StringUtil.globalString((byte[])asn.strFDN), fdnToInfMap));
            if (null == mo) continue;
            filterMos.add(mo);
        }
        return filterMos;
    }

    protected void encodeRspQueryDatas(QAsnGetTPNameReq req, QAsnGetTPNameRsp rsp, Collection<Interface> mos) throws VMFException {
        super.encodeRspQueryDatas((FStruct)req, (FStruct)rsp, mos);
    }

    protected Collection<Interface> queryFromDB() throws VMFException {
        return this.queryPortInfoFromDB(this.getFilterMos());
    }

    private Collection<Interface> packPTNName(Collection<Interface> ifms) {
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        if (null != interfaceUtilExtPoint && !CollectionUtils.isEmpty(ifms)) {
            Map<String, String> boardlist = this.getBoardInfoList();
            for (Interface ifm : ifms) {
                ((IInterfaceUtilExtPoint)interfaceUtilExtPoint).packInterfaceNameForPTNAndBoard(ifm, boardlist);
            }
        }
        return ifms;
    }

    private Map<String, String> getBoardInfoList() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(this.devIDLst)) {
            return map;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection boardLst = dao.queryByNeID(Board.class, this.devIDLst, false);
            if (!CollectionUtils.isEmpty((Collection)boardLst)) {
                for (Board board : boardLst) {
                    map.put(board.getDevID() + "_" + board.getChassisID() + "_" + board.getSlotID(), board.getVendorType());
                }
                return map;
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnGetTPNameTask getBoardInfoList fail!" + (Object)((Object)e));
        }
        return map;
    }

    private Collection<Interface> queryPortInfoFromDB(Collection<Interface> indexes) {
        Collection<Interface> interfaces = new ArrayList<Interface>();
        try {
            if (CollectionUtils.isEmpty(indexes)) {
                return interfaces;
            }
            this.getLogger().info("QAsnGetTPNameTask queryPortInfoFromDB PTN ifm req is" + indexes.size());
            for (Interface index : indexes) {
                String moType = FDNUtil.getFdnType((String)index.getFdn());
                this.getLogger().info("QAsnGetTPNameTask queryPortInfoFromDB For ifm fdn : " + index.getFdn());
                this.devIDLst.add(index.getDevID());
                if (!"NE".equals(moType)) {
                    if (StringUtil.isEmpty((String)index.getIfName())) continue;
                    interfaces.add(index);
                    continue;
                }
                ArrayList<Interface> devIDIndexes = new ArrayList<Interface>();
                Interface mo = new Interface();
                mo.setDevID(index.getDevID());
                devIDIndexes.add(index);
                Collection interfaceins = ((InterfaceDao)this.getDao()).queryByFields(Interface.class, new String[]{"devID"}, devIDIndexes, true);
                if (CollectionUtils.isEmpty((Collection)interfaceins)) continue;
                interfaces.addAll(interfaceins);
            }
            this.getLogger().info("QAsnGetTPNameTask queryPortInfoFromDB PTN queryresult num = " + interfaces.size());
            interfaces = this.packPTNName(interfaces);
            this.getLogger().info("QAsnGetTPNameTask queryPortInfoFromDB PTN pack finish.");
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnGetTPNameTask queryPortInfoFromDB error.", (Throwable)e);
        }
        return interfaces;
    }
}

