/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnGetSubInterfaceReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnGetSubInterfaceRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.sap.QAsnGetSap;
import com.huawei.vmf.adapter.ifm.translation.asn.QAsnTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnGetSubInterfaceTask
extends DefaultQueryByFDNTask<QAsnGetSubInterfaceReq, QAsnGetSubInterfaceRsp, Interface> {
    private QAsnGetSubInterfaceReq req = null;
    private final QAsnGetSap sapQuery = new QAsnGetSap();

    public QAsnGetSubInterfaceTask(QAsnGetSubInterfaceReq req, QAsnGetSubInterfaceRsp rsp) {
        super((Collection)req.portIndexList, (IFdnParser)new InterfaceFdnParser(), null, (IAsnTranslator)new QAsnTranslator(), (Collection)rsp.sapList, (FStruct)rsp.result, true, true);
        this.req = req;
        this.setDao(DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class));
    }

    protected Collection<Interface> queryFromDB() throws VMFException {
        List conditions = this.getFilterMos();
        if (CollectionUtils.isEmpty((Collection)conditions)) {
            throw new VMFException(1107498879);
        }
        return this.querySubInterface(conditions);
    }

    private Set<Integer> getIncludeTypes(int specifyType) {
        HashSet<Integer> ret = new HashSet<Integer>();
        if (specifyType < 0) {
            ret.addAll(U2KInterfaceTypeMapping.getSubInterfaceType());
        }
        if (specifyType == 1025) {
            ret.add(65559);
        }
        return ret;
    }

    private Collection<Interface> querySubInterface(List<Interface> indexes) {
        Collection<Interface> interfaces = null;
        try {
            switch (this.req.operationType) {
                case 1: {
                    interfaces = ((InterfaceDao)this.getDao()).querySubIfByMainIf(indexes);
                    break;
                }
                case 0: 
                case 20: {
                    Set<Integer> includeType = this.getIncludeTypes(this.req.filterType);
                    if (!indexes.isEmpty()) {
                        interfaces = this.sapQuery.queryByInterface(indexes);
                        break;
                    }
                    List devIDs = ((InterfaceFdnParser)this.getFdnPaser()).getDevIDList(this.req.portIndexList);
                    List keys = (List)((InterfaceDao)this.getDao()).queryByFilterAndNeIDs(devIDs, includeType, false);
                    interfaces = this.sapQuery.queryByInterface(keys);
                    break;
                }
                case 21: {
                    break;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("querySubInterface error.", (Throwable)e);
        }
        ArrayList<Interface> subInfs = new ArrayList<Interface>();
        if (CollectionUtils.isEmpty(interfaces)) {
            return subInfs;
        }
        for (Interface inf : interfaces) {
            if (InterfaceUtil.isMainInterface(inf.getIfName())) continue;
            subInfs.add(inf);
        }
        return subInfs;
    }
}

