/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.network.qasn.m_q_interface_op.QAsnGetPortDetailInfoReq;
import com.huawei.network.qasn.m_q_interface_op.QAsnGetPortDetailInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnGetPortDetailInfoTaskExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.ifm.common.AdapterDevMgr;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortDetailInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnGetPortDetailInfoTask
extends DefaultQueryByFDNTask<QAsnGetPortDetailInfoReq, QAsnGetPortDetailInfoRsp, Interface> {
    private int FILTRATE_TYPE_0 = 0;
    private int FILTRATE_TYPE_19 = 19;
    private int FILTRATE_TYPE_20 = 20;
    private Set<Integer> filtrateType = null;
    private QAsnGetPortDetailInfoReq req = null;
    private static final String GE_MGR = "GigabitEthernet0/0/0";
    private static final String NULL_MGR = "NULL0";

    public QAsnGetPortDetailInfoTask(QAsnGetPortDetailInfoReq req, QAsnGetPortDetailInfoRsp rsp) {
        super((Collection)req.portIndexList, (IFdnParser)new InterfaceFdnParser(), null, (IAsnTranslator)new QAsnPortDetailInfoTranslator(), (Collection)rsp.portInfoList, (FStruct)rsp.result, true, true);
        this.setDao(DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class));
        this.req = req;
    }

    protected void doAfterEncodeRsp(QAsnGetPortDetailInfoReq req, QAsnGetPortDetailInfoRsp rsp, QueryResult result) {
        Object getPortDetailInfoTaskExtPoint;
        if ((req.operationType == this.FILTRATE_TYPE_0 || req.operationType == this.FILTRATE_TYPE_19) && null != (getPortDetailInfoTaskExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnGetPortDetailInfoTaskExtPoint.class))) {
            ((IQAsnGetPortDetailInfoTaskExtPoint)getPortDetailInfoTaskExtPoint).doAfterEncodeRsp((FStruct)req, (FStruct)rsp, result);
        }
    }

    protected void encodeRspQueryDatas(QAsnGetPortDetailInfoReq req, QAsnGetPortDetailInfoRsp rsp, Collection<Interface> mos) {
        this.getLogger().info("QAsnGetPortDetailInfoReq encodeRspQueryDatas start");
        try {
            super.encodeRspQueryDatas((FStruct)req, (FStruct)rsp, mos);
        }
        catch (Exception e) {
            this.getLogger().error("encodeRspQueryDatas erroe.", (Throwable)e);
        }
        this.getLogger().info("QAsnGetPortDetailInfoReq encodeRspQueryDatas end");
    }

    protected Collection<Interface> queryFromDB() throws VMFException {
        return this.queryPortInfoFromDB(this.getFilterMos());
    }

    private Set<Integer> excludeIfType(int operationType, List<Integer> defaultType) {
        HashSet<Integer> includeType = new HashSet<Integer>();
        switch (operationType) {
            case 0: {
                break;
            }
            case 4: {
                includeType.add(65543);
                break;
            }
            case 17: {
                includeType.addAll(U2KInterfaceTypeMapping.getPhysicalInterfaceType());
                break;
            }
            case 18: {
                includeType.addAll(U2KInterfaceTypeMapping.getLogicalInterfaceType());
                break;
            }
            case 19: {
                includeType.addAll(U2KInterfaceTypeMapping.getPhysicalInterfaceType());
                includeType.addAll(U2KInterfaceTypeMapping.getLogicalInterfaceType());
                break;
            }
            case 20: {
                includeType.addAll(defaultType);
                break;
            }
        }
        return includeType;
    }

    private Collection<Interface> packPTNName(Collection<Interface> ifms) {
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        if (null != interfaceUtilExtPoint && !CollectionUtils.isEmpty(ifms)) {
            for (Interface ifm : ifms) {
                ((IInterfaceUtilExtPoint)interfaceUtilExtPoint).packPortNameForPTN(ifm);
            }
        }
        return ifms;
    }

    private Collection<Interface> queryPortInfoFromDB(Collection<Interface> indexes) {
        AsnTranslationContext context = new AsnTranslationContext();
        this.filtrateType = null;
        Object extendPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnGetPortDetailInfoTaskExtPoint.class);
        if (null != extendPoint) {
            IQAsnGetPortDetailInfoTaskExtPoint extPoint = (IQAsnGetPortDetailInfoTaskExtPoint)extendPoint;
            this.filtrateType = extPoint.excludeIfType(this.req.operationType, (List)this.req.filterTypeList);
        } else {
            this.filtrateType = this.excludeIfType(this.req.operationType, (List<Integer>)this.req.filterTypeList);
        }
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        try {
            if (this.req.operationType == this.FILTRATE_TYPE_0) {
                HashSet<Interface> ifmLists = new HashSet<Interface>();
                List ifmList = ((InterfaceFdnParser)this.getFdnPaser()).getIndexMos((Collection)this.req.portIndexList);
                if (CollectionUtils.isEmpty((Collection)ifmList)) {
                    return interfaces;
                }
                for (Interface ifmMo : ifmList) {
                    if (StringUtil.isEmpty((String)ifmMo.getIfName())) continue;
                    ifmLists.add(ifmMo);
                }
                Collection<Interface> interfaceins = ((InterfaceDao)this.getDao()).queryInterfaceInfoByKey(ifmLists, (IAsnTranslationContext)context, this.req.filterAttrBit);
                interfaces.addAll(interfaceins);
            } else {
                List devIDs = ((InterfaceFdnParser)this.getFdnPaser()).getDevIDList(this.req.portIndexList);
                for (Integer devID : devIDs) {
                    String devType = InterfaceUtil.getDevTypeName(devID);
                    this.getLogger().info("QAsnGetPortDetailInfoReq devID operationType : " + this.req.operationType + " devID = " + devID);
                    Collection<Interface> interfaceins = ((InterfaceDao)this.getDao()).queryPortDetailByNeID(Arrays.asList(devID), this.filtrateType, (IAsnTranslationContext)context, this.req.filterAttrBit);
                    this.getLogger().info("QAsnGetPortDetailInfoReq ifm query finish operationType : " + this.req.operationType + " devID = " + devID);
                    HashMap<String, Boolean> configMap = AdapterDevMgr.getInstance().getDevConfigByType(devType);
                    if (null != configMap || this.req.operationType != this.FILTRATE_TYPE_20 && this.req.operationType != this.FILTRATE_TYPE_0) {
                        if (null != configMap) {
                            if (null != configMap.get("Serial")) {
                                interfaceins = InterfaceUtil.filterSerialInterface(interfaceins);
                            }
                            if (null != configMap.get("subinterface")) {
                                interfaceins = InterfaceUtil.filterSubInterface(interfaceins);
                            }
                        } else {
                            interfaceins = InterfaceUtil.filterSerialInterface(interfaceins);
                            interfaceins = InterfaceUtil.filterSubInterface(interfaceins);
                        }
                    }
                    this.getLogger().info("QAsnGetPortDetailInfoReq filter serial and sub operationType : " + this.req.operationType + " devID = " + devID);
                    interfaceins = null != extendPoint && this.req.operationType == this.FILTRATE_TYPE_20 && null != this.filtrateType && this.filtrateType.contains(1025) ? QAsnGetPortDetailInfoTask.filterGEMgrInterface(interfaceins) : QAsnGetPortDetailInfoTask.filterNULLMgrInterface(interfaceins);
                    this.getLogger().info("QAsnGetPortDetailInfoReq filter mgrIF operationType : " + this.req.operationType + " devID = " + devID);
                    interfaces.addAll(interfaceins);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("queryPortInfoFromDB error.", (Throwable)e);
        }
        this.getLogger().info("QAsnGetPortDetailInfoReq packName start num : " + interfaces.size());
        this.packPTNName(interfaces);
        this.getLogger().info("QAsnGetPortDetailInfoReq packName end num : " + interfaces.size());
        return interfaces;
    }

    public static Collection<Interface> filterGEMgrInterface(Collection<Interface> interfaces) {
        ArrayList<Interface> ifms = new ArrayList<Interface>();
        for (Interface inf : interfaces) {
            if (GE_MGR.equals(inf.getIfName()) || NULL_MGR.equals(inf.getIfName())) continue;
            inf.setIfNameBackUp(inf.getIfName());
            ifms.add(inf);
        }
        return ifms;
    }

    public static Collection<Interface> filterNULLMgrInterface(Collection<Interface> interfaces) {
        ArrayList<Interface> ifms = new ArrayList<Interface>();
        for (Interface inf : interfaces) {
            if (NULL_MGR.equals(inf.getIfName())) continue;
            inf.setIfNameBackUp(inf.getIfName());
            ifms.add(inf);
        }
        return ifms;
    }
}

