/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_interface_model.QAsnIfIndexResult;
import com.huawei.network.qasn.m_q_interface_model.QAsnIfIndexResultList;
import com.huawei.network.qasn.m_q_interface_op.QAsnGetIfIndexByFDNReq;
import com.huawei.network.qasn.m_q_interface_op.QAsnGetIfIndexByFDNRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Collection;

public class QAsnGetIfIndexByFDNTask
extends AbstractQTask<QAsnGetIfIndexByFDNReq, QAsnGetIfIndexByFDNRsp> {
    protected void executeTask(QAsnGetIfIndexByFDNReq req, QAsnGetIfIndexByFDNRsp rsp, Task task) {
        try {
            rsp.errMsg.result = 0;
            InterfaceFdnParser fdnPaser = new InterfaceFdnParser();
            ArrayList<Interface> conditions = new ArrayList<Interface>();
            for (Object object : req.resIDList) {
                QAsnUniResID qasnUniResID = (QAsnUniResID)object;
                Interface mo = (Interface)fdnPaser.getIndexMo(StringUtil.globalString((byte[])qasnUniResID.strFDN));
                if (null == mo) continue;
                conditions.add(mo);
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection interfaces = dao.queryByKey(Interface.class, conditions, false);
            rsp.resultList = new QAsnIfIndexResultList();
            for (Interface inf : interfaces) {
                QAsnIfIndexResult asn = new QAsnIfIndexResult();
                asn.resID = fdnPaser.getUniResID((VmfMO)inf);
                asn.ifIndex = AsnUtil.intValue((Long)inf.getIfIndex());
                rsp.resultList.add((Object)asn);
            }
        }
        catch (VMFException e) {
            rsp.errMsg.result = e.getErrorCode();
            this.getLogger().error("QAsnGetIfIndexByFDNTask failed!", (Throwable)e);
        }
    }
}

