/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_link_model.QAsnIPInterface;
import com.huawei.network.qasn.m_q_ip_link_model.QAsnIpInterfaceList;
import com.huawei.network.qasn.m_q_ip_link_op.QAsnGetIPInterfaceReq;
import com.huawei.network.qasn.m_q_ip_link_op.QAsnGetIPInterfaceRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec.QAsnGetIPInterfaceTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnGetIPInterfaceTask
extends AbstractQTask<QAsnGetIPInterfaceReq, QAsnGetIPInterfaceRsp> {
    private final InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
    private final InterfaceFdnParser parser = new InterfaceFdnParser();
    private final QAsnGetIPInterfaceTranslator translator = new QAsnGetIPInterfaceTranslator();

    public QAsnGetIPInterfaceTask(QAsnGetIPInterfaceReq req, QAsnGetIPInterfaceRsp rsp) {
    }

    protected void executeTask(QAsnGetIPInterfaceReq req, QAsnGetIPInterfaceRsp rsp, Task task) {
        rsp.neID = req.neID;
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        this.getInterfaces(req, interfaces);
        this.encodeRsp(interfaces, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeRsp(List<Interface> interfaces, QAsnGetIPInterfaceRsp rsp) {
        int errorCode = 0;
        if (null == rsp.polstIpInterface) {
            rsp.polstIpInterface = new QAsnIpInterfaceList();
        }
        AsnTranslationContext context = new AsnTranslationContext();
        try {
            if (!CollectionUtils.isEmpty(interfaces)) {
                for (Interface inf : interfaces) {
                    QAsnIPInterface asn = new QAsnIPInterface();
                    this.translator.encode(inf, asn, (IAsnTranslationContext)context);
                    rsp.polstIpInterface.add((Object)asn);
                    this.getLogger().info("QAsnIPInterface is " + asn + " --fdn : " + new String(asn.resID.strFDN));
                }
            }
            rsp.result.isSuccess = errorCode == 0;
        }
        catch (VMFException e) {
            try {
                this.getLogger().error("encode interface error.", (Throwable)e);
                rsp.result.isSuccess = errorCode == 0;
            }
            catch (Throwable throwable) {
                rsp.result.isSuccess = errorCode == 0;
                rsp.result.retCode = errorCode;
                rsp.result.reason = new byte[0];
                throw throwable;
            }
            rsp.result.retCode = errorCode;
            rsp.result.reason = new byte[0];
        }
        rsp.result.retCode = errorCode;
        rsp.result.reason = new byte[0];
    }

    private void getInterfaces(QAsnGetIPInterfaceReq req, Collection<Interface> interfaces) {
        HashSet<Integer> physicalTypes = new HashSet<Integer>();
        physicalTypes.addAll(U2KInterfaceTypeMapping.getPhysicalInterfaceType());
        try {
            Collection<Interface> tmpInterfaces = null;
            if (CollectionUtils.isEmpty((Collection)req.polstIfResID)) {
                tmpInterfaces = this.dao.queryByFilterAndNeID(CommonUtil.genSet((Object[])new Integer[]{req.neID}), physicalTypes, true);
            } else {
                List indexes = this.parser.getIndexMos((Collection)req.polstIfResID);
                if (!indexes.isEmpty()) {
                    tmpInterfaces = this.dao.queryByFilterAndFdn(indexes, physicalTypes, true);
                } else {
                    List neIDs = this.parser.getDevIDList(req.polstIfResID);
                    tmpInterfaces = this.dao.queryByFilterAndNeID(neIDs, physicalTypes, true);
                }
            }
            interfaces.addAll(tmpInterfaces);
        }
        catch (VMFException e) {
            this.getLogger().error("get interfaces error.", (Throwable)e);
        }
    }
}

