/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResult;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResultRsp;
import com.huawei.network.qasn.m_q_interface_op.QAsnDeletePortReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnDeletePortTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class QAsnDeletePortTask
extends AbstractConfigQTask<QAsnDeletePortReq, QAsnPortResultRsp> {
    private InterfaceFdnParser fdnParser = new InterfaceFdnParser();

    public QAsnDeletePortTask() {
        super(EOperationType.DELETE);
        Object extPnt = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnDeletePortTaskExtPoint.class);
        if (null != extPnt) {
            IQAsnDeletePortTaskExtPoint extPoint = (IQAsnDeletePortTaskExtPoint)extPnt;
            Map moCompositeServices = extPoint.getMoCompositeService();
            Set services = moCompositeServices.entrySet();
            for (Map.Entry entry : services) {
                this.addMoCompositeService((Class)entry.getKey(), (ICompositeService)entry.getValue());
            }
        } else {
            this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
        }
    }

    protected void decode(QAsnDeletePortReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        Object extPnt = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnDeletePortTaskExtPoint.class);
        if (null != extPnt) {
            IQAsnDeletePortTaskExtPoint extPoint = (IQAsnDeletePortTaskExtPoint)extPnt;
            extPoint.decode((FStruct)req, asnTranslatorContext);
        } else {
            IMOChangeRecord moChangeRecord = asnTranslatorContext.getTransactionContext().addChangeRecord(Interface.class);
            for (Object object : req.portIndexList) {
                QAsnUniResID uniResID = (QAsnUniResID)object;
                Interface indexMo = (Interface)this.fdnParser.getIndexMo(uniResID);
                if (null == indexMo) continue;
                if (65539 == indexMo.getiQIfType() || 65540 == indexMo.getiQIfType()) {
                    try {
                        TrunkIf trunk = new TrunkIf();
                        trunk.setDevID(indexMo.getDevID());
                        trunk.setVrID(indexMo.getVrID());
                        trunk.setIfName(indexMo.getIfName());
                        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                        Collection trunks = dao.queryByKey(TrunkIf.class, Arrays.asList(trunk), false);
                        IMOChangeRecord delMo = asnTranslatorContext.getTransactionContext().addChangeRecord(TrunkIf.class);
                        for (TrunkIf trunkif : trunks) {
                            indexMo.addKeyRefMo((VmfMO)trunkif);
                            delMo.addDelete((Object)trunkif);
                        }
                    }
                    catch (VMFException e) {
                        this.getLogger().error("QAsnAddAggrPortMemberReq decode failed.", (Throwable)e);
                    }
                }
                moChangeRecord.addDelete((Object)indexMo);
            }
        }
    }

    protected void encode(QAsnPortResultRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnDeletePortTaskExtPoint.class);
        if (null != extPoint) {
            ((IQAsnDeletePortTaskExtPoint)extPoint).encode((FStruct)rsp, asnTranslatorContext);
        } else {
            QAsnErrInfoReturn oResult;
            OperResult operResult = asnTranslatorContext.getTransactionContext().getOperResult();
            Set interfaces = asnTranslatorContext.getTransactionContext().getChangeRecord(Interface.class).getAllChanges();
            for (Interface inf : interfaces) {
                QAsnUniResID uniResID;
                QAsnPortResult portResult = new QAsnPortResult();
                portResult.portIndex = uniResID = this.fdnParser.getUniResID((VmfMO)inf);
                portResult.result = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)inf, (OperResult)operResult);
                rsp.portResultList.add((Object)portResult);
            }
            rsp.result = oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)asnTranslatorContext.getTransactionContext().getOperResult());
        }
    }

    protected Integer getAsnBestEffort(QAsnDeletePortReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnDeletePortReq req) {
        return req.poTaskFlg;
    }
}

