/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnDeleteCTPInfoReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnDeleteCTPInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class QAsnDeleteCTPInfoTask
extends AbstractConfigQTask<QAsnDeleteCTPInfoReq, QAsnDeleteCTPInfoRsp> {
    private InterfaceFdnParser fdnParser = new InterfaceFdnParser();

    public QAsnDeleteCTPInfoTask() {
        super(EOperationType.DELETE);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnDeleteCTPInfoReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        try {
            ArrayList<Interface> conditions = new ArrayList<Interface>();
            for (Object object : req.olstDelCtpKey) {
                QAsnUniResID uniResID = (QAsnUniResID)object;
                Interface indexMo = (Interface)this.fdnParser.getIndexMo(uniResID);
                if (null == indexMo) continue;
                conditions.add(indexMo);
            }
            if (CollectionUtils.isEmpty(conditions)) {
                return;
            }
            IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
            interfaceService.processSAP(conditions, (Object)asnTranslatorContext);
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnDeleteCTPInfoReq decode failed.", (Throwable)e);
        }
    }

    protected void encode(QAsnDeleteCTPInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        QAsnErrInfoReturn oResult;
        Set interfaces = asnTranslatorContext.getTransactionContext().getChangeRecord(Interface.class).getAllChanges();
        for (Interface inf : interfaces) {
            QAsnUniResID uniResID = this.fdnParser.getUniResID((VmfMO)inf);
            rsp.olstFDelCtpKey.add((Object)uniResID);
        }
        rsp.result = oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)asnTranslatorContext.getTransactionContext().getOperResult());
    }

    protected Integer getAsnBestEffort(QAsnDeleteCTPInfoReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteCTPInfoReq req) {
        return null;
    }
}

