/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAPList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSrvLink;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnSrvFwrdTbl;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnCreateSrvLinkReq;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnCreateSrvLinkRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.translation.asn.QAsnTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnCreateSrvLinkTask
extends AbstractConfigQTask<QAsnCreateSrvLinkReq, QAsnCreateSrvLinkRsp> {
    private IAsnTranslator<QAsnSAP, Interface> tanslator = new QAsnTranslator();

    public QAsnCreateSrvLinkTask() {
        super(EOperationType.CREATE);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnCreateSrvLinkReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        this.createSap(req, asnTranslatorContext);
        this.createSrvLink(req, asnTranslatorContext);
    }

    private void createSap(QAsnCreateSrvLinkReq req, IAsnTranslationContext asnTranslatorContext) {
        try {
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            for (QAsnSrvFwrdTbl srvFwrdTbl : req.fwrdTblList) {
                for (QAsnSAP sap : srvFwrdTbl.sapList) {
                    Interface ifn = (Interface)this.tanslator.decode((FStruct)sap, asnTranslatorContext);
                    if (null == ifn) continue;
                    interfaces.add(ifn);
                }
            }
            if (CollectionUtils.isEmpty(interfaces)) {
                return;
            }
            IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
            interfaceService.processSAP(interfaces, (Object)asnTranslatorContext);
            Context context = asnTranslatorContext.getTransactionContext();
            Map allChanges = context.getAllChanges();
            for (Map.Entry entry : allChanges.entrySet()) {
                IMOChangeRecord changeRecord = (IMOChangeRecord)entry.getValue();
                Set creates = changeRecord.getCreates();
                Set modifies = changeRecord.getModifies();
                if (CollectionUtils.isEmpty((Collection)modifies)) continue;
                for (Object modifMo : modifies) {
                    if (!creates.contains(modifMo)) continue;
                    changeRecord.cancelModify(modifMo);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq decode failed.", (Throwable)e);
        }
    }

    private void createSrvLink(QAsnCreateSrvLinkReq req, IAsnTranslationContext asnTranslatorContext) {
        for (QAsnSrvFwrdTbl srvFwrdTbl : req.fwrdTblList) {
            for (QAsnSrvLink link : srvFwrdTbl.linkList) {
                link.linkName = "".getBytes();
            }
        }
    }

    protected void encode(QAsnCreateSrvLinkRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        try {
            QAsnErrInfoReturn oResult;
            Context context = asnTranslatorContext.getTransactionContext();
            OperResult operResult = context.getOperResult();
            Set interfaces = context.getChangeRecord(Interface.class).getAllChanges();
            QAsnSAPList sucCtps = new QAsnSAPList();
            QAsnSAPList failedCtps = new QAsnSAPList();
            for (Interface inf : interfaces) {
                QAsnSAP sap = (QAsnSAP)this.tanslator.encode((Object)inf, asnTranslatorContext);
                ErrorInfo errorInfo = AsnTranslatorUtil.getMoWithRefOperResult((VmfMO)inf, (OperResult)operResult);
                if (AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    sucCtps.add((Object)sap);
                    continue;
                }
                failedCtps.add((Object)sap);
            }
            rsp.result = oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)operResult);
            if (0 == oResult.result) {
                IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
                interfaceService.reloadTerminationData((Object)asnTranslatorContext);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq encode failed.", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateSrvLinkReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateSrvLinkReq req) {
        return req.poTaskFlag;
    }
}

