/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_interface_model.QAsnCreatePort;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResult;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResultRsp;
import com.huawei.network.qasn.m_q_interface_op.QAsnCreatePortReq;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnCreatePortTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortDetailInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnCreatePortTask
extends AbstractConfigQTask<QAsnCreatePortReq, QAsnPortResultRsp> {
    private InterfaceFdnParser fdnParser = new InterfaceFdnParser();
    private Map<Interface, ErrorInfo> failedIfs = new HashMap<Interface, ErrorInfo>();
    private IAsnTranslator<QAsnPortDetailInfo, Interface> translator = new QAsnPortDetailInfoTranslator();

    public QAsnCreatePortTask() {
        super(EOperationType.CREATE);
        Object extPnt = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnCreatePortTaskExtPoint.class);
        if (null != extPnt) {
            IQAsnCreatePortTaskExtPoint extPoint = (IQAsnCreatePortTaskExtPoint)extPnt;
            Map moCompositeServices = extPoint.getMoCompositeService();
            Set services = moCompositeServices.entrySet();
            for (Map.Entry entry : services) {
                this.addMoCompositeService((Class)entry.getKey(), (ICompositeService)entry.getValue());
            }
        } else {
            this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
        }
    }

    protected void decode(QAsnCreatePortReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        Object extPnt = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnCreatePortTaskExtPoint.class);
        if (null != extPnt) {
            IQAsnCreatePortTaskExtPoint extPoint = (IQAsnCreatePortTaskExtPoint)extPnt;
            extPoint.decode((FStruct)req, asnTranslatorContext);
        } else {
            IMOChangeRecord moChangeRecord = asnTranslatorContext.getTransactionContext().addChangeRecord(Interface.class);
            try {
                for (Object object : req.portInfoList) {
                    QAsnCreatePort port = (QAsnCreatePort)object;
                    Interface indexMo = (Interface)this.fdnParser.getIndexMo(port.portInfo.portIndex);
                    if (null == indexMo) continue;
                    ArrayList<Interface> filterMos = new ArrayList<Interface>();
                    filterMos.add(indexMo);
                    IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                    Collection mos = dao.queryByKey(Interface.class, filterMos, false);
                    if (!CollectionUtils.isEmpty((Collection)mos)) {
                        this.failedIfs.put(indexMo, new ErrorInfo(1107498865));
                        continue;
                    }
                    this.translator.decode((FStruct)port.portInfo, (Object)indexMo, asnTranslatorContext);
                    moChangeRecord.addCreate((Object)indexMo);
                    this.dealUnnumberIPAddr(indexMo, port, asnTranslatorContext);
                }
            }
            catch (VMFException e) {
                this.getLogger().error("QAsnCreatePortReq decode failed.", (Throwable)e);
            }
        }
    }

    protected void encode(QAsnPortResultRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnCreatePortTaskExtPoint.class);
        if (null != extPoint) {
            ((IQAsnCreatePortTaskExtPoint)extPoint).encode((FStruct)rsp, asnTranslatorContext);
        } else {
            OperResult operResult = asnTranslatorContext.getTransactionContext().getOperResult();
            Set interfaces = asnTranslatorContext.getTransactionContext().getChangeRecord(Interface.class).getAllChanges();
            for (Interface inf : interfaces) {
                QAsnUniResID uniResID;
                QAsnPortResult portResult = new QAsnPortResult();
                portResult.portIndex = uniResID = this.fdnParser.getUniResID((VmfMO)inf);
                portResult.result = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)inf, (OperResult)operResult);
                rsp.portResultList.add((Object)portResult);
            }
            QAsnErrInfoList errlist = new QAsnErrInfoList();
            for (Interface inf : this.failedIfs.keySet()) {
                QAsnUniResID uniResID;
                QAsnPortResult portResult = new QAsnPortResult();
                portResult.portIndex = uniResID = this.fdnParser.getUniResID((VmfMO)inf);
                ErrorInfo errorInfo = this.failedIfs.get(inf);
                portResult.result = AsnTranslatorUtil.translate2QAsnSingleReturn((ErrorInfo)errorInfo);
                rsp.portResultList.add((Object)portResult);
                errlist.add((Object)AsnTranslatorUtil.translate2QAsnErrInfo((ErrorInfo)errorInfo, (int)inf.getDevID(), (String)inf.getFdn()));
            }
            QAsnErrInfoReturn oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)asnTranslatorContext.getTransactionContext().getOperResult());
            if (null == oResult.errList) {
                oResult.errList = new QAsnErrInfoList();
            }
            oResult.errList.addAll((Collection)errlist);
            if (!errlist.isEmpty()) {
                oResult.result = 1107499878;
            }
            rsp.result = oResult;
        }
    }

    protected Integer getAsnBestEffort(QAsnCreatePortReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnCreatePortReq req) {
        return req.poTaskFlg;
    }

    private void dealUnnumberIPAddr(Interface indexmo, QAsnCreatePort port, IAsnTranslationContext asnTranslatorContext) {
        String strUnNumberIf = indexmo.getUnNumIfName();
        if (null != strUnNumberIf && (port.portInfo.operBit & 0x8000) > 0 && null != port.portInfo.poIpAddress && null != port.portInfo.poIpAddress.poOperMask && (port.portInfo.poIpAddress.poOperMask & 2) > 0) {
            this.getLogger().error("Start deal to unnumber address into database!");
            Interface unnumberInfo = new Interface();
            unnumberInfo.setDevID(indexmo.getDevID());
            unnumberInfo.setVrID(indexmo.getVrID());
            unnumberInfo.setIfName(strUnNumberIf);
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            try {
                Interface unnumberIf;
                Collection ipv4Lst;
                Collection unnumberIfs = dao.queryByKey(Interface.class, Arrays.asList(unnumberInfo), true);
                Iterator i$ = unnumberIfs.iterator();
                block2: while (i$.hasNext() && !(ipv4Lst = (unnumberIf = (Interface)i$.next()).getIpv4Addresss()).isEmpty()) {
                    for (Ipv4Address ipv4addr : ipv4Lst) {
                        if (Ipv4Address.ADDR_TYPE_ENUM.MAIN.intValue() != ipv4addr.getAddrType().intValue()) continue;
                        ipv4addr.setIfName(indexmo.getIfName());
                        ipv4addr.setAddrType(Ipv4Address.ADDR_TYPE_ENUM.UNNUMBER);
                        Context ctx = new Context();
                        IMOChangeRecord changeRecord = ctx.addDBChangeRecord(Ipv4Address.class);
                        IDao getDao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
                        if (!CollectionUtils.isEmpty((Collection)getDao.queryByKey(Ipv4Address.class, Arrays.asList(ipv4addr), false))) continue block2;
                        changeRecord.addCreate((Object)ipv4addr);
                        getDao.merge(Ipv4Address.class, false);
                        continue block2;
                    }
                }
            }
            catch (VMFException e) {
                this.getLogger().error("failed to query unnumber address for create portdeail!", (Throwable)e);
            }
        }
    }
}

