/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAPList;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnCreateCTPInfoReq;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnCreateCTPInfoRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.translation.asn.QAsnTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec.QAsnSAPSpecTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnCreateCTPInfoTask
extends AbstractConfigQTask<QAsnCreateCTPInfoReq, QAsnCreateCTPInfoRsp> {
    private List<Interface> failedMos = new ArrayList<Interface>();
    private QAsnSAPSpecTranslator fdnTranslator = new QAsnSAPSpecTranslator();
    private IAsnTranslator<QAsnSAP, Interface> tanslator = new QAsnTranslator();

    public QAsnCreateCTPInfoTask() {
        super(EOperationType.CREATE);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void allocateSubif(Interface mo, Collection<Integer> subifs) {
        Integer oldId = 0;
        Iterator<Integer> iter = subifs.iterator();
        if (iter.hasNext()) {
            Integer newId = iter.next();
            if ((oldId = Integer.valueOf(oldId + 1)) < newId) {
                String strSubif = mo.getIfName() + "." + oldId.toString();
                mo.setIfParentIfName(mo.getIfName());
                mo.setIfName(strSubif);
                mo.setIfNumber(oldId.toString());
                InterfaceFdnParser fdnParser = new InterfaceFdnParser();
                String fdn = fdnParser.getFdn(mo);
                mo.setFdn(fdn);
                subifs.add(oldId);
                return;
            }
        }
        oldId = oldId + 1;
        String strSubif = mo.getIfName() + "." + oldId.toString();
        mo.setIfParentIfName(mo.getIfName());
        mo.setIfName(strSubif);
        mo.setIfNumber(oldId.toString());
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        String fdn = fdnParser.getFdn(mo);
        mo.setFdn(fdn);
        subifs.add(oldId);
    }

    protected void decode(QAsnCreateCTPInfoReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        try {
            String strMainIf = "";
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            Collection<Integer> subifs = new TreeSet<Integer>();
            for (Object object : req.olstCtpInfo) {
                QAsnSAP sap = (QAsnSAP)object;
                Interface ifn = new Interface();
                this.fdnTranslator.decodeKeyProperties(sap, ifn, asnTranslatorContext);
                if (1 == sap.autopickSapID) {
                    if (strMainIf.equals(ifn.getIfName())) {
                        subifs = this.querySubifByMainif(ifn);
                        strMainIf = ifn.getIfName();
                    }
                    this.allocateSubif(ifn, subifs);
                    sap.ctpKey.strFDN = ifn.getFdn().getBytes();
                    sap.ctpKey.strMOC = StringUtil.globalByte((String)"SUBIF");
                    sap.subIFNo = StringUtil.getInteger((String)ifn.getIfNumber());
                } else {
                    ArrayList<Interface> filterMos = new ArrayList<Interface>();
                    filterMos.add(ifn);
                    IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                    Collection mos = dao.queryByKey(Interface.class, filterMos, false);
                    if (!CollectionUtils.isEmpty((Collection)mos)) {
                        Context context = asnTranslatorContext.getTransactionContext();
                        context.addMoOperResult((VmfMO)ifn, 1107498865);
                        this.failedMos.add(ifn);
                        continue;
                    }
                }
                if (null == (ifn = (Interface)this.tanslator.decode((FStruct)sap, asnTranslatorContext))) continue;
                interfaces.add(ifn);
            }
            if (CollectionUtils.isEmpty(interfaces)) {
                return;
            }
            IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
            interfaceService.processSAP(interfaces, (Object)asnTranslatorContext);
            Context context = asnTranslatorContext.getTransactionContext();
            Map allChanges = context.getAllChanges();
            for (Map.Entry entry : allChanges.entrySet()) {
                IMOChangeRecord changeRecord = (IMOChangeRecord)entry.getValue();
                Set creates = changeRecord.getCreates();
                Set modifies = changeRecord.getModifies();
                if (CollectionUtils.isEmpty((Collection)modifies)) continue;
                for (Object modifMo : modifies) {
                    if (!creates.contains(modifMo)) continue;
                    changeRecord.cancelModify(modifMo);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq decode failed.", (Throwable)e);
        }
    }

    protected void encode(QAsnCreateCTPInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        try {
            Context context = asnTranslatorContext.getTransactionContext();
            OperResult operResult = context.getOperResult();
            Set interfaces = context.getChangeRecord(Interface.class).getAllChanges();
            QAsnSAPList sucCtps = new QAsnSAPList();
            QAsnSAPList failedCtps = new QAsnSAPList();
            for (Interface inf : interfaces) {
                QAsnSAP sap = (QAsnSAP)this.tanslator.encode((Object)inf, asnTranslatorContext);
                ErrorInfo errorInfo = AsnTranslatorUtil.getMoWithRefOperResult((VmfMO)inf, (OperResult)operResult);
                if (AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    sucCtps.add((Object)sap);
                    continue;
                }
                failedCtps.add((Object)sap);
            }
            QAsnErrInfoList errlist = new QAsnErrInfoList();
            for (Interface inf : this.failedMos) {
                QAsnSAP sap = (QAsnSAP)this.tanslator.encode((Object)inf, asnTranslatorContext);
                ErrorInfo errorInfo = operResult.getMoOperResult((VmfMO)inf);
                if (AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    sucCtps.add((Object)sap);
                } else {
                    failedCtps.add((Object)sap);
                }
                errlist.add((Object)AsnTranslatorUtil.translate2QAsnErrInfo((ErrorInfo)errorInfo, (int)inf.getDevID(), (String)inf.getFdn()));
            }
            rsp.polstSucCtp = sucCtps;
            rsp.polstFailedCtp = failedCtps;
            QAsnErrInfoReturn oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)interfaces, (OperResult)operResult);
            if (null == oResult.errList) {
                oResult.errList = new QAsnErrInfoList();
            }
            oResult.errList.addAll((Collection)errlist);
            if (!errlist.isEmpty()) {
                oResult.result = 1107499878;
            }
            rsp.result = oResult;
            if (0 == oResult.result) {
                IInterfaceService interfaceService = Activator.getService(IInterfaceService.class);
                interfaceService.reloadTerminationData((Object)asnTranslatorContext);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnCreateCTPInfoReq encode failed.", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateCTPInfoReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateCTPInfoReq req) {
        return req.taskFlg;
    }

    protected Collection<Integer> querySubifByMainif(Interface mo) {
        TreeSet<Integer> subif = new TreeSet<Integer>();
        Collection<Object> subIfs = new ArrayList();
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        try {
            subIfs = dao.querySubIfByMainIf(CommonUtil.genList((Object[])new Interface[]{mo}));
            for (Interface interface_ : subIfs) {
                String strIfNumber = interface_.getIfNumber();
                if (null == strIfNumber) continue;
                subif.add(StringUtil.getInteger((String)strIfNumber));
            }
        }
        catch (VMFException e) {
            this.getLogger().error("failed to querySubIfByMainIf!", (Throwable)e);
        }
        return subif;
    }
}

