/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortAndMember;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortMemberInfo;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResult;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResultRsp;
import com.huawei.network.qasn.m_q_interface_op.QAsnAddAggrPortMemberReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnAggrPortMemberTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.TrunkIfFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.fdn.TrunkMemberIfFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Lag;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkMemberIf;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.translation.asn.trunk.QAsnPortAndMemberTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.trunk.QAsnPortMemberInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnAddAggrPortMemberTask
extends AbstractConfigQTask<QAsnAddAggrPortMemberReq, QAsnPortResultRsp> {
    private TrunkMemberIfFdnParser fdnMemParser = new TrunkMemberIfFdnParser();
    private TrunkIfFdnParser fdnParser = new TrunkIfFdnParser();
    private QAsnPortMemberInfoTranslator memTranslator = new QAsnPortMemberInfoTranslator();
    private EOperationType opType;
    private IAsnTranslator<QAsnPortAndMember, TrunkIf> translator = new QAsnPortAndMemberTranslator();

    public QAsnAddAggrPortMemberTask(EOperationType operType) {
        super(EOperationType.MODIFY);
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnAggrPortMemberTaskExtPoint.class);
        if (null != extPoint) {
            this.addMoCompositeService(Lag.class, (ICompositeService)new DefaultCompositeService(Lag.class));
        } else {
            this.addMoCompositeService(TrunkIf.class, (ICompositeService)new DefaultCompositeService(TrunkIf.class));
        }
        this.opType = operType;
    }

    protected void decode(QAsnAddAggrPortMemberReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        try {
            Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnAggrPortMemberTaskExtPoint.class);
            if (null != extPoint) {
                ((IQAsnAggrPortMemberTaskExtPoint)extPoint).decode((FStruct)req, asnTranslatorContext, this.opType);
            } else {
                TrunkIf mo = (TrunkIf)this.fdnParser.getIndexMo(req.portIndex);
                ArrayList<TrunkIf> filterMos = new ArrayList<TrunkIf>();
                filterMos.add(mo);
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                Collection mos = dao.queryByKey(TrunkIf.class, filterMos, true);
                if (CollectionUtils.isEmpty((Collection)mos)) {
                    return;
                }
                TrunkIf trunkDb = (TrunkIf)mos.iterator().next();
                mo = trunkDb;
                ArrayList<TrunkMemberIf> trunkMemberIfs = mo.getTrunkMemberIfs();
                if (null == trunkMemberIfs) {
                    trunkMemberIfs = new ArrayList<TrunkMemberIf>();
                }
                IMOChangeRecord moChangeRecord = asnTranslatorContext.getTransactionContext().addChangeRecord(TrunkIf.class);
                asnTranslatorContext.addProperty(TrunkIf.class.getName(), (Object)mo);
                for (Object obj : req.memberInfoList) {
                    QAsnPortMemberInfo portMember = (QAsnPortMemberInfo)obj;
                    TrunkMemberIf moMem = (TrunkMemberIf)this.fdnMemParser.getIndexMo(portMember.memberPortIndex);
                    moMem.setIfName(mo.getIfName());
                    if (EOperationType.CREATE == this.opType) {
                        if (trunkMemberIfs.contains(moMem)) continue;
                        this.memTranslator.setOpType(this.opType);
                        this.memTranslator.decode(portMember, moMem, asnTranslatorContext);
                        trunkMemberIfs.add(moMem);
                        continue;
                    }
                    if (EOperationType.MODIFY == this.opType) {
                        if (!trunkMemberIfs.contains(moMem)) continue;
                        trunkMemberIfs.remove(moMem);
                        this.memTranslator.setOpType(this.opType);
                        this.memTranslator.decode(portMember, moMem, asnTranslatorContext);
                        trunkMemberIfs.add(moMem);
                        continue;
                    }
                    this.memTranslator.setOpType(this.opType);
                    this.memTranslator.decode(portMember, moMem, asnTranslatorContext);
                }
                mo.setTrunkMemberIfs(trunkMemberIfs);
                ArrayList<String> lstChg = new ArrayList<String>();
                lstChg.add("trunkMemberIfs");
                moChangeRecord.addModify((Object)mo, lstChg);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnAddAggrPortMemberReq decode failed.", (Throwable)e);
        }
    }

    protected void encode(QAsnPortResultRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnAggrPortMemberTaskExtPoint.class);
        if (null != extPoint) {
            ((IQAsnAggrPortMemberTaskExtPoint)extPoint).encodeRsp((FStruct)rsp, asnTranslatorContext);
        } else {
            OperResult operResult = asnTranslatorContext.getTransactionContext().getOperResult();
            Set mos = asnTranslatorContext.getTransactionContext().getChangeRecord(TrunkIf.class).getAllChanges();
            for (TrunkIf inf : mos) {
                QAsnPortResult portResult = new QAsnPortResult();
                portResult.portIndex = this.fdnParser.getUniResID((VmfMO)inf);
                portResult.result = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)inf, (OperResult)operResult);
                rsp.portResultList.add((Object)portResult);
            }
            rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)mos, (OperResult)asnTranslatorContext.getTransactionContext().getOperResult());
        }
    }

    protected Integer getAsnBestEffort(QAsnAddAggrPortMemberReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnAddAggrPortMemberReq req) {
        return req.poTaskFlg;
    }
}

