/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.sync;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.exception.SchemaTransformException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.syncdata.AbstractFeatureSyncHandler;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.FullSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.INode;
import com.huawei.vmf.adapter.framework.translation.schema.ISchemaTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.IncreaseSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.netconf.service.TargetType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class InterfaceSyncHandler
extends AbstractFeatureSyncHandler {
    private LinkedHashSet<Class<? extends VmfMO>> moTypes = new LinkedHashSet();

    public InterfaceSyncHandler() {
        this.moTypes.add(Interface.class);
    }

    public FeatureName getFeatureName() {
        return FeatureName.IFM;
    }

    protected void fullSyncPreProcess(FullSyncTranslationContext translationContext) throws VMFException {
        this.decodeFdn(translationContext.getContext());
        this.decodeNetAddr(translationContext.getContext());
        super.fullSyncPreProcess(translationContext);
        this.delPreDataWithOutMainIf(translationContext);
    }

    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moTypes;
    }

    protected INetconfPoller getNetconfPoller(int devID) {
        return DeviceAccessorFactory.getNetconfPoller((int)devID);
    }

    protected void incrSyncDynamicStatus(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        InterfaceIncrSyncQueryContext queryContext = new InterfaceIncrSyncQueryContext(incrSyncContext.getDevID());
        this.getRefreshInterfaceStatus(incrSyncContext, queryContext);
        if (!queryContext.getFeatureMap().isEmpty()) {
            INetconfPoller poller = DeviceAccessorFactory.getNetconfPoller((int)incrSyncContext.getDevID(), (TargetType)TargetType.RDB);
            poller.query((QuerySchemaTranslatorContext)queryContext);
        }
    }

    protected void incrSyncPreProcess(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        this.decodeFdn(incrSyncContext.getContext());
        this.decodeNetAddr(incrSyncContext.getContext());
        super.incrSyncPreProcess(incrSyncContext);
    }

    private void decodeFdn(Context context) {
        InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
        IMOChangeRecord changeRecord = context.getChangeRecord(Interface.class);
        Set creates = changeRecord.getCreates();
        for (Interface inf : creates) {
            String fdn = interfaceFdnParser.getFdn(inf);
            inf.setFdn(fdn);
            inf.setiQIfType(Integer.valueOf(U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)inf.getIfName())));
        }
    }

    private void decodeNetAddr(Context context) {
        IMOChangeRecord ipv4ChangeRecord = context.getChangeRecord(Ipv4Address.class);
        Set ipv4Addresss = ipv4ChangeRecord.getAllChanges();
        for (Ipv4Address ipv4Address : ipv4Addresss) {
            String IpAddr = ipv4Address.getIpAddr();
            String subnetMask = ipv4Address.getSubnetMask();
            if (null == IpAddr || null == subnetMask) continue;
            ipv4Address.setNetAddr(IpAddressUtil.getNetAddress((String)IpAddr, (String)subnetMask));
        }
    }

    private void delPreDataWithOutMainIf(FullSyncTranslationContext translationContext) throws VMFException {
        Context context = translationContext.getContext();
        IMOChangeRecord changeRecord = context.getChangeRecord(Interface.class);
        Set modifys = changeRecord.getModifies();
        Set deletes = changeRecord.getDeletes();
        HashMap<String, Integer> mapName = new HashMap<String, Integer>();
        for (Interface info : deletes) {
            if (info.getIfName().contains(".")) continue;
            mapName.put(info.getIfName(), info.getDevID());
        }
        for (Interface inf : modifys) {
            int iPos;
            String ifname;
            String ifParenetName;
            PropertyChangeItem item;
            if (!inf.getIfName().contains(".") || null == (item = changeRecord.getPropertyChangeItem((Object)inf, "deployStatus")) || 0 != inf.getDeployStatus() || !mapName.containsKey(ifParenetName = (ifname = inf.getIfName()).substring(iPos = ifname.indexOf(".")))) continue;
            changeRecord.cancelModify((Object)inf);
            changeRecord.addDelete((Object)inf);
        }
    }

    private void getRefreshInterfaceStatus(IncreaseSyncTranslationContext incrSyncContext, InterfaceIncrSyncQueryContext queryContext) throws VMFException {
        HashSet<String> queryStatusAttributes = new HashSet<String>();
        queryStatusAttributes.add("ifAdminStatus");
        queryStatusAttributes.add("ifOperSpeed");
        queryStatusAttributes.add("ifOperStatus");
        HashSet<String> queryStatusAndIpAttributes = new HashSet<String>();
        queryStatusAndIpAttributes.add("ifAdminStatus");
        queryStatusAndIpAttributes.add("ifOperSpeed");
        queryStatusAndIpAttributes.add("ifOperStatus");
        queryStatusAndIpAttributes.add("ipv4Addresss");
        HashSet<String> queryIpAttributes = new HashSet<String>();
        queryIpAttributes.add("ipv4Addresss");
        HashMap<Interface, Interface> toBeRefreshInterfaces = new HashMap<Interface, Interface>();
        IMOChangeRecord interfaceRecord = incrSyncContext.getContext().getChangeRecord(Interface.class);
        for (Interface inf : interfaceRecord.getCreates()) {
            if (this.isAlwaysUpInterface(inf)) continue;
            queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)inf, queryStatusAttributes);
            toBeRefreshInterfaces.put(inf, inf);
        }
        Interface index = new Interface();
        IMOChangeRecord addressRecord = incrSyncContext.getContext().getChangeRecord(Ipv4Address.class);
        for (Ipv4Address ipAddress : addressRecord.getCreates()) {
            if (!ipAddress.getAddrType().equals(Ipv4Address.ADDR_TYPE_ENUM.UNNUMBER) && !ipAddress.getAddrType().equals(Ipv4Address.ADDR_TYPE_ENUM.NAP)) continue;
            index.setDevID(ipAddress.getDevID());
            index.setVrID(ipAddress.getVrID());
            index.setIfName(ipAddress.getIfName());
            Interface inf = (Interface)toBeRefreshInterfaces.get(index);
            if (inf != null) {
                queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)inf, queryStatusAndIpAttributes);
            } else {
                inf = (Interface)index.clone();
                queryContext.addQueryAttributes(null, (VmfMO)inf, queryIpAttributes);
                toBeRefreshInterfaces.put(inf, inf);
            }
            queryContext.addDecodeCache((VmfMO)ipAddress);
        }
    }

    private boolean isAlwaysUpInterface(Interface inf) {
        int type;
        int n = type = inf.getiQIfType() == null ? 0 : inf.getiQIfType();
        if (65562 == type || 1 == type) {
            inf.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.UP);
            inf.setIfOperStatus(Interface.IF_OPER_STATUS_ENUM.UP);
            return true;
        }
        return false;
    }

    private static class InterfaceIncrSyncQueryContext
    extends QuerySchemaTranslatorContext {
        private Ipv4Address unnumberedAddrss = new Ipv4Address();

        public InterfaceIncrSyncQueryContext(int devID) {
            super(devID);
        }

        public Object findPersistObject(Object object, INode node, ISchemaTranslationContext context) throws SchemaTransformException {
            if (object instanceof Ipv4Address && this.queryResult != null) {
                Ipv4Address address = (Ipv4Address)object;
                this.unnumberedAddrss.setDevID(address.getDevID());
                this.unnumberedAddrss.setVrID(address.getVrID());
                this.unnumberedAddrss.setIfName(address.getIfName());
                return this.queryResult.get(this.unnumberedAddrss);
            }
            return super.findPersistObject(object, node, context);
        }
    }
}

