/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.PortLicense;
import com.huawei.vmf.adapter.fservice.ifm.model.PortLicenseType;
import com.huawei.vmf.adapter.fservice.ifm.service.IPortLicenseService;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.common.CommonDefine;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.swimap.imap.common.asn1.common.AsnApplyLicenseReq;
import com.swimap.imap.common.asn1.common.AsnApplyLicenseReqSeqOf;
import com.swimap.imap.common.asn1.common.AsnApplyLicenseRsp;
import com.swimap.imap.common.asn1.common.LicenseApplyInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PortLicenseService
implements IPortLicenseService {
    private static final int APPLY_PORT_LICENSE = 1;
    private Logger logger = LoggerFactory.getLogger(PortLicenseService.class);
    private Collection<PortLicenseType> portLicenseTypes;

    public void applyPortLic(Collection<Interface> mos, int portLicChangeValue) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map<Integer, Map<String, Integer>> devPortLicsenceMap = this.countPotLic(mos, portLicChangeValue);
        HashMap<String, Integer> portLicsenceMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, Map<String, Integer>> entry : devPortLicsenceMap.entrySet()) {
            Map<String, Integer> tmpPortLicsenceMap = entry.getValue();
            for (Map.Entry<String, Integer> licsenceEntry : tmpPortLicsenceMap.entrySet()) {
                String licsenceType = licsenceEntry.getKey();
                Integer licsenceNum = licsenceEntry.getValue();
                Integer newLicsenceNum = portLicsenceMap.containsKey(licsenceType) ? (Integer)portLicsenceMap.get(licsenceType) + licsenceNum : licsenceNum;
                portLicsenceMap.put(licsenceType, newLicsenceNum);
            }
        }
        if (0 == this.applyPortLic(portLicsenceMap)) {
            this.persistPortLicData(devPortLicsenceMap);
        }
    }

    public void queryPortLic(AsnApplyLicenseReq req, AsnApplyLicenseRsp rsp) throws VMFException {
        Collection<Interface> unSupApplyPortLicInterfaces = this.getUnSupApplyPortLicInterfaces();
        Map<String, Integer> allPortLicNumMap = this.getAllPortLicNum();
        this.applyPortLic(unSupApplyPortLicInterfaces, 1);
        AsnApplyLicenseReqSeqOf oLicenseApplyInfos = req.oLicenseApplyInfo;
        for (Object object : oLicenseApplyInfos) {
            LicenseApplyInfo oLicenseApplyInfo = (LicenseApplyInfo)object;
            LicenseApplyInfo licenseApplyInfo = new LicenseApplyInfo();
            licenseApplyInfo.feature = oLicenseApplyInfo.feature;
            licenseApplyInfo.item = oLicenseApplyInfo.item;
            String portLicType = StringUtil.globalString((byte[])oLicenseApplyInfo.item);
            int licNum = allPortLicNumMap.containsKey(portLicType) ? allPortLicNumMap.get(portLicType) : 0;
            licenseApplyInfo.value = String.valueOf(licNum).getBytes();
            rsp.inventory.add((Object)licenseApplyInfo);
        }
        rsp.result = BigInteger.valueOf(0L);
    }

    public void releasePortLic(int devID) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        HashMap<String, Integer> allPortLicNumMap = new HashMap<String, Integer>();
        Collection portLicenses = dao.queryByNeID(PortLicense.class, Arrays.asList(devID), false);
        if (CollectionUtils.isEmpty((Collection)portLicenses)) {
            return;
        }
        for (PortLicense portLicense : portLicenses) {
            String licsenceType = portLicense.getLicsenceType();
            Integer licsenceNum = portLicense.getLicsenceNum();
            Integer newLicNum = -(allPortLicNumMap.containsKey(licsenceType) ? (Integer)allPortLicNumMap.get(licsenceType) + licsenceNum : licsenceNum);
            allPortLicNumMap.put(licsenceType, newLicNum);
        }
        this.applyPortLic(allPortLicNumMap);
    }

    private int applyPortLic(Map<String, Integer> portLicsenceMap) throws VMFException {
        if (CollectionUtils.isEmpty(portLicsenceMap)) {
            return 0;
        }
        AsnApplyLicenseReq applyLisenceReq = new AsnApplyLicenseReq();
        AsnApplyLicenseRsp applyLicenseRsp = new AsnApplyLicenseRsp();
        for (Map.Entry<String, Integer> licsenceEntry : portLicsenceMap.entrySet()) {
            if (0 == licsenceEntry.getValue()) continue;
            LicenseApplyInfo licenseApplyInfo = new LicenseApplyInfo();
            licenseApplyInfo.feature = "COMLIC".getBytes();
            licenseApplyInfo.item = licsenceEntry.getKey().getBytes();
            licenseApplyInfo.value = String.valueOf(licsenceEntry.getValue()).getBytes();
            applyLisenceReq.oLicenseApplyInfo.add((Object)licenseApplyInfo);
        }
        applyLisenceReq.forceApply = CommonDefine.PortLisence.LICSENCE_FORCE_APPLY_NUM;
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendSyncMessage('\u0bce', (byte)11, 11536329, (FStruct)applyLisenceReq, (FStruct)applyLicenseRsp);
        if (0 != result) {
            this.logger.error("applyPortLic fail.");
            return 1107499878;
        }
        return applyLicenseRsp.result.intValue();
    }

    private Map<Integer, Map<String, Integer>> countPotLic(Collection<Interface> mos, int portLicChangeValue) throws VMFException {
        HashMap<Integer, Map<String, Integer>> devPortLicsenceMap = new HashMap<Integer, Map<String, Integer>>();
        for (Interface mo : mos) {
            Integer devID = mo.getDevID();
            HashMap<String, Integer> portLicsenceMap = devPortLicsenceMap.containsKey(devID) ? (Map)devPortLicsenceMap.get(devID) : new HashMap();
            String ifName = mo.getIfName();
            if (this.isDevSupApplyPortLic(devID) && this.isPhyIf(ifName)) {
                this.storePortLic(mo, portLicsenceMap, portLicChangeValue);
            }
            devPortLicsenceMap.put(devID, portLicsenceMap);
        }
        return devPortLicsenceMap;
    }

    private Map<String, Integer> getAllPortLicNum() throws VMFException {
        HashMap<String, Integer> allPortLicNumMap = new HashMap<String, Integer>();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection portLicenses = dao.queryAll(PortLicense.class, false);
        for (PortLicense portLicense : portLicenses) {
            String licsenceType = portLicense.getLicsenceType();
            Integer licsenceNum = portLicense.getLicsenceNum();
            Integer newLicNum = allPortLicNumMap.containsKey(licsenceType) ? (Integer)allPortLicNumMap.get(licsenceType) + licsenceNum : licsenceNum;
            allPortLicNumMap.put(licsenceType, newLicNum);
        }
        return allPortLicNumMap;
    }

    private String getLicType(String ifName, String ifPhyType, int ifType, Long ifOperSpeed) throws VMFException {
        String licType = null;
        licType = CommonDefine.PortLisence.ETH_LICSENCE_MAP.containsKey(ifPhyType) ? CommonDefine.PortLisence.ETH_LICSENCE_MAP.get(ifPhyType) : (0 == ifName.indexOf("GigabitEthernet") && (ifOperSpeed <= CommonDefine.PortLisence.GE_PORT_MIN_SPEED || ifOperSpeed >= CommonDefine.PortLisence.GE_PORT_MAX_SPEED) ? (ifOperSpeed <= CommonDefine.PortLisence.GE_PORT_MIN_SPEED ? "LNSDEPSAP03" : "LNSDEPSAP05") : this.getLicTypeFromDB(ifType, ifOperSpeed));
        return licType;
    }

    private String getLicTypeFromDB(int ifType, Long ifOperSpeed) {
        String licType = null;
        if (null == this.portLicenseTypes) {
            try {
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                this.portLicenseTypes = dao.queryAll(PortLicenseType.class, false);
            }
            catch (VMFException e) {
                this.logger.error("getLicTypeFromDB is error.", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(this.portLicenseTypes)) {
            return null;
        }
        for (PortLicenseType portLicenseType : this.portLicenseTypes) {
            if (ifType != portLicenseType.getIfType() || ifOperSpeed < portLicenseType.getLowIfSpeed() || ifOperSpeed > portLicenseType.getHighIfSpeed()) continue;
            licType = portLicenseType.getLicenseType();
            break;
        }
        return licType;
    }

    private Collection<Interface> getUnSupApplyPortLicInterfaces() throws VMFException {
        ArrayList<Interface> unSupApplyPortLicInterfaces = new ArrayList<Interface>();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection interfaces = dao.queryAll(Interface.class, false);
        if (CollectionUtils.isEmpty((Collection)interfaces)) {
            return new ArrayList<Interface>();
        }
        for (Interface inf : interfaces) {
            if (this.isDevSupApplyPortLic(inf.getDevID())) continue;
            unSupApplyPortLicInterfaces.add(inf);
        }
        return unSupApplyPortLicInterfaces;
    }

    private boolean isDevSupApplyPortLic(int devID) {
        try {
            IDeviceService deviceService = Activator.getService(IDeviceService.class);
            DevSysInfo devSysInfo = deviceService.getDevSysInfo(devID);
            DevTypeInfo devTypeInfo = deviceService.getDevTypeInfoBySysOID(devSysInfo.getDevSysOID());
            if (null != devTypeInfo) {
                return 1 == devTypeInfo.getSupPortLic();
            }
            return true;
        }
        catch (VMFException e) {
            this.logger.error("isDevSupApplyPortLic error.", (Throwable)e);
            return false;
        }
    }

    private boolean isPhyIf(String ifName) {
        if (InterfaceUtil.isMainInterface(ifName)) {
            Set physicalInterfaceType = U2KInterfaceTypeMapping.getPhysicalInterfaceType();
            return physicalInterfaceType.contains(U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ifName));
        }
        return false;
    }

    private void persistPortLicData(Map<Integer, Map<String, Integer>> devPortLicsenceMap) throws VMFException {
        if (CollectionUtils.isEmpty(devPortLicsenceMap)) {
            return;
        }
        Context ctx = new Context();
        IMOChangeRecord changeRecord = ctx.addChangeRecord(PortLicense.class);
        for (Map.Entry<Integer, Map<String, Integer>> entry : devPortLicsenceMap.entrySet()) {
            Integer devID = entry.getKey();
            Map<String, Integer> licsenceMap = entry.getValue();
            for (Map.Entry<String, Integer> licsenceEntry : licsenceMap.entrySet()) {
                String licenseType = licsenceEntry.getKey();
                Integer licsenceNum = licsenceEntry.getValue();
                PortLicense portLicense = new PortLicense();
                portLicense.setDevID(devID);
                portLicense.setLicsenceType(licenseType);
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                Collection portLicenses = dao.queryByFields(PortLicense.class, new String[]{"devID", "licsenceNum"}, Arrays.asList(portLicense), false);
                if (CollectionUtils.isEmpty((Collection)portLicenses)) {
                    portLicense.setLicsenceNum(licsenceNum);
                    changeRecord.addCreate((Object)portLicense);
                    continue;
                }
                PortLicense portLicenseDB = (PortLicense)portLicenses.iterator().next();
                portLicenseDB.setLicsenceNum(Integer.valueOf(portLicenseDB.getLicsenceNum() + licsenceNum));
                changeRecord.addModify((Object)portLicenseDB, Arrays.asList("licsenceNum"));
            }
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        dao.merge(PortLicense.class, false);
    }

    private void storePortLic(Interface mo, Map<String, Integer> portLicsenceMap, int portLicChangeValue) throws VMFException {
        String ifName = mo.getIfName();
        if (ifName.contains("0/0/0")) {
            return;
        }
        Long operSpeed = mo.getIfOperSpeed();
        String licType = this.getLicType(ifName, mo.getIfPhyType(), mo.getiQIfType(), operSpeed);
        if (StringUtils.hasLength((String)licType)) {
            int licNum = portLicsenceMap.containsKey(licType) ? portLicsenceMap.get(licType) + portLicChangeValue : portLicChangeValue;
            portLicsenceMap.put(licType, licNum);
        }
    }
}

