/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.service;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnAPInfo;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSrvLink;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.service.IInterfaceServiceExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IIfmAssociateFunctionExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.AbstractIpAddress;
import com.huawei.vmf.adapter.fservice.ifm.model.ChannelSet;
import com.huawei.vmf.adapter.fservice.ifm.model.CposChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.FlowDot1q;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv6Address;
import com.huawei.vmf.adapter.fservice.ifm.model.Lag;
import com.huawei.vmf.adapter.fservice.ifm.model.LagMemberIf;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqTerminate;
import com.huawei.vmf.adapter.fservice.ifm.model.StmChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.ifm.view.InterfaceAndIpAddress;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.pwe3.model.L2vpnAc;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.vcluster.model.RemoteApIf;
import com.huawei.vmf.adapter.fservice.vcluster.model.VBridgeMemberIf;
import com.huawei.vmf.adapter.fservice.vcluster.model.VbridgeIf;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsAc;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import com.huawei.vmf.adapter.ifm.common.ErrorCode;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.sap.QAsnGetSap;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterfaceService
implements IInterfaceService {
    private static final int MAX_SUBIF_NUM = 4096;
    private int ENCAPSULATE_TYPE_ENUM_ETH = 5;
    private Logger logger = LoggerFactory.getLogger(InterfaceService.class);
    private static final Integer CHASSIC = 1;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final QAsnGetSap sapQuery = new QAsnGetSap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Interface> allocSubIf(Collection<Interface> mainIfMos) throws VMFException {
        ArrayList<Interface> subIfMos = new ArrayList<Interface>();
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            for (Interface mainIfMo : mainIfMos) {
                int ifNumber;
                if (null != mainIfMo.getIfName() && !InterfaceUtil.isMainInterface(mainIfMo.getIfName())) {
                    subIfMos.add(mainIfMo);
                    continue;
                }
                Interface firstNotSeqSubIf = this.queryFirstNotSeqSubIfByMainIf(mainIfMo);
                int n = ifNumber = null != firstNotSeqSubIf ? Integer.valueOf(firstNotSeqSubIf.getIfNumber()) + 1 : 1;
                if (ifNumber > 4096) {
                    throw new VMFException(1107499878, "auto Allot SubIf failed. if number is beyond MAX_SUBIF_NUM. MAX_SUBIF_NUM : 4096");
                }
                Interface subIf = new Interface();
                subIf.setDevID(mainIfMo.getDevID());
                subIf.setVrID(mainIfMo.getVrID());
                subIf.setIfName(mainIfMo.getIfName() + "." + ifNumber);
                subIf.setIfParentIfName(mainIfMo.getIfName());
                subIf.setIfNumber(String.valueOf(ifNumber));
                subIf.setIfPhyType(mainIfMo.getIfPhyType());
                subIf.setiQIfType(mainIfMo.getiQIfType());
                subIfMos.add(subIf);
            }
        }
        finally {
            readLock.unlock();
        }
        return subIfMos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployInterfaceForL3vpn(Collection<Interface> mos, Object ctx) throws VMFException {
        if (CollectionUtils.isEmpty(mos) || 65570 != U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mos.iterator().next().getIfName())) {
            return;
        }
        ArrayList<EthSubIf> createEthSubIfs = new ArrayList<EthSubIf>();
        try {
            for (Interface mo : mos) {
                List ethSubIfs = mo.getKeyRefMos(EthSubIf.class);
                DefaultMOService deployService = new DefaultMOService();
                NestingContext context = new NestingContext(mo.getDevID().intValue(), true);
                Set ctxEthSubInfos = ((Context)ctx).getChangeRecord(EthSubIf.class).getCreates();
                for (EthSubIf ethSubIf : ethSubIfs) {
                    if (CollectionUtils.isEmpty((Collection)ctxEthSubInfos)) {
                        context.addChangeRecord(EthSubIf.class).addModify((Object)ethSubIf, Arrays.asList("flowType", "dot1qBitmap"));
                        continue;
                    }
                    context.addChangeRecord(EthSubIf.class).addCreate((Object)ethSubIf);
                    createEthSubIfs.add(ethSubIf);
                }
                context.addFeatureMoType(FeatureName.ETHERNET, EthSubIf.class);
                deployService.addDeployJob(context);
                deployService.deploy();
            }
        }
        catch (Exception e) {
            this.logger.error("deployInterfaceForL3vpn error.", (Throwable)e);
        }
        finally {
            for (EthSubIf ethSubIf : createEthSubIfs) {
                ((Context)ctx).getChangeRecord(EthSubIf.class).cancelCreate((Object)ethSubIf);
            }
        }
    }

    private void shutdownSerial(VmfMO e1Mo, NestingContext context) {
        Interface serialMo = InterfaceUtil.transCposOrE1ToSerial(e1Mo);
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Interface serialindex = new Interface();
            serialindex.setDevID(serialMo.getDevID());
            serialindex.setVrID(serialMo.getVrID());
            serialindex.setIfName(serialMo.getIfName());
            Collection infs = dao.queryByKey(Interface.class, Arrays.asList(serialindex), false);
            if (!CollectionUtils.isEmpty((Collection)infs) && ((Interface)infs.iterator().next()).getIfAdminStatus().equals(Interface.IF_ADMIN_STATUS_ENUM.DOWN)) {
                return;
            }
            serialMo.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.DOWN);
            context.addChangeRecord(Interface.class).addModify((Object)serialMo, Arrays.asList("ifAdminStatus"));
            context.addFeatureMoType(FeatureName.IFM, Interface.class);
        }
        catch (VMFException e) {
            this.logger.error("shutdownSerial error." + (Object)((Object)e));
        }
    }

    public Collection<Interface> deployInterfaces(Collection<Interface> mos, Object ctx) throws VMFException {
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            IInterfaceServiceExtPoint interfaceService = (IInterfaceServiceExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceServiceExtPoint.class);
            return interfaceService.deployInterfaces(mos, ctx);
        }
        ArrayList<Interface> serialMos = new ArrayList<Interface>();
        for (Interface mo : mos) {
            Interface serialMo = this.deployInterfaces(mo, ctx);
            serialMo.setSerialNum(mo.getSerialNum());
            serialMos.add(serialMo);
        }
        return serialMos;
    }

    public Collection<Interface> enableSAP(Collection<QAsnUniResID> qasnUniResIDs) throws VMFException {
        return null;
    }

    public void getIfNameAndDevIDFromSAP(QAsnSAP asnSAP, int iDevID, String strIfName) throws VMFException {
        InterfaceFdnParser parser = new InterfaceFdnParser();
        Interface mo = parser.getIndexMo(StringUtil.globalString((byte[])asnSAP.ctpKey.strFDN));
        iDevID = mo.getDevID();
        strIfName = mo.getIfName();
    }

    public Collection<InterfaceAndIpAddress> getInterfaceInfo(Collection<InterfaceAndIpAddress> addresses) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        return dao.queryInterfaceByIp(addresses);
    }

    public Collection<Interface> getNeIfUniResIDList(Collection<QAsnUniResID> qasnUniResIDs) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        return dao.queryInterfaceByFdn(qasnUniResIDs);
    }

    public boolean isDeleteableIf(Interface mo) {
        if (null == mo) {
            return false;
        }
        Integer iType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        return U2KInterfaceTypeMapping.getLogicalInterfaceType().contains(iType) && !U2KInterfaceTypeMapping.getUndeleteableLogicIf().contains(iType);
    }

    public void loadInterfaceWithBoard(Collection<Interface> ifms) {
        if (null == ifms || ifms.isEmpty()) {
            this.logger.debug("query loadInterfaceWithBoard :ifms is no data ");
            return;
        }
        ArrayList<Port> portMos = new ArrayList<Port>();
        for (Interface ifm : ifms) {
            Port portInfo = new Port();
            portInfo.setDevID(ifm.getDevID());
            portInfo.setEntPosition(InterfaceUtil.getPositionFromInterfaceName(ifm.getIfName()));
            portMos.add(portInfo);
        }
        Collection resPorts = null;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = ((Port)portMos.iterator().next()).getClass();
        try {
            resPorts = dao.queryByKey(clazz, portMos, false);
        }
        catch (VMFException e) {
            this.logger.debug("query loadInterfaceWithBoard query port fail: " + (Object)((Object)e));
            return;
        }
        if (null == resPorts || resPorts.isEmpty()) {
            this.logger.debug("query loadInterfaceWithBoard :donot query port data ");
            return;
        }
        HashMap<Interface, Port> mapIfmtoPort = new HashMap<Interface, Port>();
        block5: for (Interface ifm : ifms) {
            int devID = ifm.getDevID();
            String entPosition = InterfaceUtil.getPositionFromInterfaceName(ifm.getIfName());
            if (null == entPosition) {
                entPosition = "";
            }
            for (Port resPort : resPorts) {
                if (devID != resPort.getDevID() || !entPosition.equals(resPort.getEntPosition())) continue;
                mapIfmtoPort.put(ifm, resPort);
                continue block5;
            }
        }
        ArrayList<Board> boardMos = new ArrayList<Board>();
        for (Port queryPort : resPorts) {
            Board queryBoard = new Board();
            queryBoard.setDevID(queryPort.getDevID());
            queryBoard.setChassisID(queryPort.getChassisID());
            queryBoard.setSlotID(queryPort.getSlotID());
            boardMos.add(queryBoard);
        }
        Class<?> boardClazz = ((Board)boardMos.iterator().next()).getClass();
        Collection resBoards = null;
        try {
            resBoards = dao.queryByKey(boardClazz, boardMos, false);
        }
        catch (VMFException e) {
            this.logger.debug("query loadInterfaceWithBoard query board fail: " + (Object)((Object)e));
            return;
        }
        if (null == resBoards || resBoards.isEmpty()) {
            this.logger.debug("query loadInterfaceWithBoard :donot query board data ");
            return;
        }
        HashMap<Port, Board> mapPorttoBoard = new HashMap<Port, Board>();
        block8: for (Port resPort : resPorts) {
            int devID = resPort.getDevID();
            int chassisID = resPort.getChassisID();
            int slotID = resPort.getSlotID();
            for (Board resBoard : resBoards) {
                if (devID != resBoard.getDevID() || chassisID != resBoard.getChassisID() || slotID != resBoard.getSlotID()) continue;
                mapPorttoBoard.put(resPort, resBoard);
                continue block8;
            }
        }
        for (Interface ifm : ifms) {
            Board board;
            Port port = (Port)mapIfmtoPort.get(ifm);
            if (null == port || null == (board = (Board)mapPorttoBoard.get(port))) continue;
            ifm.addKeyRefMo((VmfMO)board);
        }
    }

    public Collection<Interface> processSAP(Collection<Interface> interfaceKeys, Object context) throws VMFException {
        IAsnTranslationContext asnTranslationContext = (IAsnTranslationContext)context;
        Collection<Interface> ifs = this.sapQuery.queryByInterface(interfaceKeys);
        if (asnTranslationContext == null) {
            return ifs;
        }
        for (Interface ifinfo : ifs) {
            this.addMo2Context(asnTranslationContext.getTransactionContext(), asnTranslationContext.getOperType(), (VmfMO)ifinfo, false);
            for (Map.Entry entry : ifinfo.getKeyRefMos().entrySet()) {
                for (VmfMO keyRefMO : (List)entry.getValue()) {
                    this.addMo2Context(asnTranslationContext.getTransactionContext(), asnTranslationContext.getOperType(), keyRefMO, true);
                }
            }
        }
        List funSet = ExtendPointServiceMgr.getInstance().getExtendIfmFunction(IIfmAssociateFunctionExtPoint.class);
        if (!CollectionUtils.isEmpty((Collection)funSet)) {
            for (Object obj : funSet) {
                if (!(obj instanceof IIfmAssociateFunctionExtPoint)) continue;
                ((IIfmAssociateFunctionExtPoint)obj).processSAP(ifs, (IAsnTranslationContext)context);
            }
        }
        return ifs;
    }

    public void processVclusterIf(Interface interfaceKey, QAsnSAP sapAsn, Object context) throws VMFException {
        EOperationType operationType = EOperationType.CREATE;
        Integer key = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)interfaceKey.getIfName());
        if (65580 != key && 65581 != key) {
            return;
        }
        if (null == sapAsn.poOperMask) {
            return;
        }
        if ((1 == sapAsn.poOperMask || 3 == sapAsn.poOperMask) && null != sapAsn.poLinkProtocol && null != sapAsn.poLinkProtocol.poAPList && 6 == sapAsn.poLinkProtocol.type) {
            if (65580 == key) {
                VbridgeIf oVbridgeIf = new VbridgeIf();
                Collection<VbridgeIf> oBridgeIfs = this.queryVBridgeInfos(interfaceKey);
                if (null != oBridgeIfs && oBridgeIfs.size() > 0) {
                    operationType = EOperationType.MODIFY;
                }
                ArrayList<VBridgeMemberIf> memberInterfaces = new ArrayList<VBridgeMemberIf>();
                for (Object asnInfo : sapAsn.poLinkProtocol.poAPList) {
                    QAsnAPInfo apIfInfo = (QAsnAPInfo)asnInfo;
                    if (null == apIfInfo.poMasterInfName) {
                        this.logger.error("processVclusterIf apIfInfo.poMasterInfName is null. remoteAPName is. ");
                        continue;
                    }
                    VBridgeMemberIf oVbridgeMemberIf = new VBridgeMemberIf();
                    oVbridgeMemberIf.setDevID(interfaceKey.getDevID());
                    oVbridgeMemberIf.setMemberIfName(new String(apIfInfo.poMasterInfName));
                    oVbridgeMemberIf.setVbridgeIfName(interfaceKey.getIfName());
                    memberInterfaces.add(oVbridgeMemberIf);
                    RemoteApIf oRemoteApIf = new RemoteApIf();
                    oRemoteApIf.setDevID(interfaceKey.getDevID());
                    oRemoteApIf.setApIpAddr(new String(apIfInfo.remoteAPName));
                    oRemoteApIf.setApIfName(new String(apIfInfo.remoteAPInfName));
                    oRemoteApIf.setIfName(new String(apIfInfo.poMasterInfName));
                    this.deployRemoteApIf(oRemoteApIf, EOperationType.CREATE);
                }
                oVbridgeIf.setDevID(interfaceKey.getDevID());
                oVbridgeIf.setVbridgeIfName(interfaceKey.getIfName());
                oVbridgeIf.addVBridgeMemberIfs(memberInterfaces);
                this.deployVbridgeIf(oVbridgeIf, operationType);
            } else {
                for (Object asnInfo : sapAsn.poLinkProtocol.poAPList) {
                    QAsnAPInfo apIfInfo = (QAsnAPInfo)asnInfo;
                    RemoteApIf oRemoteApIf = new RemoteApIf();
                    oRemoteApIf.setDevID(interfaceKey.getDevID());
                    oRemoteApIf.setApIpAddr(new String(apIfInfo.remoteAPName));
                    oRemoteApIf.setApIfName(new String(apIfInfo.remoteAPInfName));
                    oRemoteApIf.setIfName(interfaceKey.getIfName());
                    this.deployRemoteApIf(oRemoteApIf, EOperationType.CREATE);
                }
            }
        } else if (2 == sapAsn.poOperMask) {
            operationType = EOperationType.DELETE;
            if (65580 == key) {
                VbridgeIf oVbridgeIf = null;
                Collection<VbridgeIf> oBridgeIfs = this.queryVBridgeInfos(interfaceKey);
                if (null == oBridgeIfs || 0 == oBridgeIfs.size()) {
                    return;
                }
                oVbridgeIf = oBridgeIfs.iterator().next();
                Collection<RemoteApIf> oRemoteApIfs = this.queryRemoteApInfos(oVbridgeIf);
                if (null != oRemoteApIfs) {
                    for (RemoteApIf oRemoteApIf : oRemoteApIfs) {
                        this.deployRemoteApIf(oRemoteApIf, operationType);
                    }
                }
                this.deployVbridgeIf(oVbridgeIf, operationType);
            } else {
                Collection<RemoteApIf> oRemoteApIfs = this.queryRemoteApInfos(interfaceKey);
                if (null != oRemoteApIfs && oRemoteApIfs.size() > 0) {
                    RemoteApIf oRemoteApIf = oRemoteApIfs.iterator().next();
                    this.deployRemoteApIf(oRemoteApIf, operationType);
                }
            }
        }
    }

    public EthernetPort queryEthernetPortInfoByPort(Port port) {
        if (null == port || 1025 != port.getPortType()) {
            return null;
        }
        ArrayList<EthernetPort> indexs = new ArrayList<EthernetPort>();
        EthernetPort index = new EthernetPort();
        index.setDevID(port.getDevID());
        index.setVrID(port.getVrID());
        index.setPosition(port.getEntPosition());
        indexs.add(index);
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            Collection ethList = dao.queryByKey(EthernetPort.class, indexs, false);
            if (!CollectionUtils.isEmpty((Collection)ethList)) {
                return (EthernetPort)ethList.iterator().next();
            }
        }
        catch (VMFException e) {
            this.logger.debug("InterfaceService queryEthernetPortInfoByPort is failed!" + (Object)((Object)e));
        }
        return null;
    }

    public Collection<Port> queryEthInfoListBySlot(int devID, Collection<Integer> slotList, Collection<Integer> typeList) throws VMFException {
        HashSet<Integer> tpyeSet = new HashSet<Integer>();
        if (!CollectionUtils.isEmpty(typeList)) {
            for (Integer type : typeList) {
                int portType = null == type ? 1025 : type;
                tpyeSet.add(portType);
            }
        } else {
            tpyeSet.add(1025);
        }
        ArrayList<Port> portMos = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(typeList)) {
            for (Integer slot : slotList) {
                Port portMo = new Port();
                portMo.setDevID(Integer.valueOf(devID));
                portMo.setVrID(Integer.valueOf(0));
                portMo.setChassisID(CHASSIC);
                portMo.setSlotID(slot);
                portMos.add(portMo);
            }
        } else {
            Port portMo = new Port();
            portMo.setDevID(Integer.valueOf(devID));
            portMo.setVrID(Integer.valueOf(0));
            portMos.add(portMo);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Class<?> portclazz = ((Port)portMos.iterator().next()).getClass();
        Collection portList = dao.queryByKey(portclazz, portMos, false);
        Interface ifMainMo = new Interface();
        ifMainMo.setDevID(Integer.valueOf(devID));
        ifMainMo.setVrID(Integer.valueOf(0));
        ArrayList<Interface> ifMos = new ArrayList<Interface>();
        ifMos.add(ifMainMo);
        Class<?> ifClazz = ((Interface)ifMos.iterator().next()).getClass();
        Collection ifList = dao.queryByKey(ifClazz, ifMos, false);
        ArrayList<Port> resList = null;
        if (!CollectionUtils.isEmpty((Collection)portList) && !CollectionUtils.isEmpty((Collection)ifList)) {
            resList = new ArrayList<Port>();
            for (Port portInfo : portList) {
                for (Interface ifInfo : ifList) {
                    if (!portInfo.getName().equals(ifInfo.getIfName()) || !tpyeSet.contains(ifInfo.getiQIfType())) continue;
                    resList.add(portInfo);
                    portInfo.addKeyRefMo((VmfMO)ifInfo);
                    ifInfo.addKeyRefMos(this.getSubIfInfo(ifInfo, ifList));
                }
            }
        }
        return resList;
    }

    public Collection<Port> queryEthInfoListBySlot(int devID, Integer slotID, Integer type) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        int portType = null == type ? 1025 : type;
        Port portMo = new Port();
        portMo.setDevID(Integer.valueOf(devID));
        portMo.setVrID(Integer.valueOf(0));
        portMo.setChassisID(CHASSIC);
        portMo.setSlotID(slotID);
        ArrayList<Port> portMos = new ArrayList<Port>();
        portMos.add(portMo);
        Class<?> portclazz = ((Port)portMos.iterator().next()).getClass();
        Collection portList = dao.queryByKey(portclazz, portMos, false);
        Interface ifMainMo = new Interface();
        ifMainMo.setDevID(Integer.valueOf(devID));
        ifMainMo.setVrID(Integer.valueOf(0));
        ArrayList<Interface> ifMos = new ArrayList<Interface>();
        ifMos.add(ifMainMo);
        Class<?> ifClazz = ((Interface)ifMos.iterator().next()).getClass();
        Collection ifList = dao.queryByKey(ifClazz, ifMos, false);
        ArrayList<Port> resList = null;
        if (!CollectionUtils.isEmpty((Collection)portList) && !CollectionUtils.isEmpty((Collection)ifList)) {
            resList = new ArrayList<Port>();
            for (Port portInfo : portList) {
                for (Interface ifInfo : ifList) {
                    if (!portInfo.getName().equals(ifInfo.getIfName()) || ifInfo.getiQIfType() != portType) continue;
                    resList.add(portInfo);
                    portInfo.addKeyRefMo((VmfMO)ifInfo);
                    ifInfo.addKeyRefMos(this.getSubIfInfo(ifInfo, ifList));
                }
            }
        }
        return resList;
    }

    public Collection<Port> queryEthPortListInL3VPNByNEID(int DevID) {
        Collection<Port> portList = this.queryPortInfosInL3VPNByNeIDAndDeployStatus(DevID, null);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (1025 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public Collection<Port> queryEthPortListInPWByNEID(int DevID) {
        ArrayList<VpwsInstance> indexes = new ArrayList<VpwsInstance>();
        VpwsInstance index = new VpwsInstance();
        index.setDevID(Integer.valueOf(DevID));
        index.setEncapsulateType(Integer.valueOf(this.ENCAPSULATE_TYPE_ENUM_ETH));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VpwsInstance.class, new String[]{"devID", "encapsulateType"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInPWByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (VpwsInstance ins : list) {
            Collection aclist = ins.getL2vpnAcs();
            if (CollectionUtils.isEmpty((Collection)aclist)) continue;
            for (L2vpnAc ac : aclist) {
                ethNameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Collection<Port> queryEthPortListInTunnelByNEID(int DevID) {
        ArrayList<StaticTunnel> indexes = new ArrayList<StaticTunnel>();
        StaticTunnel index = new StaticTunnel();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByKey(StaticTunnel.class, indexes, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInTunnelByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (StaticTunnel ins : list) {
            int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getIncomingIfName());
            int outIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getOutgoingIfName());
            if (1025 == inIfType && !ethNameList.contains(ins.getIncomingIfName())) {
                ethNameList.add(ins.getIncomingIfName());
                continue;
            }
            if (1025 != outIfType || ethNameList.contains(ins.getOutgoingIfName())) continue;
            ethNameList.add(ins.getOutgoingIfName());
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Collection<Port> queryEthPortListInVPLSByNEID(int DevID) {
        ArrayList<VplsInstance> indexes = new ArrayList<VplsInstance>();
        VplsInstance index = new VplsInstance();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VplsInstance.class, new String[]{"devID"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInPWByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (VplsInstance ins : list) {
            Collection aclist = ins.getVplsAcs();
            if (CollectionUtils.isEmpty((Collection)aclist)) continue;
            for (VplsAc ac : aclist) {
                ethNameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Collection<Port> queryEthPortListOfDeployInL3VPNByNEID(int DevID) {
        Collection<Port> portList = this.queryPortInfosInL3VPNByNeIDAndDeployStatus(DevID, 1);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (1025 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public Collection<Port> queryEthPortListOfDeployInPWByNEID(int DevID) {
        ArrayList<VpwsInstance> indexes = new ArrayList<VpwsInstance>();
        VpwsInstance index = new VpwsInstance();
        index.setDevID(Integer.valueOf(DevID));
        index.setEncapsulateType(Integer.valueOf(this.ENCAPSULATE_TYPE_ENUM_ETH));
        index.setDeployStatus(Integer.valueOf(1));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VpwsInstance.class, new String[]{"devID", "encapsulateType", "deployStatus"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInPWByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (VpwsInstance ins : list) {
            Collection aclist = ins.getL2vpnAcs();
            if (CollectionUtils.isEmpty((Collection)aclist)) continue;
            for (L2vpnAc ac : aclist) {
                ethNameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Collection<Port> queryEthPortListOfDeployInTunnelByNEID(int DevID) {
        ArrayList<StaticTunnel> indexes = new ArrayList<StaticTunnel>();
        StaticTunnel index = new StaticTunnel();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByKey(StaticTunnel.class, indexes, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInTunnelByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (StaticTunnel ins : list) {
            if (0 == ins.getDeployStatus()) continue;
            int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getIncomingIfName());
            int outIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getOutgoingIfName());
            if (1025 == inIfType && !ethNameList.contains(ins.getIncomingIfName())) {
                ethNameList.add(ins.getIncomingIfName());
                continue;
            }
            if (1025 != outIfType || ethNameList.contains(ins.getOutgoingIfName())) continue;
            ethNameList.add(ins.getOutgoingIfName());
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Collection<Port> queryEthPortListOfDeployInVPLSByNEID(int DevID) {
        ArrayList<VplsInstance> indexes = new ArrayList<VplsInstance>();
        VplsInstance index = new VplsInstance();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VplsInstance.class, new String[]{"devID"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInPWByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (VplsInstance ins : list) {
            Collection aclist;
            if (1 != ins.getDeployStatus() || CollectionUtils.isEmpty((Collection)(aclist = ins.getVplsAcs()))) continue;
            for (VplsAc ac : aclist) {
                ethNameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return ethList;
    }

    public Map<String, EthSubIf> queryEthSubIfInfoByFdn(Collection<String> fdnList) {
        if (CollectionUtils.isEmpty(fdnList)) {
            return null;
        }
        InterfaceFdnParser ifFdnParser = new InterfaceFdnParser();
        HashMap<String, EthSubIf> fdnMap = new HashMap<String, EthSubIf>();
        ArrayList<EthSubIf> indexs = new ArrayList<EthSubIf>();
        for (String fdn : fdnList) {
            Interface ifMo = ifFdnParser.getIndexMo(fdn);
            EthSubIf subIf = new EthSubIf();
            subIf.setDevID(ifMo.getDevID());
            subIf.setVrID(ifMo.getVrID());
            if (null == ifMo.getIfName() || ifMo.getIfName().isEmpty()) continue;
            subIf.setIfName(ifMo.getIfName());
            fdnMap.put(fdn, subIf);
            indexs.add(subIf);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection moDbs = null;
        try {
            moDbs = dao.queryByKey(EthSubIf.class, indexs, false);
        }
        catch (VMFException e) {
            this.logger.debug("InterfaceService queryEthSubIfInfoByFdn is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)moDbs)) {
            return null;
        }
        block3: for (Map.Entry entry : fdnMap.entrySet()) {
            EthSubIf subIf = (EthSubIf)entry.getValue();
            for (EthSubIf mo : moDbs) {
                if (!mo.equals((Object)subIf)) continue;
                subIf = mo;
                continue block3;
            }
        }
        return fdnMap;
    }

    public void queryIfNameByIfIndex(Map<Pair<Integer, Integer>, String> mapIfName) throws VMFException {
        if (mapIfName == null || 0 == mapIfName.size()) {
            return;
        }
        ArrayList<Interface> ifindexes = new ArrayList<Interface>(mapIfName.size());
        for (Map.Entry<Pair<Integer, Integer>, String> entry : mapIfName.entrySet()) {
            Interface ifindex = new Interface();
            ifindex.setDevID((Integer)entry.getKey().getKey());
            ifindex.setIfIndex(Long.valueOf(((Integer)entry.getKey().getValue()).longValue()));
            ifindexes.add(ifindex);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Collection iflist = dao.queryByFields(Interface.class, new String[]{"devID", "ifIndex"}, ifindexes, false);
        if (iflist.isEmpty()) {
            return;
        }
        for (Interface ifInfo : iflist) {
            Pair pairifindex = new Pair((Object)ifInfo.getDevID(), (Object)ifInfo.getIfIndex().intValue());
            mapIfName.put((Pair<Integer, Integer>)pairifindex, ifInfo.getIfName());
        }
    }

    public Map<String, Collection<Interface>> queryInterfaceInfoListByIP(Collection<String> ipList) {
        Interface index;
        if (CollectionUtils.isEmpty(ipList)) {
            return null;
        }
        ArrayList<Ipv4Address> ipv4Mos = new ArrayList<Ipv4Address>();
        for (String ipAddr : ipList) {
            Ipv4Address index2 = new Ipv4Address();
            index2.setIpAddr(ipAddr);
            ipv4Mos.add(index2);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Class<?> clazz = ((Ipv4Address)ipv4Mos.iterator().next()).getClass();
        String[] fieldNames = new String[]{"ipAddr"};
        Collection ipv4Infos = null;
        try {
            ipv4Infos = dao.queryByFields(clazz, fieldNames, ipv4Mos, false);
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoListByIP is fail: " + (Object)((Object)e));
            return null;
        }
        ArrayList<Ipv6Address> ipv6Mos = new ArrayList<Ipv6Address>();
        for (String ipAddr : ipList) {
            Ipv6Address index3 = new Ipv6Address();
            index3.setIpAddr(ipAddr);
            ipv6Mos.add(index3);
        }
        Class<?> v6clazz = ((Ipv6Address)ipv6Mos.iterator().next()).getClass();
        Collection ipv6Infos = null;
        try {
            ipv6Infos = dao.queryByFields(v6clazz, fieldNames, ipv6Mos, false);
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoListByIP is fail: " + (Object)((Object)e));
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)ipv4Infos) && CollectionUtils.isEmpty((Collection)ipv6Infos)) {
            return null;
        }
        ArrayList<Interface> ifMos = new ArrayList<Interface>();
        ArrayList<Ipv4Address> ipAddrList = new ArrayList<Ipv4Address>();
        if (!CollectionUtils.isEmpty((Collection)ipv4Infos)) {
            for (Ipv4Address ipAddr : ipv4Infos) {
                index = new Interface();
                index.setDevID(ipAddr.getDevID());
                index.setVrID(ipAddr.getVrID());
                index.setIfName(ipAddr.getIfName());
                ifMos.add(index);
                ipAddrList.add(ipAddr);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)ipv6Infos)) {
            for (Ipv4Address ipAddr : ipv6Infos) {
                index = new Interface();
                index.setDevID(ipAddr.getDevID());
                index.setVrID(ipAddr.getVrID());
                index.setIfName(ipAddr.getIfName());
                ifMos.add(index);
                ipAddrList.add(ipAddr);
            }
        }
        Class<?> ifClazz = ((Interface)ifMos.iterator().next()).getClass();
        Collection iFInfos = null;
        try {
            iFInfos = dao.queryByKey(ifClazz, ifMos, false);
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoListByIP is fail: " + (Object)((Object)e));
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)iFInfos)) {
            return null;
        }
        HashMap<String, Collection<Interface>> result = new HashMap<String, Collection<Interface>>();
        for (AbstractIpAddress abstractIpAddress : ipAddrList) {
            ArrayList<Interface> ifList = new ArrayList<Interface>();
            for (Interface ifInfo : iFInfos) {
                if (ifInfo.getDevID() != abstractIpAddress.getDevID() || ifInfo.getVrID() != abstractIpAddress.getVrID() || !ifInfo.getIfName().equals(abstractIpAddress.getIfName())) continue;
                ifList.add(ifInfo);
                break;
            }
            result.put(abstractIpAddress.getIpAddr(), ifList);
        }
        return result;
    }

    public Map<String, Collection<DevSysInfo>> queryInterfaceInfoListByLSRID(Collection<String> ipList) {
        if (CollectionUtils.isEmpty(ipList)) {
            return null;
        }
        ArrayList<MplsCommonCfg> indexMos = new ArrayList<MplsCommonCfg>();
        for (String mplsLsrID : ipList) {
            MplsCommonCfg index = new MplsCommonCfg();
            index.setMplsLsrID(mplsLsrID);
            indexMos.add(index);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Class<?> clazz = ((MplsCommonCfg)indexMos.iterator().next()).getClass();
        String[] fieldNames = new String[]{"mplsLsrID"};
        Collection mplsInfos = null;
        try {
            mplsInfos = dao.queryByFields(clazz, fieldNames, indexMos, false);
            if (CollectionUtils.isEmpty((Collection)mplsInfos)) {
                return null;
            }
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoListByLSRID is fail: " + (Object)((Object)e));
            return null;
        }
        ArrayList<DevSysInfo> devMos = new ArrayList<DevSysInfo>();
        for (MplsCommonCfg mplsCfg : mplsInfos) {
            DevSysInfo index = new DevSysInfo();
            index.setDevID(mplsCfg.getDevID());
            devMos.add(index);
        }
        Class<?> devClazz = ((DevSysInfo)devMos.iterator().next()).getClass();
        fieldNames = new String[]{"devID"};
        Collection devInfos = null;
        try {
            devInfos = dao.queryByFields(devClazz, fieldNames, devMos, false);
            if (CollectionUtils.isEmpty((Collection)devInfos)) {
                return null;
            }
        }
        catch (VMFException e) {
            this.logger.debug("query queryInterfaceInfoListByLSRID is fail: " + (Object)((Object)e));
            return null;
        }
        HashMap<String, Collection<DevSysInfo>> result = new HashMap<String, Collection<DevSysInfo>>();
        for (MplsCommonCfg mplsCfg : mplsInfos) {
            ArrayList<DevSysInfo> list = new ArrayList<DevSysInfo>();
            for (DevSysInfo devInfo : devInfos) {
                if (mplsCfg.getDevID() != devInfo.getDevID()) continue;
                list.add(devInfo);
                break;
            }
            result.put(mplsCfg.getMplsLsrID(), list);
        }
        return result;
    }

    public Collection<Lag> queryLagByMember(Collection<Interface> lstIf) throws VMFException {
        Class<?> memberClazz;
        if (CollectionUtils.isEmpty(lstIf)) {
            return null;
        }
        ArrayList<LagMemberIf> memberMos = new ArrayList<LagMemberIf>();
        for (Interface ifMo : lstIf) {
            LagMemberIf memberMo = new LagMemberIf();
            memberMo.setDevID(ifMo.getDevID());
            memberMo.setVrID(ifMo.getVrID());
            memberMo.setIfName(ifMo.getIfName());
            memberMos.add(memberMo);
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Collection lagMemberList = dao.queryByKey(memberClazz = ((LagMemberIf)memberMos.iterator().next()).getClass(), memberMos, false);
        if (CollectionUtils.isEmpty((Collection)lagMemberList)) {
            return null;
        }
        ArrayList<Lag> lagMos = new ArrayList<Lag>();
        for (LagMemberIf lagMemberMo : lagMemberList) {
            Lag lagMo = new Lag();
            lagMo.setDevID(lagMemberMo.getDevID());
            lagMo.setVrID(lagMemberMo.getVrID());
            lagMo.setLagID(lagMemberMo.getLagID());
            if (lagMos.contains(lagMo)) continue;
            lagMos.add(lagMo);
        }
        if (CollectionUtils.isEmpty(lagMos)) {
            return null;
        }
        Class<?> lagClazz = ((Lag)lagMos.iterator().next()).getClass();
        Collection lagList = dao.queryByKey(lagClazz, lagMos, false);
        if (CollectionUtils.isEmpty((Collection)lagList)) {
            return null;
        }
        return lagList;
    }

    public Collection<Port> queryMainEthPortListInLAGByNEID(int DevID) {
        Collection<Port> portList = this.queryEthPortListInLAGByNEID(DevID, true);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (1025 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public Collection<Interface> querySAP(List<QAsnUniResID> lstkey) throws VMFException {
        return this.sapQuery.query(lstkey);
    }

    public int querySAPServiceType(List<QAsnUniResID> lstkey) throws VMFException {
        return 0;
    }

    public Collection<Interface> querySAPStatus(List<QAsnUniResID> lstkey) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        return dao.querySapByFdn(lstkey);
    }

    public Collection<Port> querySlaveEthPortListInLAGByNEID(int DevID) {
        Collection<Port> portList = this.queryEthPortListInLAGByNEID(DevID, false);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (1025 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public StmPort queryStmPortInfoByPort(Port port) {
        if (null == port || 2049 != port.getPortType()) {
            return null;
        }
        ArrayList<StmPort> indexs = new ArrayList<StmPort>();
        StmPort index = new StmPort();
        index.setDevID(port.getDevID());
        index.setVrID(port.getVrID());
        index.setPosition(port.getEntPosition());
        indexs.add(index);
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            Collection stmList = dao.queryByKey(StmPort.class, indexs, true);
            if (!CollectionUtils.isEmpty((Collection)stmList)) {
                return (StmPort)stmList.iterator().next();
            }
        }
        catch (VMFException e) {
            this.logger.debug("InterfaceService queryStmPortInfoByPort is failed!" + (Object)((Object)e));
        }
        return null;
    }

    public Collection<Port> queryStmPortInfoWithSerialByNEID(int devID) {
        ArrayList<StmChannel> indexes = new ArrayList<StmChannel>();
        StmChannel index = new StmChannel();
        index.setDevID(Integer.valueOf(devID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByKey(StmChannel.class, indexes, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryStmPortInfoWithSerialByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> positionList = new ArrayList<String>();
        for (StmChannel serial : list) {
            int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)serial.getChannelIfName());
            if (65543 != inIfType || positionList.contains(serial.getPosition())) continue;
            positionList.add(serial.getPosition());
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndPositionList(devID, positionList);
        return ethList;
    }

    public Collection<Port> queryStmPortListInCESByNEID(int DevID) {
        ArrayList<VpwsInstance> indexes = new ArrayList<VpwsInstance>();
        VpwsInstance index = new VpwsInstance();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VpwsInstance.class, new String[]{"devID"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryStmPortListInCESByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (VpwsInstance ins : list) {
            Collection aclist = ins.getL2vpnAcs();
            if (CollectionUtils.isEmpty((Collection)aclist)) continue;
            for (L2vpnAc ac : aclist) {
                int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ac.getInterfaceName());
                if (!this.isSDHPort(inIfType)) continue;
                nameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, nameList);
        return ethList;
    }

    public Collection<Port> queryStmPortListInL3VPNByNEID(int DevID) {
        Collection<Port> portList = this.queryPortInfosInL3VPNByNeIDAndDeployStatus(DevID, null);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (2049 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public Collection<Port> queryStmPortListInTunnelByNEID(int DevID) {
        ArrayList<StaticTunnel> indexes = new ArrayList<StaticTunnel>();
        StaticTunnel index = new StaticTunnel();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByKey(StaticTunnel.class, indexes, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInTunnelByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (StaticTunnel ins : list) {
            int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getIncomingIfName());
            int outIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getOutgoingIfName());
            if (this.isSDHPort(inIfType) && !ethNameList.contains(ins.getIncomingIfName())) {
                ethNameList.add(ins.getIncomingIfName());
                continue;
            }
            if (!this.isSDHPort(outIfType) || ethNameList.contains(ins.getOutgoingIfName())) continue;
            ethNameList.add(ins.getOutgoingIfName());
        }
        Collection<Port> stmList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return stmList;
    }

    public Collection<Port> queryStmPortListOfDeployInCESByNEID(int DevID) {
        ArrayList<VpwsInstance> indexes = new ArrayList<VpwsInstance>();
        VpwsInstance index = new VpwsInstance();
        index.setDevID(Integer.valueOf(DevID));
        index.setDeployStatus(Integer.valueOf(1));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(VpwsInstance.class, new String[]{"devID", "deployStatus"}, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryStmPortListOfDeployInCESByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (VpwsInstance ins : list) {
            Collection aclist = ins.getL2vpnAcs();
            if (CollectionUtils.isEmpty((Collection)aclist)) continue;
            for (L2vpnAc ac : aclist) {
                int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ac.getInterfaceName());
                if (!this.isSDHPort(inIfType)) continue;
                nameList.add(ac.getInterfaceName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(DevID, nameList);
        return ethList;
    }

    public Collection<Port> queryStmPortListOfDeployInL3VPNByNEID(int DevID) {
        Collection<Port> portList = this.queryPortInfosInL3VPNByNeIDAndDeployStatus(DevID, 1);
        ArrayList<Port> returnData = new ArrayList<Port>();
        if (!CollectionUtils.isEmpty(portList)) {
            for (Port port : portList) {
                if (2049 != port.getPortType()) continue;
                returnData.add(port);
            }
        }
        return returnData;
    }

    public Collection<Port> queryStmPortListOfDeployInTunnelByNEID(int DevID) {
        ArrayList<StaticTunnel> indexes = new ArrayList<StaticTunnel>();
        StaticTunnel index = new StaticTunnel();
        index.setDevID(Integer.valueOf(DevID));
        indexes.add(index);
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByKey(StaticTunnel.class, indexes, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInTunnelByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> ethNameList = new ArrayList<String>();
        for (StaticTunnel ins : list) {
            if (0 == ins.getDeployStatus()) continue;
            int inIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getIncomingIfName());
            int outIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ins.getOutgoingIfName());
            if (this.isSDHPort(inIfType) && !ethNameList.contains(ins.getIncomingIfName())) {
                ethNameList.add(ins.getIncomingIfName());
                continue;
            }
            if (!this.isSDHPort(outIfType) || ethNameList.contains(ins.getOutgoingIfName())) continue;
            ethNameList.add(ins.getOutgoingIfName());
        }
        Collection<Port> stmList = this.getPortInfosByNeIDAndNameList(DevID, ethNameList);
        return stmList;
    }

    public Map<String, Collection<Interface>> querySubInfoListByMainIf(Collection<String> fdnList) throws VMFException {
        if (CollectionUtils.isEmpty(fdnList)) {
            return null;
        }
        InterfaceFdnParser ifFdnParser = new InterfaceFdnParser();
        ArrayList<Interface> indexMos = new ArrayList<Interface>();
        HashSet<Interface> mainInMos = new HashSet<Interface>();
        for (String fdn : fdnList) {
            Interface mainIfMo = ifFdnParser.getIndexMo(fdn);
            if (null == mainIfMo.getIfName() || mainIfMo.getIfName().isEmpty()) continue;
            mainInMos.add(mainIfMo);
            Interface subIfMo = new Interface();
            subIfMo.setDevID(mainIfMo.getDevID());
            subIfMo.setVrID(mainIfMo.getVrID());
            subIfMo.setIfParentIfName(mainIfMo.getIfName());
            indexMos.add(subIfMo);
        }
        Class<?> clazz = ((Interface)indexMos.iterator().next()).getClass();
        String[] fieldNames = new String[]{"devID", "vrID", "ifParentIfName"};
        Collection resIfms = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            resIfms = dao.queryByFields(clazz, fieldNames, indexMos, false);
            if (CollectionUtils.isEmpty((Collection)resIfms)) {
                return null;
            }
        }
        catch (VMFException e) {
            this.logger.debug("query querySubInfoListByMainIf is fail: " + (Object)((Object)e));
            return null;
        }
        HashMap<String, Collection<Interface>> resMap = new HashMap<String, Collection<Interface>>();
        for (Interface mainIf : mainInMos) {
            ArrayList<Interface> subIfs = new ArrayList<Interface>();
            for (Interface subIf : resIfms) {
                if (!mainIf.getIfName().equals(subIf.getIfParentIfName())) continue;
                subIfs.add(subIf);
            }
            resMap.put(mainIf.getFdn(), subIfs);
        }
        return resMap;
    }

    public void reloadTerminationData(Object context) {
        IAsnTranslationContext asnTranslationContext = (IAsnTranslationContext)context;
        this.reloadTerminationData(QinqTerminate.class, asnTranslationContext.getTransactionContext());
        this.reloadTerminationData(FlowDot1q.class, asnTranslationContext.getTransactionContext());
    }

    public Boolean setIpAddressByIfmMo(Interface mo) throws VMFException {
        if (null == mo || CollectionUtils.isEmpty((Collection)mo.getIpv4Addresss())) {
            this.logger.debug("InterfaceService setIpAddressByIfmMo fail! mo or ipaddr is null");
            return false;
        }
        Collection ipv4s = mo.getIpv4Addresss();
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        asnTranslationContext.setOperType(EOperationType.MODIFY);
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        context.setBestEffort(true);
        IMOChangeRecord ipRecorder = context.addChangeRecord(Ipv4Address.class);
        ipRecorder.addCreate(ipv4s);
        IMOChangeRecord recorder = asnTranslationContext.getTransactionContext().addChangeRecord(mo.getClass());
        recorder.addModify((Object)mo, new PropertyChangeItem("ipv4Addresss"));
        context.getOperResult().addMoOperResults((Collection)context.getChangeRecord(Interface.class).getAllChanges(), 1107499884);
        this.executeService(context, (ICompositeService)new DefaultCompositeService(Interface.class), (IAsnTranslationContext)asnTranslationContext);
        if (context.getOperResult().hasFailed()) {
            return false;
        }
        return true;
    }

    public Collection<Interface> unDeployInterfaces(Collection<Interface> mos, Object ctx) throws VMFException {
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            IInterfaceServiceExtPoint interfaceService = (IInterfaceServiceExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceServiceExtPoint.class);
            return interfaceService.unDeployInterfaces(mos, ctx);
        }
        ArrayList<Interface> resultMos = new ArrayList<Interface>();
        for (Interface mo : mos) {
            Interface reslutMo = this.unDeployInterfaces(mo);
            resultMos.add(reslutMo);
        }
        return resultMos;
    }

    public Boolean verifySAP(Collection<QAsnSAP> asnPriserviceSAPList, Collection<QAsnSAP> asnSAPList, Collection<QAsnSrvLink> asnSrvLinkList) {
        return Boolean.FALSE;
    }

    private void addKeyRef2MainMo(VmfMO mainMo, VmfMO mo, EOperationType operType, Context cxt) {
        if (mainMo == null) {
            return;
        }
        mainMo.addKeyRefMo(mo);
        IMOChangeRecord rcd = cxt.addChangeRecord(mainMo.getClass());
        switch (operType) {
            case DEPLOY: {
                if (rcd.isCreated((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case UNDEPLOY: {
                if (rcd.isDeleted((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case DELETE: {
                break;
            }
        }
    }

    private void addMo2Context(Context cxt, EOperationType operType, VmfMO mo, boolean isKeyRef) {
        Class<?> clazz = mo.getClass();
        switch (operType) {
            case CREATE: 
            case PREDEPLOY: {
                cxt.addChangeRecord(clazz).addCreate((Object)mo);
                break;
            }
            case DEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (Integer.valueOf(1).equals(((DeployableMO)mo).getDeployStatus())) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(1));
                    cxt.addDBChangeRecord(clazz).addModify((Object)mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
                }
                this.processDeployMo(mo);
                cxt.addChangeRecord(clazz).addCreate((Object)mo);
                break;
            }
            case UNDEPLOY: {
                if (isKeyRef) break;
                if (mo instanceof DeployableMO) {
                    if (!((DeployableMO)mo).getDeployStatus().equals(1)) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(0));
                    cxt.addDBChangeRecord(clazz).addModify((Object)mo, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
                }
                cxt.addChangeRecord(clazz).addDelete((Object)mo);
                break;
            }
            case DELETE: {
                if (isKeyRef) {
                    cxt.addDBChangeRecord(clazz).addDelete((Object)mo);
                    break;
                }
                cxt.addChangeRecord(clazz).addDelete((Object)mo);
                break;
            }
            case GET: {
                break;
            }
            case MODIFY: {
                if (!(mo instanceof EthSubIf)) break;
                Collection ethSubIfs = null;
                try {
                    ethSubIfs = DaoFactory.getInstance().getDefaultVmfDao(null).queryByKey(EthSubIf.class, Arrays.asList((EthSubIf)mo), false);
                }
                catch (VMFException e) {
                    this.logger.error("addMo2Context failed, InstantiationException error. ", (Throwable)e);
                }
                if (!CollectionUtils.isEmpty(ethSubIfs)) break;
                cxt.addChangeRecord(clazz).addCreate((Object)mo);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void deployCops(VmfMO cposMo, EOperationType operationType) throws VMFException {
        try {
            DefaultMOService deployService = new DefaultMOService();
            NestingContext context = new NestingContext(cposMo.getDevID().intValue(), true);
            E1t1 e1t1 = (E1t1)((CposPort)cposMo).getE1t1s().iterator().next();
            CposChannel cposChannel = (CposChannel)e1t1.getCposChannels().iterator().next();
            context.addChangeRecord(CposPort.class).addModify((Object)((CposPort)cposMo), new PropertyChangeItem("position"));
            context.addChangeRecord(E1t1.class).addModify((Object)e1t1, new PropertyChangeItem("e1t1Number"));
            if (operationType == EOperationType.CREATE) {
                context.addChangeRecord(CposChannel.class).addCreate((Object)cposChannel);
                if (e1t1.getWorkMode().equals(E1t1.WORK_MODE_ENUM.UNFRAMED)) {
                    context.getChangeRecord(E1t1.class).addModify((Object)e1t1, new PropertyChangeItem("workMode"));
                }
            } else {
                this.shutdownSerial(cposMo, context);
                context.addChangeRecord(CposChannel.class).addDelete((Object)cposChannel);
                if (e1t1.getWorkMode().equals(E1t1.WORK_MODE_ENUM.UNFRAMED)) {
                    e1t1.setWorkMode(E1t1.WORK_MODE_ENUM.FRAMED);
                    context.getChangeRecord(E1t1.class).addModify((Object)e1t1, new PropertyChangeItem("workMode"));
                }
            }
            context.addFeatureMoType(FeatureName.DEVM, CposPort.class);
            deployService.addDeployJob(context);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    private void deployCopsOrE1(VmfMO cposOrE1Mo, EOperationType operationType) throws VMFException {
        if (null == cposOrE1Mo) {
            return;
        }
        if (cposOrE1Mo.getClass().equals(CposPort.class)) {
            this.deployCops(cposOrE1Mo, operationType);
        } else {
            this.deployE1(cposOrE1Mo, operationType);
        }
    }

    private void deployE1(VmfMO e1Mo, EOperationType operationType) throws VMFException {
        try {
            DefaultMOService deployService = new DefaultMOService();
            NestingContext context = new NestingContext(e1Mo.getDevID().intValue(), true);
            ChannelSet channelSet = (ChannelSet)((E1t1Port)e1Mo).getChannelSets().iterator().next();
            context.addChangeRecord(E1t1Port.class).addModify((Object)((E1t1Port)e1Mo), new PropertyChangeItem("position"));
            if (operationType == EOperationType.CREATE) {
                context.addChangeRecord(ChannelSet.class).addCreate((Object)channelSet);
                if (((E1t1Port)e1Mo).getWorkMode().equals(E1t1.WORK_MODE_ENUM.UNFRAMED)) {
                    context.getChangeRecord(E1t1Port.class).addModify((Object)((E1t1Port)e1Mo), new PropertyChangeItem("workMode"));
                }
            } else {
                this.shutdownSerial(e1Mo, context);
                context.addChangeRecord(ChannelSet.class).addDelete((Object)channelSet);
                if (((E1t1Port)e1Mo).getWorkMode().equals(E1t1.WORK_MODE_ENUM.UNFRAMED)) {
                    ((E1t1Port)e1Mo).setWorkMode(E1t1.WORK_MODE_ENUM.FRAMED);
                    context.getChangeRecord(E1t1Port.class).addModify((Object)((E1t1Port)e1Mo), new PropertyChangeItem("workMode"));
                }
            }
            context.addFeatureMoType(FeatureName.DEVM, E1t1Port.class);
            deployService.addDeployJob(context);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    private Interface deployInterfaces(Interface mo, Object ctx) throws VMFException {
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        if (65543 == ifType) {
            return this.deploySerial(mo);
        }
        VmfMO cposOrE1Mo = this.getCposOrE1Mo(mo);
        if (null == cposOrE1Mo) {
            return mo;
        }
        ((Context)ctx).getChangeRecord(Interface.class).clear();
        Interface serialMoIndex = InterfaceUtil.transCposOrE1ToSerial(cposOrE1Mo);
        Collection<Interface> serialMoDevs = this.querySerialMos(serialMoIndex);
        if (!CollectionUtils.isEmpty(serialMoDevs)) {
            Interface serialMoDev = serialMoDevs.iterator().next();
            this.deploySerialTdm(serialMoDev);
            this.updateSerialMo(serialMoDev, EOperationType.CREATE);
            return serialMoDev;
        }
        this.deployCopsOrE1(cposOrE1Mo, EOperationType.CREATE);
        serialMoDevs = this.querySerialMos(serialMoIndex);
        if (CollectionUtils.isEmpty(serialMoDevs)) {
            throw new VMFException(ErrorCode.EML_NEIF_ERROR_SERIAL_NOT_EXIST.intValue(), "serial is not exist in the device.");
        }
        Interface serialMoDev = serialMoDevs.iterator().next();
        this.deploySerialTdm(serialMoDev);
        InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
        serialMoDev.setFdn(interfaceFdnParser.getFdn(serialMoDev));
        this.updateSerialMo(serialMoDev, EOperationType.CREATE);
        return serialMoDev;
    }

    private void deployRemoteApIf(RemoteApIf oRemoteApIf, EOperationType operationType) throws VMFException {
        this.logger.error("deployRemoteApIf enter, oRemoteApIf is " + oRemoteApIf.getIfName() + " operationType is" + operationType);
        try {
            DefaultMOService deployService = new DefaultMOService();
            NestingContext context = new NestingContext(oRemoteApIf.getDevID().intValue(), true);
            if (operationType == EOperationType.CREATE) {
                context.addChangeRecord(RemoteApIf.class).addCreate((Object)oRemoteApIf);
            } else if (operationType == EOperationType.DELETE) {
                context.addChangeRecord(RemoteApIf.class).addDelete((Object)oRemoteApIf);
            }
            context.addFeatureMoType(FeatureName.VCLUSTER, RemoteApIf.class);
            deployService.addDeployJob(context);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    private Interface deploySerial(Interface serialMo) throws VMFException {
        Interface serialMoIndex = new Interface();
        serialMoIndex.setDevID(serialMo.getDevID());
        serialMoIndex.setVrID(serialMo.getVrID());
        serialMoIndex.setIfName(serialMo.getIfName());
        Collection<Interface> serialMoDevs = this.querySerialMos(serialMoIndex);
        if (CollectionUtils.isEmpty(serialMoDevs)) {
            throw new VMFException(ErrorCode.EML_NEIF_ERROR_SERIAL_NOT_EXIST.intValue(), "serial is not exist in the device.");
        }
        Interface serialMoDev = serialMoDevs.iterator().next();
        this.deploySerialTdm(serialMoDev);
        this.updateSerialMo(serialMoDev, EOperationType.MODIFY);
        return serialMoDev;
    }

    private void deploySerialTdm(Interface serialMo) throws VMFException {
        try {
            DefaultMOService deployService = new DefaultMOService();
            NestingContext context = new NestingContext(serialMo.getDevID().intValue(), false);
            serialMo.setIfLinkProtocol(Interface.IF_LINK_PROTOCOL_ENUM.TDM);
            context.addChangeRecord(Interface.class).addModify((Object)serialMo, Arrays.asList("ifLinkProtocol"));
            context.addFeatureMoType(FeatureName.IFM, Interface.class);
            deployService.addDeployJob(context);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.logger.error("deploy serial error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    private void deployVbridgeIf(VbridgeIf oVbridgeIf, EOperationType operationType) throws VMFException {
        this.logger.error("deployVbridgeIf enter, oVbridgeIf is " + oVbridgeIf.getVbridgeIfName() + " operationType is" + operationType);
        try {
            DefaultMOService deployService = new DefaultMOService();
            NestingContext context = new NestingContext(oVbridgeIf.getDevID().intValue(), true);
            if (operationType == EOperationType.CREATE) {
                context.addChangeRecord(VbridgeIf.class).addCreate((Object)oVbridgeIf);
                for (VBridgeMemberIf oVBridgeMemberIf : oVbridgeIf.getVBridgeMemberIfs()) {
                    context.addChangeRecord(VBridgeMemberIf.class).addCreate((Object)oVBridgeMemberIf);
                }
            } else if (operationType == EOperationType.DELETE) {
                for (VBridgeMemberIf oVBridgeMemberIf : oVbridgeIf.getVBridgeMemberIfs()) {
                    context.addChangeRecord(VBridgeMemberIf.class).addDelete((Object)oVBridgeMemberIf);
                }
                context.addChangeRecord(VbridgeIf.class).addModify((Object)oVbridgeIf, new PropertyChangeItem("vBridgeMemberIfs"));
            } else if (operationType == EOperationType.MODIFY) {
                for (VBridgeMemberIf oVBridgeMemberIf : oVbridgeIf.getVBridgeMemberIfs()) {
                    context.addChangeRecord(VBridgeMemberIf.class).addCreate((Object)oVBridgeMemberIf);
                }
                context.addChangeRecord(VbridgeIf.class).addModify((Object)oVbridgeIf, new PropertyChangeItem("vBridgeMemberIfs"));
            }
            context.addFeatureMoType(FeatureName.VCLUSTER, VbridgeIf.class);
            deployService.addDeployJob(context);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    private void executeService(Context context, ICompositeService compositeService, IAsnTranslationContext asnTranslationContext) {
        context.addProperty(EOperationType.class.getName(), (Object)asnTranslationContext.getOperType());
        switch (asnTranslationContext.getOperType()) {
            case CREATE: {
                compositeService.create(context);
                break;
            }
            case DELETE: {
                compositeService.delete(context);
                break;
            }
            case DEPLOY: {
                compositeService.deploy(context);
                break;
            }
            case MODIFY: {
                compositeService.modify(context);
                break;
            }
            case PREDEPLOY: {
                compositeService.predeploy(context);
                break;
            }
            case UNDEPLOY: {
                compositeService.undeploy(context);
                break;
            }
            default: {
                this.logger.info("InterfaceService setIpAddressByIfmMo fail :OperType is invalidate. operType=" + asnTranslationContext.getOperType());
            }
        }
    }

    private VmfMO getCposOrE1Mo(Interface mo) {
        if (null == mo) {
            return null;
        }
        Class clazz = InterfaceUtil.getCesClass(mo);
        List keyRefMos = mo.getKeyRefMos(clazz);
        if (CollectionUtils.isEmpty((Collection)keyRefMos)) {
            return null;
        }
        return (VmfMO)keyRefMos.iterator().next();
    }

    private Collection<Port> getPortInfosByNeIDAndNameList(int devID, Collection<String> nameList) {
        if (CollectionUtils.isEmpty(nameList)) {
            return null;
        }
        ArrayList<Port> indexs = new ArrayList<Port>();
        for (String ifName : nameList) {
            Port port = new Port();
            port.setDevID(Integer.valueOf(devID));
            port.setName(ifName);
            indexs.add(port);
        }
        Collection portInfos = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            portInfos = dao.queryByFields(Port.class, new String[]{"devID", "name"}, indexs, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query getEthPortInfosByNeIDAndNameList is failed!" + (Object)((Object)e));
        }
        return portInfos;
    }

    private Collection<Port> getPortInfosByNeIDAndPositionList(int devID, Collection<String> positionList) {
        if (CollectionUtils.isEmpty(positionList)) {
            return null;
        }
        ArrayList<Port> indexs = new ArrayList<Port>();
        for (String position : positionList) {
            Port port = new Port();
            port.setDevID(Integer.valueOf(devID));
            port.setEntPosition(position);
            indexs.add(port);
        }
        Collection portInfos = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            portInfos = dao.queryByFields(Port.class, new String[]{"devID", "entPosition"}, indexs, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query getPortInfosByNeIDAndPositionList is failed!" + (Object)((Object)e));
        }
        return portInfos;
    }

    private Interface getSerialMo(Interface mo) {
        if (null == mo) {
            return null;
        }
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        if (65543 == ifType) {
            return mo;
        }
        return null;
    }

    private Collection<Interface> getSubIfInfo(Interface ifInfo, Collection<Interface> ifList) {
        ArrayList<Interface> subIfs = new ArrayList<Interface>();
        for (Interface subIfInfo : ifList) {
            if (!ifInfo.getIfName().equals(subIfInfo.getIfParentIfName())) continue;
            subIfs.add(subIfInfo);
        }
        return subIfs;
    }

    private boolean isSDHPort(int type) {
        return 2049 == type;
    }

    private void processDeployMo(VmfMO mo) {
        if (null == mo || !(mo instanceof Interface)) {
            return;
        }
        Interface ifMo = (Interface)mo;
        ifMo.setIfLinkProtocol(null);
        ifMo.setIfPhyType(null);
        ifMo.setIfRouterType(null);
        ifMo.setAutoLinkLocal(null);
        ifMo.setIpv6Enable(null);
        ifMo.setIfMac(null);
    }

    private Collection<Port> queryEthPortListInLAGByNEID(int devID, boolean isActorBearService) {
        ArrayList<LagMemberIf> indexes = new ArrayList<LagMemberIf>();
        LagMemberIf index = new LagMemberIf();
        index.setDevID(Integer.valueOf(devID));
        indexes.add(index);
        String[] fields = new String[]{"devID"};
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(LagMemberIf.class, fields, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInLAGByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<Interface> ifmIndexs = new ArrayList<Interface>();
        for (LagMemberIf lagMem : list) {
            Interface ifm = new Interface();
            ifm.setDevID(Integer.valueOf(devID));
            ifm.setIfName(lagMem.getIfName());
            ifm.setIsActorBearSrv(Boolean.valueOf(isActorBearService));
            ifmIndexs.add(ifm);
        }
        Collection ifmlist = null;
        String[] ifmFields = new String[]{"devID", "isActorBearSrv"};
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            ifmlist = dao.queryByFields(Interface.class, ifmFields, ifmIndexs, false);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInLAGByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)ifmlist)) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Interface member : ifmlist) {
            if (nameList.contains(member.getIfName())) continue;
            nameList.add(member.getIfName());
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(devID, nameList);
        return ethList;
    }

    private Interface queryFirstNotSeqSubIfByMainIf(Interface mainIfMo) throws VMFException {
        if (null == mainIfMo) {
            return null;
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        ArrayList<Interface> indexs = new ArrayList<Interface>();
        indexs.add(mainIfMo);
        HashMap<Integer, Interface> subIfMap = new HashMap<Integer, Interface>();
        Collection<Interface> subIfMos = dao.querySubIfByMainIf((List<Interface>)indexs);
        if (!CollectionUtils.isEmpty(subIfMos)) {
            for (Interface subIf : subIfMos) {
                subIfMap.put(Integer.valueOf(subIf.getIfNumber()), subIf);
            }
        }
        ArrayList subIfNums = new ArrayList();
        subIfNums.addAll(subIfMap.keySet());
        Collections.sort(subIfNums);
        for (int i = 0; i < subIfNums.size(); ++i) {
            Integer subIfNum = (Integer)subIfNums.get(i);
            if (subIfNums.size() - 1 == i) {
                return (Interface)subIfMap.get(subIfNum);
            }
            if (subIfNum == subIfNums.get(i + 1)) continue;
            return (Interface)subIfMap.get(subIfNum);
        }
        return null;
    }

    private Collection<Port> queryPortInfosInL3VPNByNeIDAndDeployStatus(int devID, Integer isDeploy) {
        ArrayList<L3vpnInstance> indexes = new ArrayList<L3vpnInstance>();
        L3vpnInstance index = new L3vpnInstance();
        index.setDevID(Integer.valueOf(devID));
        index.setDeployStatus(isDeploy);
        indexes.add(index);
        String[] fields = new String[]{"devID"};
        if (null != isDeploy) {
            fields = new String[]{"devID", "deployStatus"};
        }
        Collection list = null;
        try {
            InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
            list = dao.queryByFields(L3vpnInstance.class, fields, indexes, true);
        }
        catch (VMFException e) {
            this.logger.debug("Query queryEthPortListInPWByNEID is failed!" + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (L3vpnInstance ins : list) {
            Collection l3list = ins.getL3vpnIfs();
            if (CollectionUtils.isEmpty((Collection)l3list)) continue;
            for (L3vpnIf vpn : l3list) {
                if (nameList.contains(vpn.getIfName())) continue;
                nameList.add(vpn.getIfName());
            }
        }
        Collection<Port> ethList = this.getPortInfosByNeIDAndNameList(devID, nameList);
        return ethList;
    }

    private Collection<RemoteApIf> queryRemoteApInfos(Interface mo) {
        ArrayList<RemoteApIf> remoteApIndexes = new ArrayList<RemoteApIf>();
        RemoteApIf oRemoteApIf = new RemoteApIf();
        oRemoteApIf.setDevID(mo.getDevID());
        oRemoteApIf.setIfName(mo.getIfName());
        remoteApIndexes.add(oRemoteApIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "apIfName"};
        try {
            return dao.queryByFields(RemoteApIf.class, fieldNames, remoteApIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryRemoteApInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    private Collection<RemoteApIf> queryRemoteApInfos(VbridgeIf oVbridgeIf) {
        ArrayList<RemoteApIf> remoteApIndexes = new ArrayList<RemoteApIf>();
        for (VBridgeMemberIf oVBridgeMemberIf : oVbridgeIf.getVBridgeMemberIfs()) {
            RemoteApIf oRemoteApIf = new RemoteApIf();
            oRemoteApIf.setDevID(oVbridgeIf.getDevID());
            oRemoteApIf.setIfName(oVBridgeMemberIf.getMemberIfName());
            remoteApIndexes.add(oRemoteApIf);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "apIfName"};
        try {
            return dao.queryByFields(RemoteApIf.class, fieldNames, remoteApIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryRemoteApInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    private Collection<Interface> querySerialMos(Interface serialMoIndex) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(serialMoIndex.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)serialMoIndex, null);
        pollService.addQueryJob(queryContext);
        ArrayList<Interface> serialMos = new ArrayList();
        try {
            pollService.poll();
            serialMos = pollService.getQueryContext(serialMoIndex.getDevID().intValue()).getQueryResult(Interface.class);
        }
        catch (VMFException e) {
            this.logger.error("querySerialMos error. ", (Throwable)e);
            throw e;
        }
        return serialMos;
    }

    private Collection<VbridgeIf> queryVBridgeInfos(Interface mo) {
        Collection oVbridgeIfs = null;
        ArrayList<VbridgeIf> bridgeIndexes = new ArrayList<VbridgeIf>();
        VbridgeIf oVbridgeIf = new VbridgeIf();
        oVbridgeIf.setDevID(mo.getDevID());
        oVbridgeIf.setVbridgeIfName(mo.getIfName());
        bridgeIndexes.add(oVbridgeIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vbridgeIfName"};
        try {
            oVbridgeIfs = dao.queryByFields(VbridgeIf.class, fieldNames, bridgeIndexes, false);
            if (oVbridgeIfs.size() > 0) {
                oVbridgeIf = (VbridgeIf)oVbridgeIfs.iterator().next();
                Collection<VBridgeMemberIf> oVBridgeMemberIfs = this.queryVBridgeMemberInfos(oVbridgeIf);
                oVbridgeIf.addVBridgeMemberIfs(oVBridgeMemberIfs);
            }
        }
        catch (VMFException e) {
            this.logger.error("queryVBridgeInfos failed, queryByFields error.", (Throwable)e);
        }
        return oVbridgeIfs;
    }

    private Collection<VBridgeMemberIf> queryVBridgeMemberInfos(VbridgeIf mo) {
        ArrayList<VBridgeMemberIf> bridgeMemberIndexes = new ArrayList<VBridgeMemberIf>();
        VBridgeMemberIf oBridgeMemberIf = new VBridgeMemberIf();
        oBridgeMemberIf.setDevID(mo.getDevID());
        oBridgeMemberIf.setVbridgeIfName(mo.getVbridgeIfName());
        bridgeMemberIndexes.add(oBridgeMemberIf);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vbridgeIfName"};
        try {
            return dao.queryByFields(VBridgeMemberIf.class, fieldNames, bridgeMemberIndexes, false);
        }
        catch (VMFException e) {
            this.logger.error("queryVBridgeInfos failed, queryByFields error.", (Throwable)e);
            return null;
        }
    }

    private void reloadTerminationData(Class clazz, Context context) {
        HashSet<String> parentIndex = new HashSet<String>();
        HashSet<Integer> devIDs = new HashSet<Integer>();
        Set changeMos = context.getChangeRecord(clazz).getAllChanges();
        if (!CollectionUtils.isEmpty((Collection)changeMos)) {
            try {
                int devID;
                Context ctx = new Context();
                IMOChangeRecord changeRecord = ctx.addChangeRecord(clazz);
                DefaultMOService pollService = new DefaultMOService();
                for (VmfMO changemMo : changeMos) {
                    devID = changemMo.getDevID();
                    int vrID = changemMo.getVrID();
                    devIDs.add(devID);
                    String ifName = clazz.equals(QinqTerminate.class) ? ((QinqTerminate)changemMo).getIfName() : ((FlowDot1q)changemMo).getIfName();
                    String key = devID + vrID + ifName;
                    if (parentIndex.contains(key)) continue;
                    VmfMO condition = (VmfMO)clazz.newInstance();
                    condition.setDevID(Integer.valueOf(devID));
                    condition.setVrID(Integer.valueOf(vrID));
                    if (clazz.equals(QinqTerminate.class)) {
                        ((QinqTerminate)condition).setIfName(ifName);
                    } else {
                        ((FlowDot1q)condition).setIfName(ifName);
                    }
                    changeRecord.addDelete((Object)condition);
                    QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
                    queryContext.addQueryAttributes(FeatureName.ETHERNET, condition, null);
                    pollService.addQueryJob(queryContext);
                    parentIndex.add(key);
                }
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
                dao.merge(clazz, false);
                pollService.poll();
                ctx = new Context();
                changeRecord = ctx.addChangeRecord(clazz);
                Iterator i$ = devIDs.iterator();
                while (i$.hasNext()) {
                    devID = (Integer)i$.next();
                    Collection moFromDevs = pollService.getQueryContext(devID).getQueryResult(clazz);
                    for (VmfMO moFromDev : moFromDevs) {
                        String ifName;
                        String string = ifName = clazz.equals(QinqTerminate.class) ? ((QinqTerminate)moFromDev).getIfName() : ((FlowDot1q)moFromDev).getIfName();
                        if (!parentIndex.contains(moFromDev.getDevID() + moFromDev.getVrID() + ifName)) continue;
                        changeRecord.addCreate((Object)moFromDev);
                    }
                }
                dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
                dao.merge(clazz, false);
            }
            catch (InstantiationException e) {
                this.logger.error("updateQinqOrDot1q failed, InstantiationException error. clazz : " + clazz, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("updateQinqOrDot1q failed, IllegalAccessException error. clazz : " + clazz, (Throwable)e);
            }
            catch (VMFException e) {
                this.logger.error("updateQinqOrDot1q failed, VMFException error. clazz : " + clazz, (Throwable)e);
            }
        }
    }

    private Interface unDeployInterfaces(Interface mo) throws VMFException {
        Interface serialMo = this.getSerialMo(mo);
        if (null == serialMo) {
            return mo;
        }
        VmfMO cposOrE1Mo = InterfaceUtil.transSerialToCposOrE1(serialMo);
        this.deployCopsOrE1(cposOrE1Mo, EOperationType.DELETE);
        this.updateSerialMo(serialMo, EOperationType.DELETE);
        return mo;
    }

    private void updateSerialMo(Interface mo, EOperationType operationType) throws VMFException {
        try {
            InterfaceDao dao;
            Context ctx = new Context();
            IMOChangeRecord changeRecord = ctx.addChangeRecord(mo.getClass());
            ArrayList<Interface> mos = new ArrayList<Interface>();
            mos.add(mo);
            if (operationType == EOperationType.CREATE) {
                dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
                Collection moDbs = dao.queryByKey(Interface.class, Arrays.asList(mo), false);
                if (CollectionUtils.isEmpty((Collection)moDbs)) {
                    changeRecord.addCreate(mos);
                }
            } else if (operationType == EOperationType.DELETE) {
                changeRecord.addDelete(mos);
            } else {
                changeRecord.addModify((Object)mo, Arrays.asList("ifLinkProtocol"));
                mo.setDeployStatus(Integer.valueOf(1));
                changeRecord.addModify((Object)mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
            }
            dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(mo.getClass(), false);
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
            throw new VMFException(e.getErrorCode(), e.getErrorMessage());
        }
    }

    public Collection<LagMemberIf> queryLagByMemberIf(Collection<Interface> ifms) {
        ArrayList<LagMemberIf> resMap = new ArrayList<LagMemberIf>();
        if (CollectionUtils.isEmpty(ifms)) {
            return resMap;
        }
        ArrayList<LagMemberIf> lagMems = new ArrayList<LagMemberIf>();
        for (Interface ifm : ifms) {
            LagMemberIf memIf = new LagMemberIf();
            memIf.setDevID(ifm.getDevID());
            memIf.setVrID(ifm.getVrID());
            memIf.setIfName(ifm.getIfName());
            lagMems.add(memIf);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vrID", "ifName"};
        Collection lagRes = null;
        try {
            lagRes = dao.queryByFields(LagMemberIf.class, fieldNames, lagMems, false);
        }
        catch (VMFException e) {
            this.logger.error("deploy service error. ", (Throwable)e);
        }
        return lagRes;
    }

    public void checkIpAddressForL3vpn(List<Interface> interfaces, Object context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            ArrayList<Ipv4Address> ipv4AddressList = new ArrayList<Ipv4Address>();
            for (Interface inf : interfaces) {
                Ipv4Address ipv4Addresss = new Ipv4Address();
                ipv4Addresss.setDevID(inf.getDevID());
                ipv4Addresss.setVrID(inf.getVrID());
                ipv4Addresss.setIfName(inf.getIfName());
                ipv4AddressList.add(ipv4Addresss);
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            String[] fieldNames = new String[]{"devID", "vrID", "ifName"};
            try {
                Collection ipAddrMos = dao.queryByFields(Ipv4Address.class, fieldNames, ipv4AddressList, false);
                if (!CollectionUtils.isEmpty((Collection)ipAddrMos)) {
                    ((Context)context).getOperResult().addMoOperResults(interfaces, ErrorCode.VMF_ADP_IFM_IP_ADDRESS_CONFLICT.intValue());
                }
            }
            catch (VMFException e) {
                this.logger.error("InterfaceConflictChecker checkIPv4Exist is fail: " + (Object)((Object)e));
            }
        }
    }
}

