/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.extendpoint.l3vpn.task.ITaskSpecialAction;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.ErrorCode;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.sap.KeyRefMoConflictCheckProxy;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import com.huawei.vmf.extendpoint.framework.IApplyDifference;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class InterfaceConflictChecker
extends DefaultMOConflictChecker<Interface> {
    private String FLAG_L3VPN = "L3VPN";

    public InterfaceConflictChecker() {
        super(Interface.class);
    }

    public OperResult checkCreate(Collection<Interface> mos, Context context) {
        return this.checkPredeploy(mos, context);
    }

    public OperResult checkDelete(Collection<Interface> mos, Context context) {
        OperResult operResult = super.checkDelete(mos, context);
        this.addPhysicalAndSerialMoOperResultForPTN(mos, operResult, context);
        for (Interface mo : mos) {
            this.setKeyRefMoStatus(mo, 0);
        }
        return operResult;
    }

    public OperResult checkPredeploy(Collection<Interface> mos, Context context) {
        OperResult operResult = new OperResult();
        if (CollectionUtils.isEmpty(mos)) {
            return operResult;
        }
        Collection existMos = this.queryExists(mos, operResult);
        if (!EOperResultType.SUCCESS.equals((Object)operResult.getOperResult(mos))) {
            return operResult;
        }
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        Object itaskSpecialAction = ExtendPointServiceMgr.getInstance().getExtendPoitService(ITaskSpecialAction.class);
        if (null != interfaceUtilExtPoint) {
            Collection<Ipv4Address> ipAddrMos = this.checkIPv4Exist(mos, context);
            if (!CollectionUtils.isEmpty(ipAddrMos)) {
                operResult.addMoOperResults(existMos, ErrorCode.VMF_ADP_IFM_IP_ADDRESS_CONFLICT.intValue());
                return operResult;
            }
        } else if (null != itaskSpecialAction) {
            this.getLogger().debug("InterfaceConflictChecker checkPredeploy don't effect for RTN");
        } else {
            operResult.addMoOperResults(existMos, 0);
            context.addMoOperResults(existMos, 0);
        }
        ArrayList<Interface> notExistMos = new ArrayList<Interface>(mos);
        ArrayList<Interface> unHandleMos = new ArrayList<Interface>();
        notExistMos.removeAll(existMos);
        for (Interface notExistMo : notExistMos) {
            if (InterfaceUtil.isPhysicalMainType(notExistMo)) {
                operResult.addMoOperResult((VmfMO)notExistMo, 1107499885);
                continue;
            }
            unHandleMos.add(notExistMo);
        }
        for (Interface mo : unHandleMos) {
            this.checkKeyRefMo(mo, operResult);
        }
        this.checkCposOrE1Port(mos, operResult, context);
        return operResult;
    }

    public OperResult checkUndeploy(Collection<Interface> mos, Context context) {
        OperResult operResult = super.checkUndeploy(mos, context);
        this.addPhysicalAndSerialMoOperResult(mos, operResult, context);
        return operResult;
    }

    public void setDeployStatus(Collection<Interface> originalMos, Collection<Interface> queryMos) {
        if (CollectionUtils.isEmpty(queryMos)) {
            return;
        }
        if (!(queryMos.iterator().next() instanceof DeployableMO)) {
            return;
        }
        block0: for (Interface queryMo : queryMos) {
            for (Interface originalMo : originalMos) {
                if (!originalMo.equals((Object)queryMo)) continue;
                if (queryMo.getDeployStatus() == originalMo.getDeployStatus()) continue block0;
                Integer iDeployStatus = queryMo.getDeployStatus();
                originalMo.setDeployStatus(iDeployStatus);
                this.setKeyRefMoStatus(originalMo, iDeployStatus);
                continue block0;
            }
        }
    }

    private void addPhysicalAndSerialMoOperResult(Collection<Interface> mos, OperResult operResult, Context context) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        IApplyDifference appDiff = (IApplyDifference)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IApplyDifference.class);
        for (Interface mo : mos) {
            int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
            if (!InterfaceUtil.isPhysicalMainType(mo) && 65543 != ifType && 2051 != ifType && (65559 != ifType || null == appDiff || appDiff.isEthSubIfSupportDelete())) continue;
            operResult.addMoOperResult((VmfMO)mo, 0);
            context.addMoOperResult((VmfMO)mo, 0);
        }
    }

    private void addPhysicalAndSerialMoOperResultForPTN(Collection<Interface> mos, OperResult operResult, Context context) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        IApplyDifference appDiff = (IApplyDifference)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IApplyDifference.class);
        HashMap<String, Interface> moMap = new HashMap<String, Interface>();
        for (Interface mo : mos) {
            moMap.put(mo.getDevID() + "_" + mo.getVrID() + "_" + mo.getIfName(), mo);
        }
        for (String key : moMap.keySet()) {
            Interface mo = (Interface)moMap.get(key);
            int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
            if (!InterfaceUtil.isPhysicalMainType(mo) && 65543 != ifType && 2051 != ifType && (65559 != ifType || null == appDiff || appDiff.isEthSubIfSupportDelete())) continue;
            Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != interfaceUtilExtPoint) {
                this.deleteIPv4(mo, operResult, context);
                continue;
            }
            operResult.addMoOperResult((VmfMO)mo, 0);
            context.addMoOperResult((VmfMO)mo, 0);
        }
    }

    private void checkCposOrE1Port(Collection<Interface> mos, OperResult operResult, Context context) {
        for (Interface mo : mos) {
            List cposOrE1Ports = mo.getKeyRefMos(InterfaceUtil.getCesClass(mo));
            if (CollectionUtils.isEmpty((Collection)cposOrE1Ports)) continue;
            operResult.addMoOperResults((Collection)cposOrE1Ports, 0);
            context.addMoOperResults((Collection)cposOrE1Ports, 0);
        }
    }

    private Collection<Ipv4Address> checkIPv4Exist(Collection<Interface> mos, Context context) {
        Collection res = null;
        IMOChangeRecord moChanged = context.getChangeRecord(Ipv4Address.class);
        Set createMos = moChanged.getCreates();
        if (CollectionUtils.isEmpty((Collection)createMos)) {
            return res;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = ((Ipv4Address)createMos.iterator().next()).getClass();
        String[] fieldNames = new String[]{"devID", "vrID", "ifName"};
        try {
            res = dao.queryByFields(clazz, fieldNames, (Collection)createMos, false);
        }
        catch (VMFException e) {
            this.getLogger().debug("InterfaceConflictChecker checkIPv4Exist is fail: " + (Object)((Object)e));
        }
        return res;
    }

    private void checkKeyRefMo(Interface mo, OperResult operResult) {
        Map keyRefMoMap = mo.getKeyRefMos();
        for (Map.Entry entry : keyRefMoMap.entrySet()) {
            Class clazz = (Class)entry.getKey();
            List listMos = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)listMos)) continue;
            VmfMO keyRefMo = (VmfMO)listMos.iterator().next();
            KeyRefMoConflictCheckProxy refChecker = new KeyRefMoConflictCheckProxy(clazz);
            refChecker.checkPreDeploy(mo, keyRefMo, operResult);
        }
    }

    private void deleteIPv4(Interface mo, OperResult operResult, Context context) {
        Object vpnObj = context.getProperty(this.FLAG_L3VPN);
        if (null == mo || CollectionUtils.isEmpty((Collection)mo.getIpv4Addresss()) || null != mo.getIfName() && null != mo.getiQIfType() && !InterfaceUtil.isPhysicalMainType(mo) && null == vpnObj) {
            operResult.addMoOperResult((VmfMO)mo, 0);
            context.addMoOperResult((VmfMO)mo, 0);
            return;
        }
        IMOChangeRecord ifDBRecorder = context.addDBChangeRecord(mo.getClass());
        ifDBRecorder.cancelDelete((Object)mo);
        IMOChangeRecord dbRecode = context.addDBChangeRecord(Ipv4Address.class);
        dbRecode.addDelete(mo.getIpv4Addresss());
        ifDBRecorder.addModify((Object)mo, new PropertyChangeItem("ipv4Addresss"));
        IMOChangeRecord ifRecorder = context.addChangeRecord(mo.getClass());
        ifRecorder.cancelDelete((Object)mo);
    }

    private void setKeyRefMoStatus(Interface originalMo, Integer iDeployStatus) {
        Map allKeyRefMos = originalMo.getKeyRefMos();
        for (Map.Entry keyRefMosEntry : allKeyRefMos.entrySet()) {
            List keyRefMos = (List)keyRefMosEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)keyRefMos) || !(keyRefMos.iterator().next() instanceof DeployableMO)) continue;
            ((DeployableMO)keyRefMos.iterator().next()).setDeployStatus(iDeployStatus);
        }
    }
}

