/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class InterfaceCompositeService
extends AbstractCompositeService<Interface> {
    public InterfaceCompositeService(Class<Interface> moClazz) {
        super(moClazz);
    }

    protected void syncDevMoInfos(List<Interface> mos, Context context) {
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<Interface>> mapMos = this.sortMosByDevID(mos);
        Collection<String> attriButes = this.getAttriButes();
        for (Map.Entry<Integer, List<Interface>> entry : mapMos.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (Interface mo : entry.getValue()) {
                queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)mo, attriButes);
            }
            pollService.addQueryJob(queryContext);
        }
        try {
            pollService.poll();
        }
        catch (VMFException e) {
            this.getLogger().debug("pollService failed!" + e.toString());
            return;
        }
        List<Interface> needUpdateMos = this.getpollResutlMo((IMOService)pollService, mapMos);
        this.updateMosInDB(needUpdateMos, context);
    }

    private Collection<String> getAttriButes() {
        return CommonUtil.genList((Object[])new String[]{"ifMac", "ifIndex", "ifOperSpeed"});
    }

    private List<Interface> getpollResutlMo(IMOService pollService, Map<Integer, List<Interface>> mapMos) {
        ArrayList<Interface> resultMos = new ArrayList<Interface>();
        for (Map.Entry<Integer, List<Interface>> entry : mapMos.entrySet()) {
            QuerySchemaTranslatorContext result = pollService.getQueryContext(entry.getKey().intValue());
            Collection queryResult = result.getQueryResult(Interface.class);
            if (null == queryResult || CollectionUtils.isEmpty((Collection)queryResult)) continue;
            resultMos.addAll(queryResult);
        }
        return resultMos;
    }

    private Map<Integer, List<Interface>> sortMosByDevID(List<Interface> mos) {
        HashMap<Integer, List<Interface>> mapMos = new HashMap<Integer, List<Interface>>();
        if (CollectionUtils.isEmpty(mos)) {
            return mapMos;
        }
        for (Interface mo : mos) {
            if (mapMos.containsKey(mo.getDevID())) {
                ((List)mapMos.get(mo.getDevID())).add(mo);
                continue;
            }
            ArrayList<Interface> lstMos = new ArrayList<Interface>();
            lstMos.add(mo);
            mapMos.put(mo.getDevID(), lstMos);
        }
        return mapMos;
    }

    private void updateMosInDB(List<Interface> needUpdateMos, Context context) {
        IMOChangeRecord rcd = context.getChangeRecord(Interface.class);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
        Collection<String> attriButes = this.getAttriButes();
        for (Interface mo : needUpdateMos) {
            rcd.addModify((Object)mo, attriButes);
        }
        try {
            dao.merge(Interface.class, false);
        }
        catch (VMFException e) {
            this.getLogger().debug("merge mos in DB failed!" + e.toString());
        }
    }
}

