/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.sap;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.sap.IQAsnGetSap;
import com.huawei.vmf.adapter.ifm.sap.QAsnGetSapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class QAsnGetSap {
    private InterfaceFdnParser interfaceFdnFarser = new InterfaceFdnParser();

    public Collection<Interface> query(List<QAsnUniResID> lstkey) throws VMFException {
        ArrayList<Interface> lstIndex = new ArrayList<Interface>();
        for (QAsnUniResID res : lstkey) {
            Interface mo = this.interfaceFdnFarser.getIndexMo(StringUtil.globalString((byte[])res.strFDN));
            lstIndex.add(mo);
        }
        return this.queryByInterface(lstIndex);
    }

    public Collection<Interface> queryByInterface(Collection<Interface> lstIndex) throws VMFException {
        HashMap<Integer, List<Interface>> mapTypeAndKeyLst = new HashMap<Integer, List<Interface>>();
        ArrayList<Interface> result = new ArrayList<Interface>();
        if (CollectionUtils.isEmpty(lstIndex)) {
            return result;
        }
        for (Interface interface_ : lstIndex) {
            Integer type = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)interface_.getIfName());
            this.addMo(type, interface_, mapTypeAndKeyLst);
        }
        for (Map.Entry entry : mapTypeAndKeyLst.entrySet()) {
            IQAsnGetSap sapAdaptor = QAsnGetSapFactory.getInstance().getSapAdaptor((Integer)entry.getKey());
            Collection<Interface> ifs = sapAdaptor.getSapDetailInfo((List)entry.getValue());
            for (Interface inter : ifs) {
                for (Interface oldIf : (List)entry.getValue()) {
                    if (inter.getFdn() == null || oldIf.getFdn() == null || !inter.getFdn().equals(oldIf.getFdn()) || inter.getKeyRefMos(EthSubIf.class).size() == oldIf.getKeyRefMos(EthSubIf.class).size()) continue;
                    for (EthSubIf subif : oldIf.getKeyRefMos(EthSubIf.class)) {
                        inter.addKeyRefMo((VmfMO)subif);
                    }
                }
            }
            result.addAll(ifs);
        }
        return result;
    }

    private void addMo(Integer type, Interface mo, Map<Integer, List<Interface>> mapTypeAndKeyLst) {
        if (mapTypeAndKeyLst.containsKey(type)) {
            List<Interface> ifs = mapTypeAndKeyLst.get(type);
            ifs.add(mo);
        } else {
            ArrayList<Interface> ifs = new ArrayList<Interface>();
            ifs.add(mo);
            mapTypeAndKeyLst.put(type, ifs);
        }
    }
}

