/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.sap;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.sap.DefaultQAsnGetSap;
import com.huawei.vmf.common.tool.BitMapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class QAsnGetEthSap
extends DefaultQAsnGetSap {
    @Override
    public void getRefMos(Collection<Interface> infs) throws VMFException {
        ArrayList<EthSubIf> ethSubIfKeys = new ArrayList<EthSubIf>();
        for (Interface ifinfo : infs) {
            EthSubIf mo = new EthSubIf();
            mo.setDevID(ifinfo.getDevID());
            mo.setVrID(ifinfo.getVrID());
            mo.setIfName(ifinfo.getIfName());
            ethSubIfKeys.add(mo);
        }
        Collection subifs = DaoFactory.getInstance().getDefaultVmfDao(null).queryByKey(EthSubIf.class, ethSubIfKeys, true);
        for (EthSubIf subif : subifs) {
            String dot1qBitmapToDb = subif.getDot1qBitmapToDb();
            if (null == dot1qBitmapToDb) continue;
            subif.setDot1qBitmap(BitMapUtil.convertToNeValue((String)dot1qBitmapToDb, null, (int)4096));
        }
        for (Interface ifinfo : infs) {
            for (EthSubIf singleSubif : subifs) {
                if (ifinfo.getDevID().intValue() != singleSubif.getDevID().intValue() || !ifinfo.getIfName().equals(singleSubif.getIfName()) || ifinfo.getVrID().intValue() != singleSubif.getVrID().intValue()) continue;
                singleSubif.setDeployStatus(ifinfo.getDeployStatus());
            }
        }
        HashMap<Pair, EthSubIf> mapSubIf = new HashMap<Pair, EthSubIf>();
        for (EthSubIf sub : subifs) {
            Pair key = new Pair((Object)sub.getDevID(), (Object)sub.getIfName());
            mapSubIf.put(key, sub);
        }
        Pair tmpKey = new Pair((Object)0, (Object)String.valueOf(""));
        for (Interface inf : infs) {
            tmpKey.setKey((Object)inf.getDevID());
            tmpKey.setValue((Object)inf.getIfName());
            if (!mapSubIf.containsKey(tmpKey)) continue;
            inf.addKeyRefMo((VmfMO)mapSubIf.get(tmpKey));
        }
    }
}

