/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.sap;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.ifm.sap.IEthKeyRefConflictCheckerExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqTerminate;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.ErrorCode;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.sap.IKeyRefMoConflictChecker;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EthKeyRefConflictChecker
implements IKeyRefMoConflictChecker {
    private static final Logger logger = LoggerFactory.getLogger(EthKeyRefConflictChecker.class);

    @Override
    public void checkPreDeploy(Interface mo, VmfMO keyRefMo, OperResult operResult) {
        if (null == keyRefMo) {
            logger.debug("keyRef Mo is null!");
            return;
        }
        Object ethKeyRefConflictCheckerExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IEthKeyRefConflictCheckerExtPoint.class);
        if (null != ethKeyRefConflictCheckerExtPoint) {
            Collection<Interface> subIfs = this.getSubIfsUnderOneMainIf(mo);
            ((IEthKeyRefConflictCheckerExtPoint)ethKeyRefConflictCheckerExtPoint).checkConflict(mo, keyRefMo, subIfs, operResult);
        } else if (EthSubIf.FLOW_TYPE_ENUM.VLAN_TYPE.equals(((EthSubIf)keyRefMo).getFlowType())) {
            this.checkVlanIDConflict(mo, keyRefMo, operResult);
        } else {
            this.checkQinqConflict(mo, keyRefMo, operResult);
        }
    }

    private void checkCePeVid(Interface mo, VmfMO keyRefMo, Collection<Interface> subIfs, OperResult operResult) {
        if (CollectionUtils.isEmpty(subIfs)) {
            return;
        }
        Collection flows = ((EthSubIf)keyRefMo).getQinqTerminates();
        if (CollectionUtils.isEmpty((Collection)flows)) {
            return;
        }
        HashMap<Integer, List<Pair<Integer, Integer>>> srcVlans = new HashMap<Integer, List<Pair<Integer, Integer>>>();
        this.getVlansMap(flows, srcVlans);
        HashMap<Integer, List<Pair<Integer, Integer>>> vlanSets = new HashMap<Integer, List<Pair<Integer, Integer>>>();
        for (Interface ifn : subIfs) {
            Collection flowIdentifys;
            Map keyRef = ifn.getKeyRefMos();
            List refMoList = (List)keyRef.get(EthSubIf.class);
            if (CollectionUtils.isEmpty((Collection)refMoList) || CollectionUtils.isEmpty((Collection)(flowIdentifys = ((EthSubIf)refMoList.iterator().next()).getQinqTerminates()))) continue;
            this.getVlansMap(flowIdentifys, vlanSets);
        }
        this.checkVlanBound(mo, (EthSubIf)keyRefMo, srcVlans, vlanSets, operResult);
    }

    private void checkConflict(Interface mo, VmfMO keyRefMo, Collection<Interface> subIfs, OperResult operResult) {
        EthSubIf eth = (EthSubIf)keyRefMo;
        Integer iVlan = eth.getVlanTypeVid();
        if (null == iVlan) {
            logger.debug("vlan ID is null!");
            return;
        }
        HashSet<Integer> vlans = new HashSet<Integer>();
        for (Interface iter : subIfs) {
            List refMoList;
            Map keyRef = iter.getKeyRefMos();
            if (!keyRef.containsKey(EthSubIf.class) || CollectionUtils.isEmpty((Collection)(refMoList = (List)keyRef.get(EthSubIf.class)))) continue;
            Integer iDot1q = ((EthSubIf)refMoList.iterator().next()).getVlanTypeVid();
            vlans.add(iDot1q);
        }
        if (vlans.contains(iVlan)) {
            operResult.addMoOperResult((VmfMO)mo, ErrorCode.EML_NEIF_ERROR_SAPVERIFY_VLANID_CONFLICT.intValue());
        }
    }

    private void checkQinqConflict(Interface mo, VmfMO keyRefMo, OperResult operResult) {
        Collection<Interface> subIfs = this.getSubIfsUnderOneMainIf(mo);
        this.checkCePeVid(mo, keyRefMo, subIfs, operResult);
    }

    private void checkVlanBound(Interface mo, EthSubIf keyRefMo, Map<Integer, List<Pair<Integer, Integer>>> srcVlans, Map<Integer, List<Pair<Integer, Integer>>> vlanSets, OperResult operResult) {
        for (Map.Entry<Integer, List<Pair<Integer, Integer>>> entry : srcVlans.entrySet()) {
            List<Pair<Integer, Integer>> list;
            List<Pair<Integer, Integer>> value;
            Integer peVlan = entry.getKey();
            if (!vlanSets.containsKey(peVlan) || !this.isCeVlanConflict(value = entry.getValue(), list = vlanSets.get(peVlan))) continue;
            Integer err = this.getConflictErrorCode(keyRefMo.getFlowType());
            operResult.addMoOperResult((VmfMO)mo, err.intValue());
            return;
        }
    }

    private void checkVlanIDConflict(Interface mo, VmfMO keyRefMo, OperResult operResult) {
        Collection<Interface> subIfs = this.getSubIfsUnderOneMainIf(mo);
        this.checkConflict(mo, keyRefMo, subIfs, operResult);
    }

    private Integer getConflictErrorCode(Integer integer) {
        if (null == integer || EthSubIf.FLOW_TYPE_ENUM.STACKING.equals(integer)) {
            return ErrorCode.EML_NEIF_ERROR_SAPVERIFY_STACKVLANID_CONFLICT;
        }
        if (EthSubIf.FLOW_TYPE_ENUM.QIN_QTERM.equals(integer)) {
            return ErrorCode.EML_NEIF_ERROR_SAPVERIFY_QINQCVLANID_CONFLICT;
        }
        if (EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM.equals(integer)) {
            return ErrorCode.EML_NEIF_ERROR_SAPVERIFY_DOT1QVLANID_CONFLICT;
        }
        return ErrorCode.EML_NEIF_ERROR_SAPVERIFY_STACKVLANID_CONFLICT;
    }

    private Collection<Interface> getSubIfsUnderOneMainIf(Interface mo) {
        Interface parentMo = new Interface();
        parentMo.setDevID(mo.getDevID());
        parentMo.setVrID(mo.getVrID());
        parentMo.setIfName(mo.getIfParentIfName());
        ArrayList<Interface> index = new ArrayList<Interface>();
        index.add(parentMo);
        ArrayList<Interface> subIfs = new ArrayList();
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        try {
            subIfs = dao.querySubIfByMainIf(index);
        }
        catch (VMFException e) {
            logger.error("failed to querySubIfByMainIf!", (Throwable)e);
        }
        return subIfs;
    }

    private void getVlansMap(Collection<QinqTerminate> flows, Map<Integer, List<Pair<Integer, Integer>>> srcVlans) {
        for (QinqTerminate flow : flows) {
            if (!InterfaceUtil.isValid(flow.getCeVlanIdBgn().intValue()) || !InterfaceUtil.isValid(flow.getCeVlanIdEnd())) continue;
            Pair ceVlan = new Pair((Object)flow.getCeVlanIdBgn().intValue(), (Object)flow.getCeVlanIdEnd());
            Integer peVid = -1;
            if (InterfaceUtil.isValid(flow.getPeVlanIdBgn())) {
                peVid = flow.getPeVlanIdBgn();
            }
            if (srcVlans.containsKey(peVid)) {
                srcVlans.get(peVid).add((Pair<Integer, Integer>)ceVlan);
                continue;
            }
            srcVlans.put(peVid, CommonUtil.genList((Object[])new Pair[]{ceVlan}));
        }
    }

    private boolean isCeVlanConflict(List<Pair<Integer, Integer>> value, List<Pair<Integer, Integer>> list) {
        for (Pair<Integer, Integer> cevlan : value) {
            for (Pair<Integer, Integer> dst : list) {
                if (((Integer)cevlan.getKey() > (Integer)dst.getKey() || (Integer)cevlan.getValue() < (Integer)dst.getKey()) && ((Integer)cevlan.getKey() < (Integer)dst.getKey() || (Integer)cevlan.getKey() > (Integer)dst.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

