/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.sap;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvc;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvp;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.ErrorCode;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.sap.IKeyRefMoConflictChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AtmKeyRefConflictChecker
implements IKeyRefMoConflictChecker {
    private static final Logger logger = LoggerFactory.getLogger(AtmKeyRefConflictChecker.class);

    @Override
    public void checkPreDeploy(Interface mo, VmfMO keyRefMo, OperResult operResult) {
        if (null == keyRefMo) {
            logger.debug("keyRef mo is null");
            return;
        }
        AtmInterface refMo = (AtmInterface)keyRefMo;
        Collection<Interface> subIfs = this.getSubIfsUnderOneMainIf(mo);
        HashMap<Pair<Long, Long>, Boolean> mapPvcs = new HashMap<Pair<Long, Long>, Boolean>();
        HashMap<Long, Boolean> mapPvps = new HashMap<Long, Boolean>();
        this.getPvcPvp(subIfs, mapPvcs, mapPvps);
        Collection curPvcs = refMo.getAtmPvcs();
        if (!CollectionUtils.isEmpty((Collection)curPvcs)) {
            if (this.isPvcContainInMap(curPvcs, mapPvcs)) {
                operResult.addMoOperResult((VmfMO)mo, ErrorCode.EML_NEIF_ERROR_SAPVERIFY_PVC_CONFLICT.intValue());
            }
            return;
        }
        Collection curPvps = refMo.getAtmPvps();
        if (!CollectionUtils.isEmpty((Collection)curPvps) && this.isPvpContainInMap(curPvps, mapPvps)) {
            operResult.addMoOperResult((VmfMO)mo, ErrorCode.EML_NEIF_ERROR_SAPVERIFY_PVP_CONFLICT.intValue());
        }
    }

    private void getPvcPvp(Collection<Interface> subIfs, Map<Pair<Long, Long>, Boolean> mapPvcs, Map<Long, Boolean> mapPvps) {
        if (CollectionUtils.isEmpty(subIfs)) {
            return;
        }
        Boolean bUseless = Boolean.TRUE;
        for (Interface sub : subIfs) {
            Collection pvps;
            List keyRefList = sub.getKeyRefMos(AtmInterface.class);
            if (CollectionUtils.isEmpty((Collection)keyRefList)) continue;
            AtmInterface tempKeyRef = (AtmInterface)keyRefList.iterator().next();
            Collection pvcs = tempKeyRef.getAtmPvcs();
            if (!CollectionUtils.isEmpty((Collection)pvcs)) {
                for (AtmPvc pvc : pvcs) {
                    Pair key = new Pair((Object)pvc.getVpi(), (Object)pvc.getVci());
                    mapPvcs.put((Pair<Long, Long>)key, bUseless);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(pvps = tempKeyRef.getAtmPvps()))) continue;
            for (AtmPvp pvp : pvps) {
                mapPvps.put(pvp.getVpi(), bUseless);
            }
        }
    }

    private Collection<Interface> getSubIfsUnderOneMainIf(Interface mo) {
        Collection<Interface> subIfs = new ArrayList<Interface>();
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        try {
            subIfs = dao.querySubIfByMainIf(CommonUtil.genList((Object[])new Interface[]{mo}));
        }
        catch (VMFException e) {
            logger.error("failed to querySubIfByMainIf!", (Throwable)e);
        }
        return subIfs;
    }

    private boolean isPvcContainInMap(Collection<AtmPvc> curPvcs, Map<Pair<Long, Long>, Boolean> mapPvcs) {
        if (CollectionUtils.isEmpty(curPvcs)) {
            return false;
        }
        for (AtmPvc pvc : curPvcs) {
            Pair key = new Pair((Object)pvc.getVpi(), (Object)pvc.getVci());
            if (!mapPvcs.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isPvpContainInMap(Collection<AtmPvp> curPvps, Map<Long, Boolean> mapPvps) {
        if (CollectionUtils.isEmpty(curPvps)) {
            return false;
        }
        for (AtmPvp pvp : curPvps) {
            if (!mapPvps.containsKey(pvp.getVpi())) continue;
            return true;
        }
        return false;
    }
}

